/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.szboanda.android.platform.activity.OpenEncryptBridgeActivity;
import com.szboanda.android.platform.util.DateUtils;
import com.szboanda.android.platform.util.PinyinUtils;
import com.szboanda.android.platform.util.ResourceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class FileUtils {
    public static final String INVALID_CHAR = "/\\:*?<>|\"";
    public static final String MIME_TYPE_APK = "application/vnd.android.package-archive";
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String MIME_TYPE_IMAGE = "image/*";
    public static final String MIME_TYPE_TXT = "text/plain";
    public static final String MIME_TYPE_WORD = "application/msword";
    public static final String MIME_TYPE_EXCEL = "application/vnd.ms-excel";
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String MIME_TYPE_POWER_POINT = "application/vnd.ms-powerpoint";
    public static final String MIME_TYPE_VIDEO = "video/*";
    public static final String MIME_TYPE_AUDIO = "audio/*";
    public static final String MIME_TYPE_CHM = "application/x-chm";

    public static Intent openFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String name = file.getName();
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        String suffix = name.substring(lastDotIndex + 1).toLowerCase(Locale.getDefault());
        if ("m4a".equals(suffix) || "mp3".equals(suffix) || "mid".equals(suffix) || "xmf".equals(suffix) || "ogg".equals(suffix) || "wav".equals(suffix) || "amr".equals(suffix) || "3gpp".equals(suffix)) {
            return FileUtils.getAudioFileIntent(filePath);
        }
        if (suffix.equals("3gp") || suffix.equals("mp4")) {
            return FileUtils.getVideoFileIntent(filePath);
        }
        if ("jpg".equals(suffix) || "gif".equals(suffix) || "png".equals(suffix) || "jpeg".equals(suffix) || "bmp".equals(suffix)) {
            return FileUtils.getImageFileIntent(filePath);
        }
        if ("apk".equals(suffix)) {
            return FileUtils.getApkFileIntent(filePath);
        }
        if ("ppt".equals(suffix) || "pptx".equals(suffix)) {
            return FileUtils.getPptFileIntent(filePath);
        }
        if ("xls".equals(suffix) || "xlsx".equals(suffix)) {
            return FileUtils.getExcelFileIntent(filePath);
        }
        if ("docx".equals(suffix) || "doc".equals(suffix)) {
            return FileUtils.getWordFileIntent(filePath);
        }
        if ("pdf".equals(suffix)) {
            return FileUtils.getPdfFileIntent(filePath);
        }
        if ("chm".equals(suffix)) {
            return FileUtils.getChmFileIntent(filePath);
        }
        if ("txt".equals(suffix)) {
            return FileUtils.getTextFileIntent(filePath, false);
        }
        if ("htm".equals(suffix) || "html".equals(suffix) || "php".equals(suffix) || "jsp".equals(suffix)) {
            return FileUtils.getHtmlFileIntent(filePath);
        }
        return null;
    }

    public static Intent getApkFileIntent(String filePath) {
        return FileUtils.getFileIntent(filePath, MIME_TYPE_APK);
    }

    public static Intent getVideoFileIntent(String filePath) {
        Intent intent = FileUtils.getFileIntent(filePath, MIME_TYPE_VIDEO);
        intent.addFlags(0x4000000);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        return intent;
    }

    public static Intent getAudioFileIntent(String filePath) {
        Intent intent = FileUtils.getFileIntent(filePath, MIME_TYPE_AUDIO);
        intent.addFlags(0x4000000);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        return intent;
    }

    public static Intent getHtmlFileIntent(String param) {
        Uri uri = Uri.parse((String)param).buildUpon().encodedAuthority("com.android.htmlfileprovider").scheme("content").encodedPath(param).build();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, MIME_TYPE_HTML);
        return intent;
    }

    public static Intent getImageFileIntent(String filePath) {
        return FileUtils.getFileIntent(filePath, MIME_TYPE_IMAGE);
    }

    public static Intent getPptFileIntent(String filePath) {
        return FileUtils.getFileIntent(filePath, MIME_TYPE_POWER_POINT);
    }

    public static Intent getExcelFileIntent(String filePath) {
        return FileUtils.getFileIntent(filePath, MIME_TYPE_EXCEL);
    }

    public static Intent getWordFileIntent(String filePath) {
        return FileUtils.getFileIntent(filePath, MIME_TYPE_WORD);
    }

    public static Intent getChmFileIntent(String filePath) {
        return FileUtils.getFileIntent(filePath, MIME_TYPE_CHM);
    }

    public static Intent getTextFileIntent(String param, boolean paramBoolean) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        if (paramBoolean) {
            Uri uri1 = Uri.parse((String)param);
            intent.setDataAndType(uri1, MIME_TYPE_TXT);
        } else {
            Uri uri2 = Uri.fromFile((File)new File(param));
            intent.setDataAndType(uri2, MIME_TYPE_TXT);
        }
        return intent;
    }

    public static Intent getPdfFileIntent(String filePath) {
        Intent intent = new Intent("szboanda.action.view.pdf");
        Uri uri = Uri.fromFile((File)new File(filePath));
        intent.setDataAndType(uri, MIME_TYPE_PDF);
        return intent;
    }

    public static Intent getFileIntent(String filePath, String mimeType) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        Uri uri = Uri.fromFile((File)new File(filePath));
        intent.setDataAndType(uri, mimeType);
        return intent;
    }

    public static boolean fileExist(String filePath) {
        return new File(filePath).exists();
    }

    public static void copyFile(String filePath, String newPath) {
        if (!TextUtils.isEmpty((CharSequence)filePath) && !TextUtils.isEmpty((CharSequence)newPath)) {
            BufferedOutputStream bops = null;
            BufferedInputStream bips = null;
            FileInputStream ins = null;
            File outFile = new File(newPath);
            try {
                if (!outFile.getParentFile().isDirectory()) {
                    outFile.getParentFile().mkdirs();
                } else if (!outFile.exists()) {
                    outFile.createNewFile();
                }
                ins = new FileInputStream(filePath);
                bips = new BufferedInputStream(ins);
                bops = new BufferedOutputStream(new FileOutputStream(outFile));
                byte[] buffer = new byte[2048];
                int readLen = -1;
                while ((readLen = bips.read(buffer)) != -1) {
                    bops.write(buffer, 0, readLen);
                }
                bops.flush();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException("create file to [" + newPath + "] error:", e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeInputStream(ins);
                    FileUtils.closeInputStream(bips);
                    FileUtils.closeOutputStream(bops);
                    throw throwable;
                }
            }
            FileUtils.closeInputStream(ins);
            FileUtils.closeInputStream(bips);
            FileUtils.closeOutputStream(bops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(InputStream ins, String filePath) {
        if (ins != null && !TextUtils.isEmpty((CharSequence)filePath)) {
            BufferedOutputStream bops = null;
            BufferedInputStream bips = null;
            try {
                int len;
                bips = new BufferedInputStream(ins);
                bops = new BufferedOutputStream(new FileOutputStream(filePath));
                byte[] buffer = new byte[2048];
                while ((len = bips.read()) != -1) {
                    bops.write(buffer, 0, len);
                }
                bops.flush();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtils.closeInputStream(bips);
                    FileUtils.closeOutputStream(bops);
                    throw throwable;
                }
                FileUtils.closeInputStream(bips);
                FileUtils.closeOutputStream(bops);
            }
            FileUtils.closeInputStream(bips);
            FileUtils.closeOutputStream(bops);
        }
    }

    public static File createFile(String path, InputStream in, int totalBytes) {
        File file = new File(path);
        try {
            if (file.exists()) {
                file.delete();
            } else {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (totalBytes > 0) {
            try {
                FileOutputStream fos = new FileOutputStream(path);
                int len = -1;
                byte[] buffer = FileUtils.getBuffer(totalBytes);
                while (totalBytes > 0 && (len = in.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                    buffer = FileUtils.getBuffer(totalBytes -= len);
                }
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static byte[] getBuffer(int totalBytes) {
        int len = 8192;
        if (totalBytes > 0 && totalBytes < len) {
            len = totalBytes;
        }
        return new byte[len];
    }

    private static File createLogFile() {
        File file;
        String currentDate = DateUtils.formatDate(new Date(), "yyyyMMdd");
        String savePath = Environment.getExternalStorageDirectory() + "/Boanda";
        String filePath = savePath + "/" + currentDate + ".txt";
        File dir = new File(savePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(filePath)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                file = null;
            }
        }
        return file;
    }

    public static boolean saveLog(String log) {
        File logFile = FileUtils.createLogFile();
        if (logFile == null) {
            return false;
        }
        String currentTime = DateUtils.formatDate(new Date(), "HH:mm:ss");
        log = currentTime + "\t" + log + "\n";
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(logFile, true));
            printWriter.write(log);
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static synchronized boolean saveError(Throwable error) {
        File logFile = FileUtils.createLogFile();
        if (logFile == null) {
            return false;
        }
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(logFile, true));
            printStream.println(DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            error.printStackTrace(printStream);
            printStream.flush();
            printStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void deleteFiles(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteFile(String matchStr, String unMatchStr, String dirPath) {
        File[] fileList;
        File dir = new File(dirPath);
        for (File file : fileList = dir.listFiles()) {
            String tempFileName = file.getName();
            if (!tempFileName.contains(matchStr) || tempFileName.contains(unMatchStr)) continue;
            file.delete();
        }
    }

    public static void deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                FileUtils.deleteDirectory(fs[i]);
            }
        } else {
            file.delete();
        }
    }

    public static String getSuffixName(String name) {
        return name.substring(0, name.lastIndexOf("."));
    }

    public static boolean validFileName(String fileName) {
        String regex = "[/\\:*?<>|\"]+";
        return fileName.matches(regex);
    }

    public static boolean createFileByContent(String savePath, String name, String content) {
        return FileUtils.createFileByContent(savePath, name, content, false);
    }

    public static boolean createFileByContent(String savePath, String name, String content, boolean append) {
        try {
            FileOutputStream fOut = null;
            File dir = new File(savePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(savePath + File.separator + name);
            fOut = new FileOutputStream(file, append);
            if (content == null) {
                content = "";
            }
            fOut.write(content.getBytes());
            fOut.flush();
            fOut.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveBitmap(String savePath, String name, Bitmap bitmap, int quality) {
        FileOutputStream fOut = null;
        try {
            File dir = new File(savePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(savePath + File.separator + name);
            fOut = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtils.closeOutputStream(fOut);
            return false;
        }
    }

    public static boolean saveBitmap(String savePath, String name, Bitmap bitmap) {
        FileOutputStream fOut = null;
        try {
            File dir = new File(savePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(savePath + File.separator + name);
            fOut = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtils.closeOutputStream(fOut);
            return false;
        }
    }

    public static void openFile(Context context, String filePath, boolean isEncrypt) {
        Intent intent = null;
        if (isEncrypt) {
            intent = new Intent(context, OpenEncryptBridgeActivity.class);
            intent.putExtra("", filePath);
        } else {
            intent = FileUtils.openFile(filePath);
        }
        context.startActivity(intent);
    }

    public static void closeInputStream(InputStream ... ins) {
        if (ins != null && ins.length > 0) {
            for (InputStream in : ins) {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void closeInputChannel(FileChannel ... inChannels) {
        if (inChannels != null && inChannels.length > 0) {
            for (FileChannel in : inChannels) {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void closeOutputStream(OutputStream ... ous) {
        if (ous != null && ous.length > 0) {
            for (OutputStream out : ous) {
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void closeOutputChannel(FileChannel ... outChannels) {
        if (outChannels != null && outChannels.length > 0) {
            for (FileChannel out : outChannels) {
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String parseFileName(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String repath = path.replace("\\", "/").replace("\\\\", "/").replace("//", "/");
        return new File(repath).getName();
    }

    public static String parseFileSuffix(String path) {
        int dotIndex;
        if (!TextUtils.isEmpty((CharSequence)path) && (dotIndex = path.lastIndexOf(".")) > 0) {
            return path.substring(dotIndex + 1);
        }
        return "";
    }

    public static int getFileIconId(Context context, String path) {
        String iconName;
        block5: {
            iconName = "";
            try {
                if (TextUtils.isEmpty((CharSequence)path)) break block5;
                String prefix = "libicon_file_";
                if (new File(path).isDirectory() || TextUtils.isEmpty((CharSequence)FileUtils.parseFileSuffix(path)) || !FileUtils.parseFileSuffix(path).matches("^[0-9a-zA-Z]+$")) {
                    iconName = prefix + "folder";
                    break block5;
                }
                String suffix = FileUtils.parseFileSuffix(path).toLowerCase(Locale.getDefault());
                String packageName = context.getPackageName();
                Class<?> drawableCls = Class.forName(packageName + ".R$drawable");
                Field[] fields = drawableCls.getDeclaredFields();
                if (fields == null || fields.length <= 0) break block5;
                for (Field f : fields) {
                    String trimName;
                    List<String> supportSuffixs;
                    String name = f.getName();
                    if (!name.startsWith(prefix) || !(supportSuffixs = Arrays.asList((trimName = name.replace(prefix, "").replace(".png", "")).split("_"))).contains(suffix)) continue;
                    iconName = name;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)iconName)) {
            iconName = "libicon_file_unknow";
        }
        int resultId = ResourceUtils.getResourcesId(context, ResourceUtils.ResoureType.DRAWABLE, iconName);
        return resultId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressZipFileByApacheApi(String zipFilePath, String destDir) {
        boolean isSuccess = false;
        ZipFile zf = null;
        FilterOutputStream bos = null;
        try {
            zf = new ZipFile(zipFilePath, "GBK");
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)e.nextElement();
                String entryName = ze.getName();
                String entryPath = destDir + "/" + entryName;
                if (ze.isDirectory()) {
                    File childDir = new File(entryPath);
                    if (childDir.exists()) continue;
                    childDir.mkdirs();
                    continue;
                }
                String filePath = entryPath.substring(0, entryPath.lastIndexOf("/"));
                File fileDir = new File(filePath);
                if (!fileDir.exists()) {
                    fileDir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(destDir + "/" + entryName);
                bos = new BufferedOutputStream(fos);
                BufferedInputStream bi = new BufferedInputStream(zf.getInputStream(ze));
                byte[] buffer = new byte[2048];
                int readCount = bi.read(buffer);
                while (readCount != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, readCount);
                    readCount = bi.read(buffer);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
            isSuccess = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
                zf.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressZipFileByOriginlApi(String srcPath, String destDir) {
        boolean isSuccess = false;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            FileInputStream fis = new FileInputStream(srcPath);
            CheckedInputStream cis = new CheckedInputStream(fis, new CRC32());
            ZipInputStream zis = new ZipInputStream(cis);
            bis = new BufferedInputStream(zis);
            java.util.zip.ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String entryName = ze.getName();
                String entryPath = destDir + "/" + entryName;
                if (ze.isDirectory()) {
                    File childDir = new File(entryPath);
                    if (childDir.exists()) continue;
                    childDir.mkdirs();
                    continue;
                }
                FileOutputStream out = new FileOutputStream(entryPath);
                bos = new BufferedOutputStream(out);
                byte[] buffer = new byte[2048];
                int readCount = bis.read(buffer);
                while (readCount != -1) {
                    bos.write(buffer, 0, readCount);
                    readCount = bis.read(buffer);
                }
                bos.flush();
                bos.close();
            }
            isSuccess = true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeOutputStream(bos);
                FileUtils.closeInputStream(bis);
                throw throwable;
            }
            FileUtils.closeOutputStream(bos);
            FileUtils.closeInputStream(bis);
        }
        FileUtils.closeOutputStream(bos);
        FileUtils.closeInputStream(bis);
        return isSuccess;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String path = null;
        if (scheme == null) {
            path = uri.getPath();
        } else if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                path = cursor.getString(index);
            }
            cursor.close();
        }
        return path;
    }

    public static File getLastestFile(File[] files) {
        if (files == null) {
            return null;
        }
        return FileUtils.getLastestFile(Arrays.asList(files));
    }

    public static File getLastestFile(List<File> files) {
        File lastestFile = null;
        if (files != null && files.size() > 0) {
            Collections.sort(files, new LastestFileComparator());
            lastestFile = files.get(0);
        }
        return lastestFile;
    }

    public static String getFileMD5(File file, String algorithm) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance(algorithm);
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    public static Map<String, String> getDirMD5(File dirFile, String algorithm, boolean listChild) {
        if (!dirFile.isDirectory()) {
            return null;
        }
        HashMap<String, String> pathAlgMap = new HashMap<String, String>();
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory() && listChild) {
                pathAlgMap.putAll(FileUtils.getDirMD5(file, algorithm, listChild));
                continue;
            }
            String algCode = FileUtils.getFileMD5(file, algorithm);
            if (algCode == null) continue;
            pathAlgMap.put(file.getPath(), algCode);
        }
        return pathAlgMap;
    }

    public static String getFileSize(File file) {
        long length = 0L;
        if (file != null && file.exists()) {
            length = file.length();
        }
        return FileUtils.formatFileSize(length);
    }

    public static String formatFileSize(long length) {
        DecimalFormat df = new DecimalFormat("#.00");
        UnitType unit = UnitType.B;
        String size = "0";
        if (length < 1024L) {
            size = df.format(length);
        } else if (length < 0x100000L) {
            size = df.format((double)length / 1024.0);
            unit = UnitType.KB;
        } else if (length < 0x40000000L) {
            size = df.format((double)length / 1048576.0);
            unit = UnitType.MB;
        } else {
            size = df.format((double)length / 1.073741824E9);
            unit = UnitType.GB;
        }
        return size + " " + unit.name();
    }

    public static boolean ifDestoryImg(String filePath) {
        BitmapFactory.Options options = null;
        if (options == null) {
            options = new BitmapFactory.Options();
        }
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return options.mCancel || options.outWidth == -1 || options.outHeight == -1;
    }

    public static String readContent(String path) {
        return FileUtils.readContent(path, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContent(String path, String charsetName) {
        File file = new File(path);
        if (file.exists()) {
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                String temp = "";
                while ((temp = reader.readLine()) != null) {
                    buffer.append(temp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception fe) {
                    fe.printStackTrace();
                }
            }
            return buffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream fileStream, String charsetName) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fileStream, charsetName));
            String temp = "";
            while ((temp = reader.readLine()) != null) {
                buffer.append(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
        return buffer.toString();
    }

    static enum UnitType {
        B,
        KB,
        MB,
        GB,
        TB;

    }

    public static abstract class LetterOrder<T>
    implements Comparator<T> {
        @Override
        public abstract int compare(T var1, T var2);

        public int compareName(String lhs, String rhs) {
            String firstName = lhs;
            if (firstName.getBytes().length != firstName.length()) {
                firstName = PinyinUtils.getPinyinFirstChars(firstName);
            }
            firstName = firstName.toLowerCase(Locale.getDefault());
            String anotherName = rhs;
            if (anotherName.getBytes().length != anotherName.length()) {
                anotherName = PinyinUtils.getPinyinFirstChars(anotherName);
            }
            anotherName = anotherName.toLowerCase(Locale.getDefault());
            return firstName.compareTo(anotherName);
        }
    }

    public static class PictureFileSelector
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return false;
            }
            String suffix = FileUtils.parseFileSuffix(f.getName()).toLowerCase(Locale.getDefault());
            return suffix.equals("png") || suffix.equals("jpg") || suffix.equals("gif") || suffix.equals("jpeg") || suffix.equals("bmp");
        }
    }

    public static class LastestFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File lhs, File rhs) {
            return lhs.lastModified() < rhs.lastModified() ? 1 : -1;
        }
    }
}

