/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.szboanda.android.platform.util.DateUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class BeanUtil {
    public static final Class<?> loadClass(String className) {
        Class<?> c = null;
        if (!TextUtils.isEmpty((CharSequence)className)) {
            try {
                c = Class.forName(className);
            }
            catch (Exception e) {
                e.printStackTrace();
                c = null;
            }
        }
        return c;
    }

    public static final <E> E loadInstance(String className) {
        return BeanUtil.loadInstance(BeanUtil.loadClass(className));
    }

    public static <E> E loadInstance(Class<?> cls) {
        Object c = null;
        if (cls != null) {
            try {
                Object instance = cls.newInstance();
                c = instance;
            }
            catch (Exception e) {
                e.printStackTrace();
                c = null;
            }
        }
        return c;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = BeanUtil.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        BeanUtil.setFieldValue(object, field, value);
    }

    public static void setFieldValue(Object object, Field field, Object value) {
        BeanUtil.makeAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            Log.e((String)"zbkc", (String)"", (Throwable)e);
        }
    }

    protected static Field getDeclaredField(Object object, String fieldName) {
        return BeanUtil.getDeclaredField(object.getClass(), fieldName);
    }

    protected static Field getDeclaredField(Class<?> clazz, String fieldName) {
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static List<Field> getDeclaredFields(Class<?> cls) {
        ArrayList<Field> result = new ArrayList<Field>();
        BeanUtil.getDeclaredFields(cls, result);
        return result;
    }

    private static void getDeclaredFields(Class<?> cls, List<Field> fields) {
        Field[] temp;
        for (Field f : temp = cls.getDeclaredFields()) {
            fields.add(f);
        }
        if (cls.getSuperclass() != null) {
            BeanUtil.getDeclaredFields(cls.getSuperclass(), fields);
        }
    }

    public static <E> E convertJsonStr2Entity(String jsonStr, Type c) {
        Object result = null;
        if (!TextUtils.isEmpty((CharSequence)jsonStr) && c != null) {
            Gson convert = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();
            result = convert.fromJson(jsonStr, c);
        }
        return (E)result;
    }

    public static <E> List<E> convertArrayStr2Entitys(String arrayStr, Type type) {
        List result = null;
        if (!TextUtils.isEmpty((CharSequence)arrayStr) && type != null) {
            Gson convert = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();
            result = (List)convert.fromJson(arrayStr, type);
        }
        return result;
    }

    public static JSONObject entitys2JsonObj(Object c) {
        JSONObject obj = null;
        try {
            if (c != null) {
                Gson convert = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();
                String jsonStr = convert.toJson(c);
                obj = new JSONObject(jsonStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T, S> List<T> convertImplToEntity(List<S> source) {
        ArrayList<S> target = null;
        if (source != null && source.size() > 0) {
            target = new ArrayList<S>();
            for (S s : source) {
                target.add(s);
            }
        }
        return target;
    }

    public static <T> JSONArray convertEntitys2JsonArr(List<T> entitys, Type type) {
        JSONArray resultArr = new JSONArray();
        try {
            if (entitys != null && entitys.size() > 0) {
                Gson convert = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();
                String jsonArrStr = convert.toJson(entitys, type);
                resultArr = new JSONArray(jsonArrStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultArr;
    }

    public static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext jsc) throws JsonParseException {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("The date should be a string value");
            }
            return DateUtils.parseDate(json.getAsString(), "yyyy-MM-dd HH:mm");
        }

        public JsonElement serialize(Date date, Type type, JsonSerializationContext jsc) {
            return new JsonPrimitive(DateUtils.formatDate(date, "yyyy-MM-dd HH:mm"));
        }
    }
}

