/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.nfc;

import android.app.Activity;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.view.View;
import android.widget.Toast;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.dialog.MessageDialog;
import com.szboanda.android.platform.nfc.INfcListener;
import com.szboanda.android.platform.nfc.INfcOperation;

public abstract class NfcBaseOperation
implements INfcOperation {
    public static final String MIME_TYPE_NDEF = "boandaapp/com.boanda.android.beam";
    public static final int REQUEST_CODE_OPEN_NFC = 0x100001;
    public Tag mTagFromIntent;
    private NfcAdapter mNfcAdapter;
    private PendingIntent mPendingIntent;
    private IntentFilter[] mIntentFiltersArray;
    private String[][] mTechListsArray = new String[][]{{Ndef.class.getName()}};
    private Activity mActivity;
    private boolean mAutoRead = false;
    private INfcListener mListener;

    public NfcBaseOperation(Activity ctx) {
        this.mActivity = ctx;
    }

    @Override
    public void prepareForegroundDispatch() {
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.mActivity);
        if (this.mNfcAdapter == null) {
            Toast.makeText((Context)this.mActivity, (CharSequence)this.mActivity.getString(R.string.nfc_not_available), (int)1).show();
            this.mActivity.finish();
            return;
        }
        if (!this.mNfcAdapter.isEnabled()) {
            this.showWirelessSettingsDialog();
        }
        IntentFilter ndef = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
        try {
            ndef.addDataType(MIME_TYPE_NDEF);
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            throw new RuntimeException("fail", e);
        }
        this.mIntentFiltersArray = new IntentFilter[]{ndef};
        this.mPendingIntent = PendingIntent.getActivity((Context)this.mActivity, (int)0, (Intent)new Intent((Context)this.mActivity, this.mActivity.getClass()).addFlags(0x20000000), (int)0);
    }

    private void showWirelessSettingsDialog() {
        MessageDialog dialog = new MessageDialog((Context)this.mActivity);
        dialog.setMessage(this.mActivity.getString(R.string.turn_on_nfc));
        dialog.setPositiveButton(17039370, new BaseDialog.OnDialogButtonClickListener(){

            @Override
            public void onClick(Dialog dialog, View v) {
                Intent intent = new Intent("android.settings.WIRELESS_SETTINGS");
                NfcBaseOperation.this.mActivity.startActivityForResult(intent, 0x100001);
            }
        });
        dialog.setNegativeButton(0x1040000, new BaseDialog.OnDialogButtonClickListener(){

            @Override
            public void onClick(Dialog dialog, View v) {
                NfcBaseOperation.this.mActivity.finish();
            }
        });
        dialog.show();
    }

    @Override
    public void onPrepareForegroundDispatch(int requestCode) {
        switch (requestCode) {
            case 0x100001: {
                if (this.mNfcAdapter.isEnabled()) break;
                Toast.makeText((Context)this.mActivity, (CharSequence)this.mActivity.getString(R.string.nfc_not_open), (int)1).show();
                this.mActivity.finish();
            }
        }
    }

    @Override
    public void enableForegroundDispatch() {
        if (this.mNfcAdapter != null) {
            this.mNfcAdapter.enableForegroundDispatch(this.mActivity, this.mPendingIntent, this.mIntentFiltersArray, this.mTechListsArray);
        }
    }

    @Override
    public void disableForegroundDispatch() {
        if (this.mNfcAdapter != null) {
            this.mNfcAdapter.disableForegroundDispatch(this.mActivity);
        }
    }

    @Override
    public void enableAutoRead(boolean autoRead) {
        this.mAutoRead = autoRead;
    }

    @Override
    public void onNewIntent(Intent intent) {
        this.mTagFromIntent = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        if (this.mAutoRead && null != this.mListener) {
            this.mListener.onRead(this.read());
        }
    }

    @Override
    public void setNfcListener(INfcListener l) {
        this.mListener = l;
    }
}

