/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.nfc;

import android.app.Activity;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.util.Base64;
import android.util.Log;
import com.szboanda.android.platform.nfc.NfcBaseOperation;
import java.io.IOException;
import java.nio.charset.Charset;

public class NdefOperation
extends NfcBaseOperation {
    public static final String TAG = "NdefOperation";

    public NdefOperation(Activity activity) {
        super(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read() {
        if (this.mTagFromIntent == null) {
            return "";
        }
        Ndef ndef = Ndef.get((Tag)this.mTagFromIntent);
        try {
            ndef.connect();
            byte[] payload = ndef.getNdefMessage().getRecords()[0].getPayload();
            String string2 = new String(Base64.decode((byte[])payload, (int)0), Charset.forName("UTF-8"));
            return string2;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException while read Ndef message...", (Throwable)e);
        }
        catch (FormatException e) {
            Log.e((String)TAG, (String)"FormatException while read Ndef message...", (Throwable)e);
        }
        finally {
            try {
                ndef.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error closing tag...", (Throwable)e);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(String content) {
        if (this.mTagFromIntent == null) {
            return false;
        }
        NdefRecord[] ndefRecords = new NdefRecord[]{this.createMimeRecord(content)};
        NdefMessage msg = new NdefMessage(ndefRecords);
        Ndef ndef = Ndef.get((Tag)this.mTagFromIntent);
        try {
            ndef.connect();
            ndef.writeNdefMessage(msg);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException while write Ndef message...", (Throwable)e);
        }
        catch (FormatException e) {
            Log.e((String)TAG, (String)"FormatException while write Ndef message...", (Throwable)e);
        }
        finally {
            try {
                ndef.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error closing tag...", (Throwable)e);
            }
        }
        return true;
    }

    private NdefRecord createMimeRecord(String content) {
        byte[] mimeData = Base64.encode((byte[])content.getBytes(Charset.forName("UTF-8")), (int)0);
        return NdefRecord.createMime((String)"boandaapp/com.boanda.android.beam", (byte[])mimeData);
    }
}

