package com.szboanda.android.platform.view;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AbsListView.OnScrollListener;
import android.widget.BaseAdapter;

import com.szboanda.android.platform.view.PinnedHeaderListView.PinnedHeaderAdapter;

/**
 * <p>Description:任务列表适配器 </p>
 * @author    Siyi Lu    Create Date: 2015-7-24
 * @param <T>
 */
public abstract class UniversalPinnedHeaderAdapter<T extends IPinnedHeaderListItem> 
	extends BaseAdapter 
	implements PinnedHeaderAdapter, OnScrollListener, IChangeDataSet<T>{
	
	public final static int TYPE_GROUP = 0;
	
	public final static int TYPE_ITEM = 1;
	
	private LayoutInflater mInflater;
	
	/**列表显示的数据，包括两种数据，一种是*/
	private List<T> mData = new ArrayList<T>();;
	
	protected int groupItemLayoutId = -1;
	
	protected int childItemLayoutId = -1;
	
	private Context mContext;
	
	public UniversalPinnedHeaderAdapter(Context context, int groupItemLayoutId, int childItemLayoutId){
		mInflater = LayoutInflater.from(context);
		mContext = context;
		this.groupItemLayoutId = groupItemLayoutId;
		this.childItemLayoutId = childItemLayoutId;
	}
	
	public Context getContext(){
		return mContext;
	}
	
	public List<T> getData(){
		return mData;
	}
	
	@Override
	public void setData(List<T> items){
		if(items != null){
			mData.clear();
			mData.addAll(items);
		}
	}
	
	@Override
	public void addData(List<T> items) {
		if(items != null){
			mData.addAll(items);
		}
	}

	@Override
	public int getCount() {
		return mData.size();
	}
	
	@Override
	public boolean areAllItemsEnabled() {
		return false;
	}
	
	@Override
	public boolean isEnabled(int position) {
		// 异常情况处理,因为XListView头部和尾部不能点击，所以是<=和>=    
        if (mData == null && position <= 0 || position >= getCount()) {  
            return false;  
        }   
        T item = mData.get(position);  
        if (((IPinnedHeaderListItem)item).isGroupItem()) {  
        	return false;  
        }  
        return true;  
	}

	@Override
	public T getItem(int position) {
		//因为XListView头和尾各加了一个条目
		return (position >= 1 && position <= mData.size() -1) ? mData.get(position) : null;  
	}

	@Override
	public long getItemId(int position) {
		return 0;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		int viewType = getItemViewType(position);
		T itemData = mData.get(position);
		View view = getItemView(convertView, parent, mInflater, itemData, viewType);
		return view;
	}
	
	@Override
	public int getItemViewType(int position) {
		// 异常情况处理    
        if (mData == null || position <  0|| position > getCount()) {  
            return TYPE_ITEM;  
        }   
        T item = mData.get(position);  
        if (((IPinnedHeaderListItem)item).isGroupItem()) {  
            return TYPE_GROUP;  
        }  
          
        return TYPE_ITEM;  
	}
	
	@Override
	public int getViewTypeCount() {
		return 2;
	}

	@Override
	public int getPinnedHeaderState(int firstVisableItemPosition) {
		if (firstVisableItemPosition <= 0) {  
            return PINNED_HEADER_GONE;  
        }  
        T item = getItem(firstVisableItemPosition);  
        T itemNext = getItem(firstVisableItemPosition + 1);  
        if(itemNext != null){
        	//在组条目和组成员条目过渡时才会有悬浮窗被推出窗口的状态
	        boolean isFirstGroup = item.isGroupItem();  
	        boolean isNextNotGroup = (itemNext != null) ? !itemNext.isGroupItem() : true;  
	        if (isFirstGroup && isNextNotGroup) {  
	            return PINNED_HEADER_PUSHED_UP;  
	        }
        }else{
        	return PINNED_HEADER_GONE;
        }
        return PINNED_HEADER_VISIBLE;  
	}

	/**刷新列表顶部悬浮视图*/
	@Override
	public abstract void refreshHeaderView(View header, int position, int alpha);

	@Override
	public void onScrollStateChanged(AbsListView view, int scrollState) {}

	@Override
	public void onScroll(AbsListView view, int firstVisibleItem,
			int visibleItemCount, int totalItemCount) {
		if (view instanceof PinnedHeaderListView) {
			((PinnedHeaderListView) view).layoutHeaderView(firstVisibleItem);
		}
	}
	
	public abstract View getItemView(View convertView, ViewGroup parent
			,LayoutInflater inflater,T itemData, int itemType);
}
