package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.EditText;

import com.szboanda.android.platform.R;

/** 
 * 类说明： 
 * @author 苏浩 2015年8月13日
 * @version 1.0
 */

public class BindableEditText extends EditText implements IBindableView {

	private BindableViewHandler mBindHandler;

	public BindableEditText(Context context, AttributeSet attrs) {
		super(context, attrs);
		mBindHandler = new BindableViewHandler(this);
		mBindHandler.initWithTypedArray(getResources(), attrs);
	}
	
	public BindableEditText(Context context) {
		super(context);
		mBindHandler = new BindableViewHandler(this);
	}



	@Override
	public void setField(String field) {
		mBindHandler.setField(field);
	}

	@Override
	public void setEmptyMsg(String notEmptyTipMsg) {
		mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
	}

	@Override
	public void setBindValue(String value) {
		setText(value);
	}

	@Override
	public String getBindValue() {
		return getText().toString();
	}

	@Override
	public BindableViewHandler getBindHandler() {
		return mBindHandler;
	}
	
}
