package com.szboanda.android.platform.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import android.content.Context;
import android.util.DisplayMetrics;

/**
 * 根据名字获取资源工具类，未找到返回0
 * <br>用途：做成jar包时，包名不同时，通过R.id的方式会找不到资源
 */
public class ResourceUtils {
	
	public static int findResId(Context context, String namePrefix, ResoureType type){
		List<Integer> ids = findResIdsByNamePrefix(context, namePrefix, type);
		if(ids.size()>0)
			return ids.get(0);
		else
			return 0;
	}
	
	public static List<Integer> findResIdsByNamePrefix(Context context, String namePrefix, ResoureType type){
		String packageName = context.getPackageName();
		String typeStr = type.toString().toLowerCase(Locale.getDefault());
		List<Integer> ids = new ArrayList<Integer>();
		try{
			Class<?> typeCls = Class.forName(packageName + ".R$" + typeStr);
			Field[] fields = typeCls.getDeclaredFields();
			for(Field f : fields){
				String name = f.getName();
				if(name.startsWith(namePrefix)){
					ids.add(getResourcesId(context, type, name));
				}
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
		return ids;
	}
	
	/**
	 * 获取资源ID
	 * @param context 当前上下文
	 * @param type 资源类型 {@link ResoureType}
	 * @param name 资源名字
	 * @return 如果资源不存在，返回0;
	 */
	public static int getResourcesId(Context context, ResoureType type, String name) {
		return context.getResources().getIdentifier(name
				,type.toString().toLowerCase(Locale.getDefault())
				,context.getPackageName());
	}
	
	/**获取自定义属性生成的数组*/
	public static final int[] getStyleableIntArray(Context context, String name) {
		try {
			Field[] fields2 = Class.forName(context.getPackageName() + ".R$styleable").getFields();
			for (Field f : fields2) {
				if (f.getName().equals(name)) {
					int[] ret = (int[]) f.get(null);
					return ret;
				}
			}
		} catch (Throwable t) {
		}
		return null;
	}
	
	/**获取指定自定义属性所在数组的索引位置*/
	public static final int getStyleableInt(Context context, String name) {
		try {
			Field[] fields2 = Class.forName(context.getPackageName() + ".R$styleable").getFields();
			for (Field f : fields2) {
				if (f.getName().equals(name)) {
					int ret = (Integer) f.get(null);
					return ret;
				}
			}
		} catch (Throwable t) {
		}
		return -1;
	}
	/**根据android官方API进行计算获取相应的数值，一般用来进行自体的大小设置
	 * 不同手机scaledDensity值不同。
	 * */
	public static float getScaledDensity(float source,Context context){
		//android官方要求，需要先得到手机的scaledDecsity
		DisplayMetrics dm = context.getResources().getDisplayMetrics();
	    float value = dm.scaledDensity;
		return source/value;
	}
	
	public enum ResoureType{
		ID,
		STRING,
		LAYOUT,
		DRAWABLE,
		STYLE,
		COLOR,
		DIMEN,
		INTEGER,
		ARRAY,
	}
}
