package com.szboanda.android.platform.util;

import java.io.File;
import android.content.Context;
import android.os.Environment;

/**   
* 数据清除管理器.主要功能有清除内/外缓存，清除数据库，清除sharedPreference，清除files和清除自定义目录
* @author 苏浩  2015年9月8日 下午5:37:52
* @version V1.0
*/

public class CleanUtils {
	
	
	/** 
	 * 删除目录，递归删除子目录
	 * @param directory 
	 */
	private static void deleteFilesByDirectory(File directory) {
		if (directory != null && directory.exists() && directory.isDirectory()) {
			for (File item : directory.listFiles()) {
                if(item.isDirectory())
                    deleteFilesByDirectory(item);
                else
                    item.delete();
			}
            directory.delete();
		}
	}
	
	/**
	 * 获取应用文件路径
	 * @param context
	 */
	private static String getApplicationFilePath(Context context){
		return context.getFilesDir().getParentFile().getPath();
	}
	
	/** 
	 * 清除本应用内部缓存(/data/data/com.xxx.xxx/cache)
	 * @param context 
	 */
    public static void cleanInternalCache(Context context) {
        deleteFilesByDirectory(context.getCacheDir());
    }

    /** 
     * 清除本应用所有数据库(/data/data/com.xxx.xxx/databases) 
     * @param context 
     */
    public static void cleanDatabases(Context context) {
        deleteFilesByDirectory(new File(getApplicationFilePath(context) + "/databases"));
    }

    /**
     * 清除本应用SharedPreference(/data/data/com.xxx.xxx/shared_prefs) 
     * @param context
     */
    public static void cleanSharedPreference(Context context) {
        deleteFilesByDirectory(new File(getApplicationFilePath(context) + "/shared_prefs"));
    }

    /** 
     * 按名字清除本应用数据库  
     * @param context  
     * @param dbName 
     */
    public static void cleanDatabaseByName(Context context, String dbName) {
        context.deleteDatabase(dbName);
    }

    /** 
     * 清除/data/data/com.xxx.xxx/files下的内容 
     * @param context 
     */
    public static void cleanFiles(Context context) {
        deleteFilesByDirectory(context.getFilesDir());
    }

    /**
     * 清除外部cache下的内容(/mnt/sdcard/android/data/com.xxx.xxx/cache)
     * @param context
     */
    public static void cleanExternalCache(Context context) {
        if (Environment.getExternalStorageState().equals(
                Environment.MEDIA_MOUNTED)) {
            deleteFilesByDirectory(context.getExternalCacheDir());
        }
    }

    /** 
     * 清除自定义路径下的文件，使用需小心，请不要误删。而且只支持目录下的文件删除 
     * @param filePath 
     */
    public static void cleanCustomCache(String filePath) {
        deleteFilesByDirectory(new File(filePath));
    }

    /** 
     * 清除本应用所有的数据  
     * @param context  
     * @param filepath
     */
    public static void cleanApplicationData(Context context, String... filepath) {
        cleanInternalCache(context);
        cleanExternalCache(context);
        cleanDatabases(context);
        cleanSharedPreference(context);
        cleanFiles(context);
        for (String filePath : filepath) {
            cleanCustomCache(filePath);
        }
    }
}
