package com.szboanda.android.platform.nfc;

import android.app.Activity;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.provider.Settings;
import android.view.View;
import android.widget.Toast;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.dialog.MessageDialog;

/**
 * Created by zhanggenhua on 16/4/14.
 */
public abstract class NfcBaseOperation implements INfcOperation{

    // data type NDEF
    public final static String MIME_TYPE_NDEF = "boandaapp/com.boanda.android.beam";

    public final static int REQUEST_CODE_OPEN_NFC = 0x100001;

    public Tag mTagFromIntent;

    private NfcAdapter mNfcAdapter;

    private PendingIntent mPendingIntent;

    private IntentFilter[] mIntentFiltersArray;

    private String[][] mTechListsArray = new String[][]{new String[]{Ndef.class.getName()}};

    private Activity mActivity;

    private boolean mAutoRead = false;

    private INfcListener mListener;

    public NfcBaseOperation(Activity ctx) {
        this.mActivity = ctx;
    }

    @Override
    public void prepareForegroundDispatch() {
        // Check for available NFC Adapter
        mNfcAdapter = NfcAdapter.getDefaultAdapter(mActivity);
        if (mNfcAdapter == null) {
            Toast.makeText(mActivity, mActivity.getString(R.string.nfc_not_available), Toast.LENGTH_LONG).show();
            mActivity.finish();
            return;
        }

        // Check for enabled NFC
        if (!mNfcAdapter.isEnabled()) {
            showWirelessSettingsDialog();
        }

        IntentFilter ndef = new IntentFilter(NfcAdapter.ACTION_NDEF_DISCOVERED);
        try {
            // Handles MIME based dispatches.
            ndef.addDataType(MIME_TYPE_NDEF);
        } catch (IntentFilter.MalformedMimeTypeException e) {
            throw new RuntimeException("fail", e);
        }
        mIntentFiltersArray = new IntentFilter[]{ndef,};

        mPendingIntent = PendingIntent.getActivity(
                mActivity, 0, new Intent(mActivity, mActivity.getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
    }

    private void showWirelessSettingsDialog() {
        MessageDialog dialog = new MessageDialog(mActivity);
        dialog.setMessage(mActivity.getString(R.string.turn_on_nfc));
        dialog.setPositiveButton(android.R.string.ok, new BaseDialog.OnDialogButtonClickListener() {
            @Override
            public void onClick(Dialog dialog, View v) {
                Intent intent = new Intent(Settings.ACTION_WIRELESS_SETTINGS);
                mActivity.startActivityForResult(intent, REQUEST_CODE_OPEN_NFC);
            }
        });

        dialog.setNegativeButton(android.R.string.cancel, new BaseDialog.OnDialogButtonClickListener() {
            @Override
            public void onClick(Dialog dialog, View v) {
                mActivity.finish();
            }
        });
        dialog.show();
    }

    @Override
    public void onPrepareForegroundDispatch(int requestCode) {
        switch (requestCode) {
            case REQUEST_CODE_OPEN_NFC:
                if (!mNfcAdapter.isEnabled()) {
                    Toast.makeText(mActivity, mActivity.getString(R.string.nfc_not_open), Toast.LENGTH_LONG).show();
                    mActivity.finish();
                }
                break;
        }
    }

    @Override
    public void enableForegroundDispatch() {
        if (mNfcAdapter!=null){
            mNfcAdapter.enableForegroundDispatch(mActivity, mPendingIntent, mIntentFiltersArray, mTechListsArray);
        }
    }

    @Override
    public void disableForegroundDispatch() {
        if(mNfcAdapter != null) {
            mNfcAdapter.disableForegroundDispatch(mActivity);
        }
    }

    @Override
    public void enableAutoRead(boolean autoRead) {
        this.mAutoRead = autoRead;
    }

    public void onNewIntent(Intent intent) {
        mTagFromIntent = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);

        if(mAutoRead && null != this.mListener){
            this.mListener.onRead(read());
        }
    }

    @Override
    public void setNfcListener(INfcListener l){
        this.mListener = l;
    }

}
