package com.szboanda.android.platform.http.impl;

import android.app.Activity;
import android.content.Context;

import com.szboanda.android.platform.http.IErroResolver;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/3/6.
 */

public abstract class AbsErroResolver<T extends Throwable> implements IErroResolver {

    private Context mContext;

    private T mException;

    public AbsErroResolver(Context context, Throwable ex){
        mContext = context;
        mException = (T)ex;
    }

    @Override
    public boolean isForeground() {
        return mContext != null && mContext instanceof Activity;
    }

    @Override
    public Context getContext() {
        return mContext;
    }

    @Override
    public T getException() {
        return mException;
    }

    @Override
    public abstract boolean resolve();

}
