package com.szboanda.android.platform.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.szboanda.android.platform.dialog.CustomProgressDialog;
import com.szboanda.android.platform.http.impl.ArrayProtocol;
import com.szboanda.android.platform.http.impl.EntityProtocol;
import com.szboanda.android.platform.http.impl.GroupProtocol;
import com.szboanda.android.platform.http.impl.IResponseProcessor;
import com.szboanda.android.platform.http.impl.JsonProtocol;
import com.szboanda.android.platform.util.BeanUtil;
import com.szboanda.android.platform.util.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;
import org.xutils.common.Callback;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * 网络异常处理类
 * @author   Siyi Lu    Create Date: 2015-4-13
 * modify  Siyi Lu   Modify Date: 2017-02-28, 升级至xUtils3
 */
public abstract class ResponseProcessor<T>
    implements Callback.CommonCallback<String>{
	
	private Context mContext;
	
	private CustomProgressDialog mDialog = null;
	
	public Context getContext() {
		return mContext;
	}

	public void setContext(Context context) {
		this.mContext =context;
	}

	public void setDialog(CustomProgressDialog mDialog) {
		this.mDialog = mDialog;
	}

	public void setProgressDialog(CustomProgressDialog dialog) {
		mDialog = dialog;
	}
	
	public CustomProgressDialog getDialog(){
		return mDialog;
	}

    /**
     * 获取网络响应内容的键
     * @return
     */
    public String optKey(){
        return "";
    }

    @Override
    public void onSuccess(String result) {
        if(mDialog != null){
            mDialog.dismiss();
        }
        Type type = getClass().getGenericSuperclass();
        Type[] typeArgs = ((ParameterizedType) type).getActualTypeArguments();
        Type convertType = null;
        IDataProtocol protocol = null;
        if(typeArgs[0] instanceof ParameterizedType){
            //如果参数化泛型仍然是泛型类型，则认为是List或ArrayList
            ParameterizedType listParameterizedType = (ParameterizedType) typeArgs[0];
            if(listParameterizedType.getRawType().equals(List.class)
                || listParameterizedType.getRawType().equals(ArrayList.class)) {
                Type[] listTypeArgs = listParameterizedType.getActualTypeArguments();
                if(listTypeArgs[0] instanceof Class){
                    convertType = listParameterizedType;
                    protocol = new GroupProtocol();
                }
            }
        }else {
            convertType = (Class<?>) typeArgs[0];
            if(TextUtils.isEmpty(result)) {
                Log.i(((Class)convertType).getName(), "返回数据为空");
            }else {
                Class<?> typeCls = (Class<?>)convertType;
                if(typeCls.equals(JSONObject.class)){
                    protocol = new JsonProtocol();
                }else if(typeCls.equals(JSONArray.class)){
                    protocol = new ArrayProtocol();
                }else if (!typeCls.equals(String.class)){
                    protocol = new EntityProtocol();
                }
            }
        }
        if(!TextUtils.isEmpty(optKey())){
            protocol.dataKey(optKey());
        }
        if(protocol != null && protocol instanceof GroupProtocol){
            JSONObject json = JsonUtils.parseJsonObject(result);
            int totalCount = json != null ? json.optInt("total_count", -1) : -1;
            if(totalCount != -1){
                onSuccessTyped(protocol != null ? (T) protocol.convert(result, convertType) : (T)result, totalCount);
            }else{
                onSuccessTyped(protocol != null ? (T) protocol.convert(result, convertType) : (T)result);
            }
        }else{
            onSuccessTyped(protocol != null ? (T) protocol.convert(result, convertType) : (T)result);
        }
    }

    @Override
    public void onCancelled(CancelledException cex) {}

    @Override
    public void onFinished() {}

    @Override
    public void onError(Throwable ex, boolean isOnCallback) {
        if(mDialog != null){
            mDialog.dismiss();
        }
        Log.e("ResponseProcessor", ex.getMessage());
        ex.printStackTrace();
        IErroResolver resolver = ErrorResolverFactory.newResolver(mContext, ex);
        if(resolver != null) {
            resolver.resolve();
        }
    }

    public abstract void onSuccessTyped(T result);

    public void onSuccessTyped(T result, int totalCount){}

}