package com.szboanda.android.platform.dialog;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.widget.RemoteViews;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.activity.PdfViewActivity;
import com.szboanda.android.platform.util.FileUtils;

/**
 * Created by Administrator on 2017/3/15.
 */

public class PercentNotification {

    private NotificationManager mNoticeManager;

    private Notification mNotice;

    private Context mContext;

    private RemoteViews rv = null;

    private long mTotal = 0;

    public PercentNotification(Context context){
        mContext = context;
        if(mContext != null){
            mNoticeManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
            mNotice = new Notification();
            mNotice.flags |= Notification.FLAG_AUTO_CANCEL;
            rv = new RemoteViews(mContext.getPackageName(), R.layout.viewjar_progress_notice);
            rv.setProgressBar(R.id.progress, 100, 0, false);
            mNotice.contentView = rv;
        }
    }

    public PercentNotification title(String title){
        if(mNotice != null){
            mNotice.tickerText = title;
            int iconId = FileUtils.getFileIconId(mContext, title);
            mNotice.icon = iconId;
            rv.setImageViewResource(R.id.notice_icon, iconId);
            rv.setTextViewText(R.id.title, title);
        }
        return this;
    }

    public PercentNotification total(long total){
        mTotal = total;
        return this;
    }

    public PercentNotification current(long current){
        int ratio = (int)(Double.valueOf(current + "")/Double.valueOf(mTotal + "")*100);
        rv.setTextViewText(R.id.percent, ratio + "%");
        rv.setProgressBar(R.id.progress, 100, ratio, false);
        return this;
    }

    public void notice(){
        Intent i = new Intent(mContext, PdfViewActivity.class);
        PendingIntent p=PendingIntent.getActivity(mContext, 0, i, 0);
        mNotice.contentIntent = p;
        mNoticeManager.notify(hashCode(), mNotice);
    }

}
