package com.szboanda.android.platform;

import android.content.Context;
import android.os.AsyncTask;

import com.szboanda.android.platform.dialog.CustomProgressDialog;
import com.szboanda.android.platform.http.impl.IProgressChangeView;

/**
 * <p>Description: 异步任务接口</p>
 * @author    Siyi Lu    Create Date: 2015-7-16
 */
public abstract class UniversalAsyncTask extends AsyncTask<Object, Integer, Object>{
	
	protected Context mContext;
	/**默认的等待框*/
	private CustomProgressDialog indeterminateDialog;
	/**自定义进度变更视图*/
	private IProgressChangeView progressChangeView = null;
	/**是否显示等待对话框*/
	private boolean isShowDefaultDialog;
	/**等待对话框提示内容*/
	private String tipMsg;
	
	/**
	 * 不显示等待对话框
	 * @param context
	 */
	public UniversalAsyncTask(Context context){
		mContext = context;
		isShowDefaultDialog = false;
	}
	
	/**
	 * 显示{@link CustomProgressDialog}等待对话框
	 * @param context
	 * @param tipMsg
	 */
	public UniversalAsyncTask(Context context, String tipMsg){
		mContext = context;
		isShowDefaultDialog = true;
		this.tipMsg = tipMsg;
	}
	
	/**
	 * 执行异步任务的同时，更新实现了{@link IProgressChangeView}接口的视图
	 * @param context
	 * @param calculableDialog
	 */
	public UniversalAsyncTask(Context context, IProgressChangeView calculableDialog){
		mContext = context;
		this.progressChangeView = calculableDialog;
		isShowDefaultDialog = mContext != null && progressChangeView != null;
	}
	
	@Override
	protected void onPreExecute() {
		if(isShowDefaultDialog && indeterminateDialog == null){
			indeterminateDialog = new CustomProgressDialog(mContext, tipMsg);
			indeterminateDialog.show();
		}
		if(isShowDefaultDialog && progressChangeView != null 
				&& progressChangeView instanceof CustomProgressDialog){
			((CustomProgressDialog)progressChangeView).show();
		}
	}

	@Override
	protected void onPostExecute(Object result) {
		if(isShowDefaultDialog){
			indeterminateDialog.dismiss();
		}
		if(progressChangeView != null){
			progressChangeView.onFinish();
		}
	}
	
	@Override
	protected final void onProgressUpdate(Integer... values) {
		if(progressChangeView != null){
			progressChangeView.onProgressChanged(-1, values[0], -1);
		}
	}
	
	public Context getContext(){
		return mContext;
	}
	
}
