/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.ColorInt;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.NumberPicker;
import java.lang.reflect.Field;
import java.util.Locale;

public class NumberPickerReflect
extends NumberPicker {
    private int mTouchSlop;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private int mDividerColor;
    private String mFormatter;
    private boolean mFocusable = false;
    private int mMax = 100;
    private int mMin = 1;
    private int mTextColor = -16777216;
    private float mTextSize;
    private Typeface mTypeface;

    public NumberPickerReflect(Context context) {
        super(context);
    }

    public void setTouchSlop(int slop) {
        Field[] fields;
        this.mTouchSlop = slop;
        for (Field field : fields = NumberPicker.class.getDeclaredFields()) {
            if (!field.getName().equals("mTouchSlop")) continue;
            field.setAccessible(true);
            try {
                field.set((Object)this, slop);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public void setMaximumFlingVelocity(int fling) {
        Field[] fields;
        this.mMaximumFlingVelocity = fling;
        for (Field field : fields = NumberPicker.class.getDeclaredFields()) {
            if (!field.getName().equals("mMaximumFlingVelocity")) continue;
            field.setAccessible(true);
            try {
                field.set((Object)this, fling);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public void setMinimumFlingVelocity(int fling) {
        Field[] fields;
        this.mMinimumFlingVelocity = fling;
        for (Field field : fields = NumberPicker.class.getDeclaredFields()) {
            if (!field.getName().equals("mMinimumFlingVelocity")) continue;
            field.setAccessible(true);
            try {
                field.set((Object)this, fling);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public void setDividerColor(@ColorInt int color2) {
        Field[] fields;
        if (color2 == 0) {
            return;
        }
        this.mDividerColor = color2;
        for (Field field : fields = NumberPicker.class.getDeclaredFields()) {
            if (!field.getName().equals("mSelectionDivider")) continue;
            field.setAccessible(true);
            try {
                field.set((Object)this, new ColorDrawable(color2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public void setDividerDistance(int distance) {
        Field[] fields;
        for (Field field : fields = NumberPicker.class.getDeclaredFields()) {
            if (!field.getName().equals("mSelectionDividersDistance")) continue;
            field.setAccessible(true);
            try {
                field.set((Object)this, distance);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public void setMaxHeight(int height) {
        Field[] fields;
        for (Field field : fields = NumberPicker.class.getDeclaredFields()) {
            if (!field.getName().equals("mMaxHeight")) continue;
            field.setAccessible(true);
            try {
                field.set((Object)this, height);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public void setFormatter(String formatter) {
        if (TextUtils.isEmpty((CharSequence)formatter)) {
            return;
        }
        this.mFormatter = formatter;
        this.setFormatter(new NumberPicker.Formatter(){

            public String format(int i) {
                return String.format(Locale.getDefault(), NumberPickerReflect.this.mFormatter, i);
            }
        });
    }

    public void setFocusable(boolean focusable) {
        this.mFocusable = focusable;
        this.setTextAttributes();
    }

    public void setTextColor(@ColorInt int color2) {
        this.mTextColor = color2;
        this.setTextAttributes();
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.setTextAttributes();
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.setTextAttributes();
    }

    private void setTextAttributes() {
        if (this.mTextSize == 0.0f) {
            this.mTextSize = this.spToPx(16.0f);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof EditText)) continue;
            try {
                Field selectorWheelPaintField = NumberPicker.class.getDeclaredField("mSelectorWheelPaint");
                selectorWheelPaintField.setAccessible(true);
                Paint wheelPaint = (Paint)selectorWheelPaintField.get((Object)this);
                wheelPaint.setColor(this.mTextColor);
                wheelPaint.setTextSize(this.mTextSize);
                wheelPaint.setTypeface(this.mTypeface != null ? this.mTypeface : Typeface.MONOSPACE);
                EditText editText = (EditText)child;
                editText.setTextColor(this.mTextColor);
                editText.setFocusable(this.mFocusable);
                editText.setTextSize(this.pxToSp(this.mTextSize));
                editText.setTypeface(this.mTypeface != null ? this.mTypeface : Typeface.MONOSPACE);
                this.invalidate();
                break;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private float pxToSp(float px) {
        float fontScale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(px / fontScale + 0.5f * (float)(px >= 0.0f ? 1 : -1));
    }

    private float spToPx(float sp) {
        float fontScale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(sp * fontScale + 0.5f);
    }
}

