/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.widget.Button;
import com.szboanda.android.platform.R;

public class PureColorButton
extends Button {
    int bgColor = -16776961;
    int disableColor = -16776961;
    int normalColor = -16776961;
    int pressColor = -16776961;
    private Drawable mBgDrawable;
    private Bitmap mBgImage;
    RectF mBgColorRect;
    Paint mPaint = null;
    Path mPath = null;
    float mRadius;
    float topLeftRadius;
    float topRightRadius;
    float bottomLeftRadius;
    float bottomRightRadius;

    public PureColorButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initDrawMaterial(attrs);
    }

    public PureColorButton(Context context) {
        super(context);
        this.initDrawMaterial(null);
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
        this.normalColor = bgColor;
    }

    public void setPressColor(int pressColor) {
        this.pressColor = pressColor;
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mBgDrawable = drawable2;
    }

    public void setDisableColr(int disableColr) {
        this.disableColor = disableColr;
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
    }

    public void setBgDrawable(Drawable bgDrawable) {
        this.mBgDrawable = bgDrawable;
    }

    private void initDrawMaterial(AttributeSet attrs) {
        this.setBackgroundColor(0);
        this.normalColor = -6710887;
        this.disableColor = -3355444;
        this.pressColor = -10066330;
        float defaultRadius = 0.0f;
        this.mRadius = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.topLeftRadius = defaultRadius;
        this.topRightRadius = defaultRadius;
        this.bottomLeftRadius = defaultRadius;
        this.bottomRightRadius = defaultRadius;
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.PureColorButton);
            this.normalColor = ta.getColor(R.styleable.PureColorButton_backgroundColor, this.normalColor);
            this.pressColor = ta.getColor(R.styleable.PureColorButton_pressColor, this.pressColor);
            this.disableColor = ta.getColor(R.styleable.PureColorButton_disableColor, this.disableColor);
            this.mBgDrawable = ta.getDrawable(R.styleable.PureColorButton_backgroundDrawable);
            this.mRadius = ta.getDimension(R.styleable.PureColorButton_radius, this.mRadius);
            this.topLeftRadius = ta.getDimension(R.styleable.PureColorButton_topLeftRadius, defaultRadius);
            this.topRightRadius = ta.getDimension(R.styleable.PureColorButton_topRightRadius, defaultRadius);
            this.bottomLeftRadius = ta.getDimension(R.styleable.PureColorButton_bottomLeftRadius, defaultRadius);
            this.bottomRightRadius = ta.getDimension(R.styleable.PureColorButton_bottomRightRadius, defaultRadius);
            ta.recycle();
        }
        this.bgColor = this.normalColor;
        if (!this.isEnabled()) {
            this.bgColor = this.disableColor;
        }
        this.mBgColorRect = new RectF();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        this.mPath = new Path();
    }

    public void setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
    }

    public void setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
    }

    public void setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
    }

    public void setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
    }

    public void setRadiusAll(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        this.topLeftRadius = topLeftRadius;
        this.topRightRadius = topRightRadius;
        this.bottomLeftRadius = bottomLeftRadius;
        this.bottomRightRadius = bottomRightRadius;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mBgColorRect.set(1.0f, 1.0f, (float)(this.getMeasuredWidth() - 1), (float)(this.getMeasuredHeight() - 1));
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.bgColor);
        if (this.topLeftRadius + this.topRightRadius + this.bottomLeftRadius + this.bottomRightRadius > 0.0f) {
            this.joinCornersPointsLine(canvas);
            canvas.drawPath(this.mPath, this.mPaint);
            this.drawCorners(canvas);
        } else {
            canvas.drawRoundRect(this.mBgColorRect, this.mRadius, this.mRadius, this.mPaint);
        }
        canvas.save();
        if (this.mBgDrawable != null && this.mBgDrawable instanceof BitmapDrawable) {
            this.mBgImage = ((BitmapDrawable)this.mBgDrawable).getBitmap();
        }
        if (this.mBgImage != null) {
            int left = this.getMeasuredWidth() / 2 - this.mBgImage.getWidth() / 2;
            int top = this.getMeasuredHeight() / 2 - this.mBgImage.getHeight() / 2;
            canvas.drawBitmap(this.mBgImage, (float)left, (float)top, this.mPaint);
        }
        this.translateDrawableToCenter(canvas);
        super.onDraw(canvas);
    }

    private void translateDrawableToCenter(Canvas canvas) {
        canvas.save();
        Drawable[] drawables = this.getCompoundDrawables();
        if (drawables != null) {
            Drawable leftD = drawables[0];
            Drawable topD = drawables[1];
            Drawable rightD = drawables[2];
            Drawable bottomD = drawables[3];
            this.translateLeftDrawable(canvas, leftD);
            this.translateTopDrawable(canvas, topD);
            this.translateRightDrawable(canvas, rightD);
            this.translateBottomDrawable(canvas, bottomD);
        }
    }

    private void translateLeftDrawable(Canvas canvas, Drawable leftDrawable) {
        if (leftDrawable != null) {
            float textWidth = this.getPaint().measureText(this.getText().toString());
            int drawablePadding = this.getCompoundDrawablePadding();
            int drawableWidth = 0;
            drawableWidth = leftDrawable.getIntrinsicWidth();
            float bodyWidth = textWidth + (float)drawableWidth + (float)drawablePadding;
            canvas.translate(((float)this.getWidth() - bodyWidth) / 2.0f, 0.0f);
        }
    }

    private void translateTopDrawable(Canvas canvas, Drawable topDrawable) {
        if (topDrawable != null) {
            int lineCount = this.getLineCount();
            float th = this.getLineHeight() * lineCount;
            int drawableHeight = topDrawable.getIntrinsicHeight();
            float adjust = TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            float contentHeight = th + (float)drawableHeight + (float)this.getCompoundDrawablePadding() + adjust;
            canvas.translate(0.0f, ((float)this.getHeight() - contentHeight) / 2.0f);
            this.setGravity(49);
        }
    }

    private void translateRightDrawable(Canvas canvas, Drawable rightDrawable) {
        if (rightDrawable != null) {
            // empty if block
        }
    }

    private void translateBottomDrawable(Canvas canvas, Drawable bottomDrawable) {
        if (bottomDrawable != null) {
            // empty if block
        }
    }

    private void joinCornersPointsLine(Canvas canvas) {
        float bottom;
        float right;
        float top;
        float left;
        this.mPath.reset();
        this.mPath.moveTo(0.0f, 0.0f);
        if (this.topLeftRadius != 0.0f) {
            this.mPath.lineTo(0.0f, this.topLeftRadius);
            this.mPath.lineTo(this.topLeftRadius, this.topLeftRadius);
            this.mPath.lineTo(this.topLeftRadius, 0.0f);
        } else {
            this.mPath.lineTo(0.0f, 0.0f);
        }
        if (this.topRightRadius != 0.0f) {
            left = (float)this.getMeasuredWidth() - this.topRightRadius;
            top = 0.0f;
            right = this.getMeasuredWidth();
            bottom = this.topRightRadius;
            this.mPath.lineTo(left, top);
            this.mPath.lineTo(left, bottom);
            this.mPath.lineTo(right, bottom);
        } else {
            this.mPath.lineTo((float)this.getMeasuredWidth(), 0.0f);
        }
        if (this.bottomRightRadius != 0.0f) {
            left = (float)this.getMeasuredWidth() - this.bottomRightRadius;
            top = (float)this.getMeasuredHeight() - this.bottomRightRadius;
            right = this.getMeasuredWidth();
            bottom = this.getMeasuredHeight();
            this.mPath.lineTo(right, top);
            this.mPath.lineTo(left, top);
            this.mPath.lineTo(left, bottom);
        } else {
            this.mPath.lineTo((float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        }
        if (this.bottomLeftRadius != 0.0f) {
            left = 0.0f;
            top = (float)this.getMeasuredHeight() - this.bottomLeftRadius;
            right = this.bottomLeftRadius;
            bottom = this.getMeasuredHeight();
            this.mPath.lineTo(right, bottom);
            this.mPath.lineTo(right, top);
            this.mPath.lineTo(left, top);
        } else {
            this.mPath.lineTo(0.0f, (float)this.getMeasuredHeight());
        }
    }

    private void drawCorners(Canvas canvas) {
        this.mPath.reset();
        if (this.topLeftRadius != 0.0f) {
            this.addTopLeftPath(canvas, this.mPaint, this.topLeftRadius);
        }
        if (this.topRightRadius != 0.0f) {
            this.addTopRight(canvas, this.mPaint, this.topRightRadius);
        }
        if (this.bottomLeftRadius != 0.0f) {
            this.addBottomLeft(canvas, this.mPaint, this.bottomLeftRadius);
        }
        if (this.bottomRightRadius != 0.0f) {
            this.addBottomRight(canvas, this.mPaint, this.bottomRightRadius);
        }
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.save();
    }

    private void addTopLeftPath(Canvas canvas, Paint paint, float radius) {
        float x2 = radius;
        float y = radius;
        this.mPath.addCircle(x2, y, radius, Path.Direction.CCW);
    }

    private void addTopRight(Canvas canvas, Paint paint, float radius) {
        float x2 = (float)this.getMeasuredWidth() - radius;
        float y = radius;
        this.mPath.addCircle(x2, y, radius, Path.Direction.CCW);
    }

    private void addBottomLeft(Canvas canvas, Paint paint, float radius) {
        float x2 = radius;
        float y = (float)this.getMeasuredHeight() - radius;
        this.mPath.addCircle(x2, y, radius, Path.Direction.CCW);
    }

    private void addBottomRight(Canvas canvas, Paint paint, float radius) {
        float x2 = (float)this.getMeasuredWidth() - radius;
        float y = (float)this.getMeasuredHeight() - radius;
        this.mPath.addCircle(x2, y, radius, Path.Direction.CCW);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled() && this.isClickable()) {
            int code = event.getAction();
            switch (code) {
                case 0: {
                    this.bgColor = this.pressColor;
                    break;
                }
                case 1: {
                    this.bgColor = this.normalColor;
                    break;
                }
                case 3: {
                    this.bgColor = this.normalColor;
                    break;
                }
            }
            this.invalidate();
        }
        return super.onTouchEvent(event);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.onEnableChanged();
    }

    private void onEnableChanged() {
        this.bgColor = this.isEnabled() ? this.normalColor : this.disableColor;
    }
}

