/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;

public class AutoLineFeedLayout
extends ViewGroup {
    private SparseIntArray lineHeigtCache = null;
    private int horizontalMargin = 10;
    private int verticalMargin = 10;
    private int lastLineResidualWidth = 0;
    int mWidthMeasureSpec;
    int mHeightMeasureSpec;

    public AutoLineFeedLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AutoLineFeedLayout(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(0);
        this.lineHeigtCache = new SparseIntArray();
    }

    public void setHorizontalMargin(int horizontalMargin) {
        this.horizontalMargin = horizontalMargin;
    }

    public int getHorizontalMargin() {
        return this.horizontalMargin;
    }

    public void setVerticalMargin(int verticalMargin) {
        this.verticalMargin = verticalMargin;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidthMeasureSpec = widthMeasureSpec;
        this.mHeightMeasureSpec = heightMeasureSpec;
        int viewHeight = this.layoutChilds(true);
        this.setMeasuredDimension(this.getMeasuredWidth(), viewHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChilds(false);
    }

    private int layoutChilds(boolean isMock) {
        if (isMock) {
            this.lineHeigtCache.clear();
        }
        int measureHeight = 0;
        int sumWidth = 0;
        measureHeight += this.getPaddingTop();
        sumWidth += this.getPaddingLeft();
        int lineNum = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int curChildWidth;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (isMock) {
                this.measureChild(child, this.mWidthMeasureSpec, this.mHeightMeasureSpec);
            }
            if (this.isEnoughWidth(sumWidth, curChildWidth = child.getMeasuredWidth())) {
                child.setTag((Object)lineNum);
            } else {
                sumWidth = 0;
                sumWidth += this.getPaddingLeft();
                measureHeight += this.verticalMargin + this.lineHeigtCache.get(lineNum);
                child.setTag((Object)(++lineNum));
            }
            if (isMock) {
                this.changeLineHeightCache(child);
            } else {
                int lh = this.lineHeigtCache.get(lineNum);
                int curChildHalfHeight = child.getMeasuredHeight() / 2;
                int t = measureHeight + lh / 2 - curChildHalfHeight;
                int b = measureHeight + lh / 2 + curChildHalfHeight;
                child.layout(sumWidth, t, sumWidth + curChildWidth, b);
            }
            sumWidth += this.horizontalMargin + curChildWidth;
        }
        this.lastLineResidualWidth = this.getMeasuredWidth() - sumWidth;
        return measureHeight += this.lineHeigtCache.get(lineNum) + this.getPaddingBottom();
    }

    private boolean isEnoughWidth(int sumWidth, int viewWidth) {
        return this.getMeasuredWidth() - this.getPaddingRight() - sumWidth >= viewWidth;
    }

    private void changeLineHeightCache(View child) {
        int lineNum = Integer.valueOf(child.getTag().toString());
        if (this.lineHeigtCache.get(lineNum) == 0) {
            this.lineHeigtCache.put(lineNum, child.getMeasuredHeight());
        } else {
            int exitHeight = this.lineHeigtCache.get(lineNum);
            this.lineHeigtCache.put(lineNum, Math.max(exitHeight, child.getMeasuredHeight()));
        }
    }

    public int getLineNum() {
        return this.lineHeigtCache.size();
    }

    public int getLastLineResidualWidth() {
        return this.lastLineResidualWidth;
    }

    public int getLineHeight() {
        int height = 0;
        for (int i = 0; i < this.lineHeigtCache.size(); ++i) {
            int h = this.lineHeigtCache.get(i);
            height = Math.max(height, h);
        }
        return height;
    }

    public int getVerticalMargin() {
        return this.verticalMargin;
    }
}

