/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util.tree;

import android.text.TextUtils;
import com.szboanda.android.platform.db.DbHelper;
import com.szboanda.android.platform.db.SQLiteDao;
import com.szboanda.android.platform.util.tree.ITreeNode;
import com.szboanda.android.platform.util.tree.TreeNodeAdapter;
import java.util.ArrayList;
import java.util.List;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.ColumnEntity;
import org.xutils.db.table.TableEntity;

public class TreeBuilder<T extends ITreeNode> {
    private boolean autoRecursive;
    private T mTree;
    private String pidColName;
    private Object rootNodeIdValue;
    private WhereBuilder whereBuilder;
    private TreeNodeAdapter mAdapter;
    private List<T> allNodes = null;
    SQLiteDao dao = null;
    TableEntity table = null;
    ColumnEntity mId = null;
    Class<T> classOfT;

    public TreeBuilder(String rootNodeIdValue, String pidColName) {
        this.rootNodeIdValue = rootNodeIdValue;
        this.pidColName = pidColName;
    }

    public TreeBuilder(TreeNodeAdapter adapter) {
        this.mAdapter = adapter;
        this.autoRecursive = true;
        adapter.setAutoRecursive(this.autoRecursive);
    }

    public void setExplicitId(ColumnEntity explicitId) {
        this.mId = explicitId;
    }

    public boolean isAutoRecursive() {
        return this.autoRecursive;
    }

    public void setAutoRecursive(boolean autoRecursive) {
        this.autoRecursive = autoRecursive;
        if (this.mAdapter != null) {
            this.mAdapter.setAutoRecursive(autoRecursive);
        }
    }

    public String getPidColName() {
        return this.pidColName;
    }

    public void setPidColName(String pidColName) {
        this.pidColName = pidColName;
    }

    public Object getRootNodeIdValue() {
        return this.rootNodeIdValue;
    }

    public void setRootNodeIdValue(Object rootNodeIdValue) {
        this.rootNodeIdValue = rootNodeIdValue;
    }

    public WhereBuilder getWhereBuilder() {
        return this.whereBuilder;
    }

    public void setWhereBuilder(WhereBuilder whereBuilder) {
        this.whereBuilder = whereBuilder;
    }

    public T getTree() {
        return this.mTree;
    }

    public void buildTree(Class<T> cls) {
        this.classOfT = cls;
        this.initDaoAndTableId(cls);
        if (!TextUtils.isEmpty((CharSequence)this.mId.getName())) {
            try {
                Object object = this.mTree = this.mAdapter == null ? this.getRootNode(this.dao, cls) : this.mAdapter.getRootNode(this.dao, this.rootNodeIdValue);
                if (this.mTree == null) {
                    return;
                }
                this.recursiveNode((ITreeNode)this.mTree, cls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.autoRecursive) {
            // empty if block
        }
    }

    public void initDaoAndTableId(Class<T> cls) {
        try {
            if (this.classOfT == null) {
                this.classOfT = cls;
            }
            this.dao = DbHelper.getDao();
            this.table = this.dao.getTable(cls);
            if (this.mId == null) {
                this.mId = this.table.getId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private T getRootNode(SQLiteDao dbUtils, Class<T> cls) {
        try {
            ITreeNode result = null;
            Selector<T> s = dbUtils.selector(cls);
            s.where(this.mId.getName(), "=", this.rootNodeIdValue);
            if (this.whereBuilder != null) {
                s.and(this.whereBuilder);
            }
            result = (ITreeNode)s.findFirst();
            if (this.autoRecursive) {
                Selector<T> si = dbUtils.selector(cls);
                if (this.whereBuilder != null) {
                    si.where(this.whereBuilder);
                }
                this.allNodes = si.findAll();
            }
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void recursiveNode(ITreeNode parent, Class<T> cls) {
        if (!parent.childEnable()) {
            return;
        }
        List<T> childNodes = null;
        try {
            List<Object> list = childNodes = this.mAdapter == null ? this.getChildNodes(parent, cls) : this.mAdapter.getChildNodes(this.dao, parent);
            if (childNodes != null && childNodes.size() > 0) {
                for (ITreeNode node : childNodes) {
                    parent.addChild(node);
                    if (!this.autoRecursive) continue;
                    this.recursiveNode(node, cls);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<T> getChildNodes(ITreeNode parent, Class<T> cls) {
        List<ITreeNode> childNodes = null;
        try {
            if (TextUtils.isEmpty((CharSequence)this.pidColName)) {
                throw new Exception("\u5fc5\u987b\u8bbe\u7f6e\u7236ID\u7684\u5b57\u6bb5\u540d");
            }
            Object idValue = this.mId.getColumnValue((Object)parent);
            if (this.autoRecursive && this.allNodes != null) {
                childNodes = new ArrayList();
                ColumnEntity parentCol = (ColumnEntity)this.table.getColumnMap().get(this.pidColName);
                for (ITreeNode n : this.allNodes) {
                    if (!String.valueOf(idValue).equals(String.valueOf(parentCol.getColumnValue((Object)n)))) continue;
                    childNodes.add(n);
                }
            } else {
                Selector<T> select = this.dao.selector(cls);
                select.where(this.pidColName, "=", idValue);
                if (this.whereBuilder != null) {
                    select.and(this.whereBuilder);
                }
                childNodes = select.findAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childNodes;
    }

    public void buildChildNodes(ITreeNode parent) {
        this.recursiveNode(parent, this.classOfT);
    }

    public void closeBuild() {
        if (!this.autoRecursive) {
            try {
                this.dao.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }

    public void clear() {
        this.mTree = null;
        if (this.allNodes != null) {
            this.allNodes.clear();
        }
    }
}

