/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.text.TextUtils;
import com.szboanda.android.platform.util.DistillStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static <E> String joinStringItem(List<E> items, String joinSign) {
        String joinedItems = "";
        if (items != null) {
            for (E p : items) {
                joinedItems = joinedItems + joinSign + p;
            }
            if (joinedItems.startsWith(joinSign)) {
                joinedItems = joinedItems.substring(1);
            }
        }
        return joinedItems;
    }

    public static String parseFileName(String filePath) {
        String[] parts;
        String fileName = filePath;
        if (!TextUtils.isEmpty((CharSequence)filePath) && (parts = (filePath = filePath.replaceAll("\\\\", "/")).split("/")) != null && parts.length > 0) {
            fileName = parts[parts.length - 1];
        }
        return fileName;
    }

    public static String delHTMLTag(String htmlStr) {
        if (htmlStr == null || "null".equals(htmlStr)) {
            return "";
        }
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static <E> List<String> distillItemsTitle(List<E> items, DistillStrategy<E> distillStrategy) {
        ArrayList<String> result = null;
        if (items != null && items.size() > 0) {
            result = new ArrayList<String>();
            for (E entity : items) {
                result.add(distillStrategy.getTitle(entity));
            }
        }
        return result;
    }

    public static String processNull(String oldStr) {
        if (TextUtils.isEmpty((CharSequence)oldStr) || "null".equals(oldStr) || "NULL".equals(oldStr)) {
            oldStr = "";
        }
        return oldStr;
    }
}

