/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.text.TextUtils;
import android.util.SparseArray;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class DateUtils {
    public static final String FORMAT_DATE_TIME_M = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_DATE_TIME_S = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_DASH = "yyyy-MM-dd";
    public static final String FORMAT_DATE_SLASH = "yyyy/MM/dd";
    public static final String FORMAT_DATE_NONE = "yyyyMMdd";
    public static final String FORMAT_TIME_HM = "HH:mm";
    public static final String FORMAT_TIME_HMS = "HH:mm:ss";
    public static final int SECONDS_OF_DAY = 86400;
    public static final long MILLIS_OF_DAY = 86400000L;

    public static boolean isWeekendDay(Date d) {
        if (d == null) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return DateUtils.isWeekendDay(c);
    }

    public static boolean isWeekendDay(Calendar c) {
        boolean result = false;
        int dayCode = c.get(7);
        if (dayCode == 7 || dayCode == 1) {
            result = true;
        }
        return result;
    }

    public static Date parseDate(String dateStr) {
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return new Date();
        }
        int strLength = dateStr.trim().length();
        String dateFormat = FORMAT_DATE_TIME_S.length() == strLength ? FORMAT_DATE_TIME_S : (FORMAT_DATE_TIME_M.length() == strLength ? FORMAT_DATE_TIME_M : (FORMAT_DATE_DASH.length() == strLength ? FORMAT_DATE_DASH : FORMAT_DATE_DASH));
        return DateUtils.parseDate(dateStr, dateFormat);
    }

    public static Date parseDate(String dateStr, String format) {
        try {
            if (!TextUtils.isEmpty((CharSequence)dateStr)) {
                SimpleDateFormat simpleDate = new SimpleDateFormat(format, Locale.getDefault());
                return simpleDate.parse(dateStr);
            }
            return new Date();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleDate = new SimpleDateFormat(format, Locale.getDefault());
        return simpleDate.format(date);
    }

    public static String formatDate(String dateStr, String oldformat, String format) {
        Date date = DateUtils.parseDate(dateStr, oldformat);
        return DateUtils.formatDate(date, format);
    }

    public static String formatMilliSeconds(long milliSecondsTime, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.getDefault());
        return dateFormat.format(milliSecondsTime);
    }

    public static boolean validDateDationality(String start, String end) {
        boolean result = false;
        if (!TextUtils.isEmpty((CharSequence)start) && !TextUtils.isEmpty((CharSequence)end)) {
            Date endDate;
            Date startDate = DateUtils.parseDate(start + (start.contains(":") ? "" : " 00:00"), FORMAT_DATE_TIME_M);
            if (startDate.before(endDate = DateUtils.parseDate(end + (end.contains(":") ? "" : " 23:59"), FORMAT_DATE_TIME_M))) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public static int getIntervalDays(String first, String another) {
        Date firstDate = DateUtils.parseDate(first, FORMAT_DATE_DASH);
        Date anotherDate = DateUtils.parseDate(another, FORMAT_DATE_DASH);
        return DateUtils.getIntervalDays(firstDate, anotherDate);
    }

    public static int getIntervalDays(Date first, Date another) {
        Calendar c = Calendar.getInstance();
        c.setTime(first);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        long firstM = c.getTimeInMillis();
        c.setTime(another);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        long secondM = c.getTimeInMillis();
        double intervalM = Math.abs(firstM - secondM);
        long dayNum = Math.round(intervalM / 8.64E7);
        return (int)dayNum;
    }

    public static String generateSerialNum() {
        String timeStr = DateUtils.formatDate(new Date(), "yyyyMMddHHmm");
        return timeStr + UUID.randomUUID().toString();
    }

    public static boolean isLeapYear(int year) {
        boolean isLeapYear = false;
        if (year % 4 == 0 && year % 100 > 0) {
            isLeapYear = true;
        }
        if (year % 100 == 0 && year % 400 == 0) {
            isLeapYear = true;
        }
        return isLeapYear;
    }

    public static Date getDayBefore(Date date, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, calendar.get(5) - day);
        calendar.set(2, calendar.get(2) - month);
        calendar.set(1, calendar.get(1) - year);
        return calendar.getTime();
    }

    public static Date getDateBefore(Date date, int year, int month, int day, int hour, int minute) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, calendar.get(5) - day);
        calendar.set(2, calendar.get(2) - month);
        calendar.set(1, calendar.get(1) - year);
        calendar.set(10, calendar.get(10) - hour);
        calendar.set(12, calendar.get(12) - minute);
        return calendar.getTime();
    }

    public static String getDayDescription(Date date) {
        String result = null;
        String[] descs = new String[]{"\u4eca\u5929", "\u6628\u5929", "#\u5929", "3\u5929#", "4\u5929#", "5\u5929#", "6\u5929#"};
        Date curDate = new Date();
        int intervalDays = DateUtils.getIntervalDays(date, curDate);
        if (intervalDays > 60) {
            result = "\u4e24\u4e2a\u6708#";
        } else if (intervalDays > 30) {
            result = "\u4e00\u4e2a\u6708#";
        } else if (intervalDays > 14) {
            result = "\u4e24\u5468#";
        } else if (intervalDays > 7) {
            result = "\u4e00\u5468#";
        } else {
            descs[1] = curDate.after(date) ? "\u6628\u5929" : "\u660e\u5929";
            result = descs[intervalDays];
        }
        result = result.replace("#", curDate.after(date) ? "\u524d" : "\u540e");
        return result;
    }

    public static String parseTimeDesc(Date cd) {
        Calendar c = Calendar.getInstance();
        long curMillSec = c.getTimeInMillis();
        SparseArray descs = new SparseArray();
        descs.put(60, (Object)new Object[]{"\u521a\u521a", 60});
        descs.put(3600, (Object)new Object[]{"%d\u5206\u949f\u524d", 60});
        descs.put(86400, (Object)new Object[]{"%d\u5c0f\u65f6\u524d", 3600});
        descs.put(345600, (Object)new Object[]{"%d\u5929\u524d", 86400});
        c.setTime(cd);
        long cc = c.getTimeInMillis();
        long diffSec = (curMillSec - cc) / 1000L;
        String desc = "";
        int num = -1;
        for (int i = 0; i < descs.size(); ++i) {
            int sec = descs.keyAt(i);
            if (diffSec >= (long)sec) continue;
            Object[] value = (Object[])descs.valueAt(i);
            desc = (String)value[0];
            int dividerFactor = Integer.valueOf(value[1].toString());
            num = (int)(diffSec / (long)dividerFactor);
            break;
        }
        desc = !TextUtils.isEmpty((CharSequence)desc) || desc.contains("%d") ? String.format(desc, num) : DateUtils.formatDate(cd, FORMAT_DATE_DASH);
        return desc;
    }

    public static String handTime(String time) {
        if (time == null || "".equals(time.trim())) {
            return "";
        }
        try {
            Date date = DateUtils.parseDate(time, FORMAT_DATE_TIME_S);
            long tm = System.currentTimeMillis();
            long tm2 = date.getTime();
            long d = (tm - tm2) / 1000L;
            if (d / 86400L > 0L) {
                return d / 86400L + "\u5929\u524d";
            }
            if (d / 3600L > 0L) {
                return d / 3600L + "\u5c0f\u65f6\u524d";
            }
            if (d / 60L > 0L) {
                return d / 60L + "\u5206\u949f\u524d";
            }
            return "\u521a\u521a";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String subjectiveTime(long timeInMillis) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(timeInMillis);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        if (year != now.get(1)) {
            return year + "\u5e74" + (month + 1) + "\u6708" + day + "\u65e5";
        }
        if (month == now.get(2) && day == now.get(5)) {
            int minute = cal.get(12);
            return cal.get(11) + ":" + (minute < 10 ? "0" : "") + minute;
        }
        return month + 1 + "\u6708" + day + "\u65e5";
    }

    public static boolean isTheSameDay(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) < 86400000L && DateUtils.millis2Day(d1.getTime()) == DateUtils.millis2Day(d2.getTime());
    }

    private static long millis2Day(long millis) {
        return (millis + (long)TimeZone.getDefault().getOffset(millis)) / 86400000L;
    }
}

