/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.szboanda.android.platform.util.AppInfoHelper;
import java.util.ArrayList;

public class AppDetector {
    Context context;
    String targetPackage;
    String appStoreAction;

    public AppDetector(Context context) {
        this.context = context;
        if (context == null) {
            throw new NullPointerException("context required !");
        }
        this.targetPackage = context.getPackageName();
    }

    public AppDetector setAppStoreAction(String appStoreAction) {
        this.appStoreAction = appStoreAction;
        return this;
    }

    public AppDetector setTargetPackage(String targetPackage) {
        if (!TextUtils.isEmpty((CharSequence)targetPackage)) {
            this.targetPackage = targetPackage;
        }
        return this;
    }

    public boolean detectPackage(ArrayList<String> packageList) {
        boolean result = true;
        if (packageList != null) {
            for (int i = 0; i < packageList.size(); ++i) {
                boolean available = AppInfoHelper.isAppAvailable(this.context, packageList.get(i));
                if (available) {
                    packageList.remove(packageList.get(i));
                    --i;
                }
                result &= available;
            }
            if (packageList.size() > 0) {
                this.startAppListActivity(packageList);
            }
        }
        return result;
    }

    protected void startAppListActivity(ArrayList<String> packageName) {
        if (TextUtils.isEmpty((CharSequence)this.appStoreAction) || TextUtils.isEmpty((CharSequence)this.targetPackage)) {
            return;
        }
        Intent intent = new Intent(this.appStoreAction);
        intent.setPackage(this.targetPackage);
        intent.putStringArrayListExtra("package_list", packageName);
        intent.setFlags(0x10000000);
        this.context.startActivity(intent);
    }

    public static class DetectPackageReceiver
    extends BroadcastReceiver {
        public static final String ACTION_DETECT_PACKAGE = "boanda.action.DETECT_PACKAGE";
        public static final String EXTRA_PACKAGE_LIST = "package_list";
        public static final String EXTRA_TARGET_PACKAGE = "target_package";
        public static final String EXTRA_ACTION_APP_STORE = "action_app_store";

        public void onReceive(Context context, Intent intent) {
            if (ACTION_DETECT_PACKAGE.equals(intent.getAction())) {
                new AppDetector(context).setTargetPackage(intent.getStringExtra(EXTRA_TARGET_PACKAGE)).setAppStoreAction(intent.getStringExtra(EXTRA_ACTION_APP_STORE)).detectPackage(intent.getStringArrayListExtra(EXTRA_PACKAGE_LIST));
            }
        }
    }
}

