/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.szboanda.android.platform.util.MessageDigestHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    public static final String TAG = AESUtils.class.getSimpleName();
    private boolean randomKey = false;

    public boolean defaultAesEncrypt(Context context, String explicitFilePath) {
        String digestName;
        String explicitName;
        String packageName = context.getPackageName();
        File explicitFile = new File(explicitFilePath);
        String explicitPath = explicitFile.getPath();
        String encryptPath = explicitPath.replace(explicitName = explicitFile.getName(), digestName = new MessageDigestHelper().getHexStringDigest(explicitName));
        File encryptFile = new File(encryptPath);
        if (encryptFile.exists() && encryptFile.length() == explicitFile.length()) {
            return true;
        }
        return this.randomKey ? this.aesCipherRandom(1, explicitFilePath, encryptPath, packageName) : this.aesCipherStable(1, explicitFilePath, encryptPath, packageName);
    }

    public boolean defaultAesEncrypt(Context context, String sourceFilePath, String targetFilePath) {
        String packageName = context.getPackageName();
        return this.randomKey ? this.aesCipherRandom(1, sourceFilePath, targetFilePath, packageName) : this.aesCipherStable(1, sourceFilePath, targetFilePath, packageName);
    }

    public boolean defaultAesDecrypt(Context context, String explicitFilePath) {
        String packageName = context.getPackageName();
        File explicitFile = new File(explicitFilePath);
        String explicitPath = explicitFile.getPath();
        String explicitName = explicitFile.getName();
        String digestName = new MessageDigestHelper().getHexStringDigest(explicitName);
        String encryptPath = explicitPath.replace(explicitName, digestName);
        File encryptFile = new File(encryptPath);
        if (explicitFile.exists() && explicitFile.length() == encryptFile.length()) {
            return true;
        }
        return this.randomKey ? this.aesCipherRandom(2, encryptPath, explicitPath, packageName) : this.aesCipherStable(2, encryptPath, explicitPath, packageName);
    }

    public boolean defaultAesDecrypt(Context context, String sourceFilePath, String targetFilePath) {
        String packageName = context.getPackageName();
        return this.randomKey ? this.aesCipherRandom(2, sourceFilePath, targetFilePath, packageName) : this.aesCipherStable(2, sourceFilePath, targetFilePath, packageName);
    }

    public boolean aesCipherStable(int cipherMode, String sourceFilePath, String targetFilePath, String seed) {
        byte[] rawkey = new byte[16];
        byte[] temp = seed.getBytes();
        if (temp.length >= rawkey.length) {
            rawkey = Arrays.copyOf(temp, rawkey.length);
        } else {
            for (int i = 0; i < rawkey.length; ++i) {
                rawkey[i] = temp[i % temp.length];
            }
        }
        return this.aesCipher(cipherMode, sourceFilePath, targetFilePath, rawkey);
    }

    public boolean aesCipherRandom(int cipherMode, String sourceFilePath, String targetFilePath, String seed) {
        try {
            byte[] rawkey = this.getRawKey(seed.getBytes());
            return this.aesCipher(cipherMode, sourceFilePath, targetFilePath, rawkey);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean aesCipher(int cipherMode, String sourceFilePath, String targetFilePath, byte[] rawkey) {
        boolean result = false;
        AbstractInterruptibleChannel sourceFC = null;
        AbstractInterruptibleChannel targetFC = null;
        try {
            if (cipherMode != 1 && cipherMode != 2) {
                Log.d((String)TAG, (String)"\u672a\u6307\u660e\u662f\u52a0\u5bc6\u8fd8\u662f\u89e3\u5bc6\u64cd\u4f5c");
                boolean bl = false;
                return bl;
            }
            Cipher mCipher = Cipher.getInstance("AES/CFB/NoPadding");
            File sourceFile = new File(sourceFilePath);
            File targetFile = new File(targetFilePath);
            sourceFC = new RandomAccessFile(sourceFile, "r").getChannel();
            targetFC = new RandomAccessFile(targetFile, "rw").getChannel();
            SecretKeySpec secretKey = new SecretKeySpec(rawkey, "AES");
            mCipher.init(cipherMode, (Key)secretKey, new IvParameterSpec(new byte[mCipher.getBlockSize()]));
            ByteBuffer byteData = ByteBuffer.allocate(1024);
            while (((FileChannel)sourceFC).read(byteData) != -1) {
                byteData.flip();
                byte[] byteList = new byte[byteData.remaining()];
                byteData.get(byteList, 0, byteList.length);
                byte[] bytes = mCipher.doFinal(byteList);
                ((FileChannel)targetFC).write(ByteBuffer.wrap(bytes));
                byteData.clear();
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (sourceFC != null) {
                    sourceFC.close();
                }
                if (targetFC != null) {
                    targetFC.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String encrypt(String seed, String source) {
        byte[] result = null;
        try {
            byte[] rawkey = this.getRawKey(seed.getBytes());
            result = this.encrypt(rawkey, source.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = this.toHex(result);
        return content;
    }

    public String encrypt(byte[] rawkey, String source) {
        byte[] result = null;
        try {
            result = this.encrypt(rawkey, source.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = this.toHex(result);
        return content;
    }

    public byte[] getRawKey(String seed) {
        byte[] rawkey = new byte[16];
        byte[] temp = seed.getBytes();
        if (temp.length >= rawkey.length) {
            rawkey = Arrays.copyOf(temp, rawkey.length);
        } else {
            for (int i = 0; i < rawkey.length; ++i) {
                rawkey[i] = temp[i % temp.length];
            }
        }
        return rawkey;
    }

    public String decrypt(byte[] rawKey, String encrypted) {
        try {
            byte[] enc = this.toByte(encrypted);
            byte[] result = this.decrypt(rawKey, enc);
            String coentn = new String(result);
            return coentn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decrypt(String seed, String encrypted) {
        try {
            byte[] rawKey = this.getRawKey(seed.getBytes());
            byte[] enc = this.toByte(encrypted);
            byte[] result = this.decrypt(rawKey, enc);
            String coentn = new String(result);
            return coentn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] getRawKey(byte[] seed) throws NoSuchAlgorithmException {
        SecureRandom sr = null;
        try {
            sr = Build.VERSION.SDK_INT >= 17 ? SecureRandom.getInstance("SHA1PRNG", "Crypto") : SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sr.setSeed(seed);
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128, sr);
        SecretKey key = keyGen.generateKey();
        byte[] raw = key.getEncoded();
        return raw;
    }

    private byte[] encrypt(byte[] raw, byte[] input) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)skeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        byte[] encrypted = cipher.doFinal(input);
        return encrypted;
    }

    private byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)skeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    public String toHex(String txt) {
        return this.toHex(txt.getBytes());
    }

    public String fromHex(String hex) {
        return new String(this.toByte(hex));
    }

    public byte[] toByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }

    public String toHex(byte[] buf) {
        if (buf == null || buf.length <= 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            this.appendHex(result, buf[i]);
        }
        return result.toString();
    }

    private void appendHex(StringBuffer sb, byte b) {
        String HEX = "0123456789ABCDEF";
        sb.append("0123456789ABCDEF".charAt(b >> 4 & 0xF)).append("0123456789ABCDEF".charAt(b & 0xF));
    }

    public void setRandomKey(boolean randomKey) {
        this.randomKey = randomKey;
    }

    public boolean getRandomKey() {
        return this.randomKey;
    }
}

