/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.http;

import android.app.Dialog;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.szboanda.android.platform.UniversalAsyncTask;
import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.dialog.CustomProgressDialog;
import com.szboanda.android.platform.dialog.PercentProgressDiaog;
import com.szboanda.android.platform.http.DownloadResponseProcessor;
import com.szboanda.android.platform.http.ParamsWrapper;
import com.szboanda.android.platform.http.ResponseProcessor;
import com.szboanda.android.platform.http.UploadResponseProcessor;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.xutils.HttpManager;
import org.xutils.common.Callback;
import org.xutils.x;

public class HttpTask {
    private static final int TIME_OUT_DEFAULT = 5000;
    private int mTimeOut = 0;
    private HttpManager mHttpManager;
    private Context mContext;
    private CustomProgressDialog mDialog;
    private boolean showProgressDiallog;
    private String tipMsg = "\u6b63\u5728\u8bf7\u6c42\u6570\u636e...";
    public static final String TEMP_DOWNLOAD_FILE_SUFFIX = ".dltemp";
    private Callback.Cancelable mCanceler = null;
    private PercentProgressDiaog mPercentDiaog;
    private DownloadResponseProcessor mDownloadProcessor;

    public HttpTask() {
        this(null, null);
    }

    public HttpTask(Context context) {
        this(context, null);
    }

    public HttpTask(Context context, String tipMsg) {
        this.mContext = context;
        this.tipMsg = tipMsg;
        this.showProgressDiallog = !TextUtils.isEmpty((CharSequence)tipMsg);
        this.mHttpManager = x.http();
    }

    public void setTimeOut(int timeout) {
        this.mTimeOut = timeout;
    }

    public HttpManager getHttpProxy() {
        return this.mHttpManager;
    }

    private void onPreInvoke() {
        if (this.mContext != null && this.showProgressDiallog && this.mDialog == null) {
            this.mDialog = new CustomProgressDialog(this.mContext);
            this.mDialog.setMessage(this.tipMsg);
            this.mDialog.show();
        }
    }

    public void executePost(ParamsWrapper params, ResponseProcessor processer) {
        this.executePost(params, true, processer);
    }

    public void executeGet(ParamsWrapper params, ResponseProcessor processer) {
        this.executeGet(params, true, processer);
    }

    public void executePost(ParamsWrapper params, boolean showProgress, ResponseProcessor processer) {
        this.execute("POST", params, showProgress, processer);
    }

    public void executeGet(ParamsWrapper params, boolean showProgress, ResponseProcessor processer) {
        this.execute("GET", params, showProgress, processer);
    }

    private void execute(String method, ParamsWrapper params, boolean showProgress, ResponseProcessor processer) {
        params.setConnectTimeout(this.mTimeOut == 0 ? 5000 : this.mTimeOut);
        this.showProgressDiallog = showProgress && !TextUtils.isEmpty((CharSequence)this.tipMsg);
        this.onPreInvoke();
        if (showProgress && this.mDialog != null) {
            processer.setProgressDialog(this.mDialog);
        }
        if (this.mContext != null) {
            processer.setContext(this.mContext);
        }
        this.mCanceler = "GET".equalsIgnoreCase(method) ? this.mHttpManager.get(params.getRequestParams(), (Callback.CommonCallback)processer) : this.mHttpManager.post(params.getRequestParams(), (Callback.CommonCallback)processer);
    }

    public void downloadFile(String targetPath, ParamsWrapper params, DownloadResponseProcessor processor) {
        if (this.showProgressDiallog) {
            this.mPercentDiaog = new PercentProgressDiaog(this.mContext, "\u4e0b\u8f7d\u6587\u4ef6");
            this.setOnClickListener();
        }
        this.downloadFile(targetPath, params, this.mPercentDiaog, processor);
    }

    public void downloadFile(String targetPath, ParamsWrapper params, IProgressChangeView progressView, DownloadResponseProcessor processor) {
        params.setConnectTimeout(this.mTimeOut == 0 ? 5000 : this.mTimeOut);
        params.setAutoRename(processor.isAutoRename());
        params.setAutoResume(true);
        this.mDownloadProcessor = processor;
        this.mDownloadProcessor.setTargetPath(targetPath);
        this.mDownloadProcessor.setContext(this.mContext);
        if (processor == null) {
            Log.i((String)"HttpTask#downloadFile", (String)"\u53c2\u6570\u3010DownloadResponseProcessor\u3011\u4e0d\u5e94\u4e3anull");
            return;
        }
        processor.setProgressView(progressView);
        String sdcardPath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/";
        if (!targetPath.startsWith(sdcardPath)) {
            targetPath = sdcardPath + targetPath;
        }
        if (new File(targetPath).exists()) {
            processor.onDownloadSuccess(new File(targetPath));
        } else {
            if (this.showProgressDiallog) {
                this.mPercentDiaog.show();
            }
            String tempSavePath = HttpTask.createDownloadPath(targetPath);
            params.setSaveFilePath(tempSavePath);
            this.mCanceler = this.mHttpManager.post(params.getRequestParams(), (Callback.CommonCallback)processor);
        }
    }

    public static String createDownloadPath(String targetPath) {
        int dotIndex = targetPath.lastIndexOf(".");
        String result = targetPath;
        if (dotIndex != -1) {
            String pathRemoveSuffix = targetPath.substring(0, dotIndex);
            result = pathRemoveSuffix + TEMP_DOWNLOAD_FILE_SUFFIX;
        }
        return result;
    }

    public void setOnClickListener() {
        this.mPercentDiaog.setPositiveButton("\u540e\u53f0\u4e0b\u8f7d", new BaseDialog.OnDialogButtonClickListener(){

            @Override
            public void onClick(Dialog dialog, View v) {
                HttpTask.this.mPercentDiaog.dismiss();
                HttpTask.this.mDownloadProcessor.setDownloadBackgroud(true);
            }
        });
        this.mPercentDiaog.setNegativeButton("\u505c\u6b62\u4e0b\u8f7d", new BaseDialog.OnDialogButtonClickListener(){

            @Override
            public void onClick(Dialog dialog, View v) {
                if (HttpTask.this.mCanceler != null && !HttpTask.this.mCanceler.isCancelled()) {
                    HttpTask.this.mCanceler.cancel();
                }
                HttpTask.this.mPercentDiaog.dismiss();
            }
        });
    }

    public void uploadFile(ParamsWrapper params, final ResponseProcessor processor) {
        PercentProgressDiaog uploadTipDiaog = new PercentProgressDiaog(this.mContext, "\u4e0a\u4f20\u6587\u4ef6");
        uploadTipDiaog.setPositiveButton("\u540e\u53f0\u4e0a\u4f20", new BaseDialog.OnDialogButtonClickListener(){

            @Override
            public void onClick(Dialog dialog, View v) {
                dialog.dismiss();
                if (processor instanceof UploadResponseProcessor) {
                    processor.setContext(HttpTask.this.mContext);
                    ((UploadResponseProcessor)processor).setTitle("\u4e0a\u4f20\u6587\u4ef6");
                    ((UploadResponseProcessor)processor).setBackgroundUpload(true);
                }
            }
        }).setNegativeButton("\u53d6\u6d88\u4e0a\u4f20", new BaseDialog.OnDialogButtonClickListener(){

            @Override
            public void onClick(Dialog dialog, View v) {
                dialog.dismiss();
                if (HttpTask.this.mCanceler != null) {
                    HttpTask.this.mCanceler.cancel();
                }
            }
        });
        uploadTipDiaog.show();
        this.uploadFile(params, uploadTipDiaog, processor);
    }

    public void uploadFile(ParamsWrapper params, IProgressChangeView changeView, ResponseProcessor processor) {
        if (processor == null) {
            Log.i((String)"HttpTask#uploadFile()", (String)"\u53c2\u6570\u3010UploadResponseProcessor\u3011\u4e0d\u5e94\u4e3anull");
            return;
        }
        if (changeView != null && processor instanceof UploadResponseProcessor) {
            try {
                changeView.initProgressMax(params.getRequestParams().getRequestBody().getContentLength());
                ((UploadResponseProcessor)processor).setChangeView(changeView);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        params.setMultipart(true);
        this.mCanceler = this.mHttpManager.post(params.getRequestParams(), (Callback.CommonCallback)processor);
    }

    public <E> E sendRequest(ParamsWrapper params, Class<E> responseCls) {
        Object rs = null;
        try {
            rs = this.mHttpManager.postSync(params.getRequestParams(), responseCls);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (E)rs;
    }

    public void downloadUrlFile(String urlStr, String savePath, final Runnable callback) {
        UniversalAsyncTask asyncTask = new UniversalAsyncTask(null){

            protected Object doInBackground(Object ... params) {
                return HttpTask.this.syncDownloadUrlFile(params[0].toString(), params[1].toString());
            }

            @Override
            protected void onPostExecute(Object result) {
                super.onPostExecute(result);
                if (((Boolean)result).booleanValue() && callback != null) {
                    callback.run();
                }
            }
        };
        asyncTask.execute(new Object[]{urlStr, savePath});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncDownloadUrlFile(String urlStr, String savePath) {
        boolean result = false;
        boolean isConnected = false;
        HttpURLConnection connection = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            URL url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            isConnected = true;
            InputStream is = connection.getInputStream();
            if (is != null) {
                int len;
                bis = new BufferedInputStream(is);
                File saveFile = new File(savePath);
                File dirFile = saveFile.getParentFile();
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                bos = new BufferedOutputStream(new FileOutputStream(saveFile));
                byte[] buffer = new byte[2048];
                boolean readLen = true;
                while ((len = bis.read(buffer)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, len);
                }
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null && isConnected) {
                    connection.disconnect();
                }
                if (bos != null) {
                    bos.close();
                    bis.close();
                }
            }
            catch (Exception ei) {
                ei.printStackTrace();
            }
        }
        return result;
    }
}

