/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.http;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.widget.RemoteViews;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.activity.PdfViewActivity;
import com.szboanda.android.platform.http.ErrorResolverFactory;
import com.szboanda.android.platform.http.IErroResolver;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import com.szboanda.android.platform.util.FileUtils;
import java.io.File;
import org.xutils.common.Callback;

public abstract class DownloadResponseProcessor
implements Callback.ProgressCallback<File> {
    private Context mContext;
    private boolean isDownloadBackgroud = false;
    private String mTargetPath;
    private String mDownloadFileName;
    private IProgressChangeView mProgressView;
    private boolean isAutoRename = false;
    private NotificationManager mNoticeManager;
    private Notification mNotice;
    RemoteViews rv = null;

    public IProgressChangeView getProgressView() {
        return this.mProgressView;
    }

    public void setProgressView(IProgressChangeView progressView) {
        this.mProgressView = progressView;
    }

    public void setAutoRename(boolean autoRename) {
        this.isAutoRename = autoRename;
    }

    public boolean isAutoRename() {
        return this.isAutoRename;
    }

    public void onSuccess(File downloadFile) {
        String suffix = FileUtils.parseFileSuffix(downloadFile.getAbsolutePath());
        if ("dltemp".equals(suffix)) {
            downloadFile.renameTo(new File(this.mTargetPath));
        }
        if (this.isAutoRename) {
            this.mTargetPath = downloadFile.getAbsolutePath();
        }
        if (this.mProgressView != null) {
            this.mProgressView.onFinish();
        }
        this.onDownloadSuccess(new File(this.mTargetPath));
    }

    public void onError(Throwable ex, boolean isOnCallback) {
        IErroResolver resolver;
        if (this.mProgressView != null) {
            this.mProgressView.onFinish();
        }
        if ((resolver = ErrorResolverFactory.newResolver(this.mContext, ex)) != null) {
            resolver.resolve();
        }
    }

    public void onLoading(long total, long current, boolean isUploading) {
        if (this.isDownloadBackgroud && this.mContext != null) {
            if (this.mNoticeManager == null) {
                this.mNoticeManager = (NotificationManager)this.mContext.getSystemService("notification");
            }
            this.noticeOnStatuBar(total, current, isUploading);
        }
        if (this.mProgressView != null) {
            this.mProgressView.initProgressMax(total);
            int ratio = (int)(Double.valueOf(current + "") / Double.valueOf(total + "") * 100.0);
            this.mProgressView.onProgressChanged(total, current, ratio);
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context mContext) {
        this.mContext = mContext;
    }

    public boolean isDownloadBackgroud() {
        return this.isDownloadBackgroud;
    }

    public String getTargetPath() {
        return this.mTargetPath;
    }

    public void setTargetPath(String targetPath) {
        this.mTargetPath = targetPath;
        this.mDownloadFileName = FileUtils.parseFileName(targetPath);
    }

    public void setDownloadBackgroud(boolean isDownloadBackgroud) {
        this.isDownloadBackgroud = isDownloadBackgroud;
    }

    private void noticeOnStatuBar(long total, long current, boolean isUploading) {
        PendingIntent p;
        int ratio = (int)(Double.valueOf(current + "") / Double.valueOf(total + "") * 100.0);
        if (this.mNotice == null) {
            int iconId;
            this.mNotice = new Notification();
            this.mNotice.flags |= 0x10;
            this.mNotice.tickerText = this.mDownloadFileName;
            this.mNotice.icon = iconId = FileUtils.getFileIconId(this.mContext, this.mDownloadFileName);
            this.rv = new RemoteViews(this.mContext.getPackageName(), R.layout.viewjar_progress_notice);
            this.rv.setTextViewText(R.id.title, (CharSequence)this.mDownloadFileName);
            this.rv.setImageViewResource(R.id.notice_icon, iconId);
            this.mNotice.contentView = this.rv;
        }
        this.rv.setTextViewText(R.id.percent, (CharSequence)(ratio + "%"));
        this.rv.setProgressBar(R.id.progress, 100, ratio, false);
        Intent i = new Intent(this.mContext, PdfViewActivity.class);
        this.mNotice.contentIntent = p = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)i, (int)0);
        this.mNoticeManager.notify(this.mTargetPath.hashCode(), this.mNotice);
    }

    public void onWaiting() {
    }

    public void onStarted() {
    }

    public void onCancelled(Callback.CancelledException cex) {
    }

    public void onFinished() {
    }

    public abstract void onDownloadSuccess(File var1);

    public abstract void onDownloadFailure(Throwable var1);
}

