/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.dialog;

import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RadioGroup;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.dialog.SelectItemAdapter;
import com.szboanda.android.platform.dialog.ViewDialog;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.view.BindableRadioButton;
import com.szboanda.android.platform.view.CustomViewBinder;
import org.json.JSONObject;

public class UniversalSelectItemDialog
extends DialogFragment {
    private ListView mListView;
    private EditText editQueryKeyWord;
    private SelectItemAdapter<?> mListAdapter = null;
    private boolean isSingleCheck = false;
    private CustomViewBinder mBinder;
    private String splitSign = ";";
    private JSONObject categoryCache = null;
    private String dialogTitle;
    private String positiveBtnText = "\u786e\u5b9a";
    private String negativeBtnText = "\u53d6\u6d88";
    private String mKeywordHint = null;
    boolean hasCheckChangeOccur = false;
    CompoundButton.OnCheckedChangeListener typeChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            UniversalSelectItemDialog.this.hasCheckChangeOccur = true;
        }
    };
    View.OnClickListener typeClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (UniversalSelectItemDialog.this.hasCheckChangeOccur) {
                UniversalSelectItemDialog.this.mListAdapter.onGroupSelectChange(v.getId() - 1);
                UniversalSelectItemDialog.this.hasCheckChangeOccur = false;
            }
        }
    };
    AdapterView.OnItemClickListener itemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> arg0, View arg1, int position, long id2) {
            if (UniversalSelectItemDialog.this.mListAdapter.isSingleCheck()) {
                UniversalSelectItemDialog.this.dismiss();
                UniversalSelectItemDialog.this.mListAdapter.onSingleItemCheck(position);
            } else {
                UniversalSelectItemDialog.this.mListAdapter.onMultiItemCheck(position);
            }
        }
    };
    BaseDialog.OnDialogButtonClickListener positiveListener = new BaseDialog.OnDialogButtonClickListener(){

        @Override
        public void onClick(Dialog dialog, View v) {
            UniversalSelectItemDialog.this.mListAdapter.onPositiveBtnClick();
        }
    };
    BaseDialog.OnDialogButtonClickListener negativeListener = new BaseDialog.OnDialogButtonClickListener(){

        @Override
        public void onClick(Dialog dialog, View v) {
            UniversalSelectItemDialog.this.mListAdapter.onPositiveBtnClick();
        }
    };
    Runnable refreshFilteTask = new Runnable(){

        @Override
        public void run() {
            String keyWord = UniversalSelectItemDialog.this.editQueryKeyWord.getText().toString();
            UniversalSelectItemDialog.this.mListAdapter.filteWithKeyword(keyWord);
        }
    };
    Handler mFilterHandler = new Handler();
    TextWatcher keyWordChangeWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            UniversalSelectItemDialog.this.mFilterHandler.postDelayed(UniversalSelectItemDialog.this.refreshFilteTask, 100L);
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
        }
    };

    public void setTitle(String title) {
        this.dialogTitle = title;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ViewDialog dialog = new ViewDialog((Context)this.getActivity());
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        View inflatetView = inflater.inflate(R.layout.platform_premium_select_dialog, null);
        this.initViews(inflatetView);
        if (!this.mListAdapter.isSingleCheck()) {
            dialog.setPositiveButton(this.positiveBtnText, this.positiveListener);
            dialog.setNegativeButton(this.negativeBtnText, this.negativeListener);
        }
        this.mBinder = new CustomViewBinder(inflatetView);
        this.mListView.setAdapter(this.mListAdapter);
        if (this.categoryCache != null) {
            this.mBinder.recursiveBindData(this.categoryCache, true);
        }
        dialog.setTitle(this.dialogTitle);
        dialog.setView(inflatetView);
        return dialog;
    }

    public void onDestroyView() {
        this.categoryCache = new JSONObject();
        this.mBinder.recursiveFetchJson(this.categoryCache);
        super.onDestroyView();
    }

    void initViews(View parent) {
        RadioGroup radioGroup = (RadioGroup)parent.findViewById(R.id.category_select_group);
        this.initSelectRadios(radioGroup);
        if (this.mListAdapter.getGroupTitles().length == 1) {
            radioGroup.setVisibility(8);
        }
        this.mListView = (ListView)parent.findViewById(R.id.factor_list_view);
        this.mListView.setOnItemClickListener(this.itemClickListener);
        this.mListView.setAdapter(this.mListAdapter);
        this.editQueryKeyWord = (EditText)parent.findViewById(R.id.key_word_input);
        this.editQueryKeyWord.addTextChangedListener(this.keyWordChangeWatcher);
        if (!TextUtils.isEmpty((CharSequence)this.mKeywordHint)) {
            this.editQueryKeyWord.setHint((CharSequence)this.mKeywordHint);
        }
        if (this.mListAdapter.getCount() < 10) {
            this.editQueryKeyWord.setVisibility(8);
        } else {
            this.editQueryKeyWord.setVisibility(0);
        }
    }

    void initSelectRadios(RadioGroup parent) {
        int index = 0;
        for (String title : this.mListAdapter.getGroupTitles()) {
            BindableRadioButton radioBtn = new BindableRadioButton((Context)this.getActivity());
            radioBtn.setText(title);
            radioBtn.setId(index + 1);
            radioBtn.setField("TYPE_" + index);
            radioBtn.setFieldValue("1");
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            if (index == 0) {
                radioBtn.setChecked(true);
            } else {
                lp.rightMargin = DimensionUtils.dip2Px((Context)this.getActivity(), 5);
            }
            radioBtn.setLayoutParams((ViewGroup.LayoutParams)lp);
            radioBtn.setOnCheckedChangeListener(this.typeChangeListener);
            radioBtn.setOnClickListener(this.typeClickListener);
            parent.addView((View)radioBtn, index);
            ++index;
        }
    }

    public boolean isSingleCheck() {
        return this.isSingleCheck;
    }

    public void setSingleCheck(boolean isSingleCheck) {
        this.isSingleCheck = isSingleCheck;
    }

    public String getSplitSign() {
        return this.splitSign;
    }

    public void setSplitSign(String splitSign) {
        this.splitSign = splitSign;
    }

    public void setAdapter(SelectItemAdapter<?> adapter) {
        this.mListAdapter = adapter;
    }

    public void setPositiveText(String positiveText) {
        this.positiveBtnText = positiveText;
    }

    public void setNegativeText(String negativeText) {
        this.negativeBtnText = negativeText;
    }

    public void setKeywordHint(String hint) {
        this.mKeywordHint = hint;
    }

    public SelectItemAdapter<?> getAdapter() {
        return this.mListAdapter;
    }

    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
    }
}

