/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.dialog;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.util.DimensionUtils;

public class MessageDialog
extends BaseDialog {
    TextView txtMessage;
    Button btnConfirm;
    Button btnCancel;
    WindowManager.LayoutParams dialogLayoutParams = null;
    Handler mHandler = new Handler();

    public MessageDialog(Context context) {
        this(context, "");
    }

    public MessageDialog(Context context, String message) {
        super(context);
        this.context = context;
        View contentView = this.buildContentView();
        this.setContentView(contentView);
        this.initWidth();
        this.btnCancel.setBackgroundResource(R.drawable.viewjar_selector_sky_blue_btn);
        this.btnCancel.setTextColor(-1);
        this.setNegativeButton("\u786e\u5b9a", null);
        this.setMessage(message);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                int lineCount = MessageDialog.this.txtMessage.getLineCount();
                if (lineCount > 1) {
                    MessageDialog.this.txtMessage.setGravity(19);
                } else {
                    MessageDialog.this.txtMessage.setGravity(17);
                }
            }
        }, 100L);
    }

    private void initWidth() {
        this.dialogLayoutParams = this.getWindow().getAttributes();
        this.dialogLayoutParams.width = DimensionUtils.dip2Px(this.getContext(), 276);
        this.getWindow().setAttributes(this.dialogLayoutParams);
    }

    private View buildContentView() {
        LinearLayout linearRoot = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams lpRoot = new LinearLayout.LayoutParams(-1, -2);
        linearRoot.setOrientation(1);
        linearRoot.setGravity(1);
        linearRoot.setLayoutParams((ViewGroup.LayoutParams)lpRoot);
        linearRoot.setBackgroundResource(R.drawable.viewjar_dialog_light_gray_frame);
        this.addTitleView((ViewGroup)linearRoot);
        ViewGroup mainView = this.addMainView((ViewGroup)linearRoot);
        this.addMessageView(mainView);
        this.addBottomBlock(mainView);
        return linearRoot;
    }

    private void addTitleView(ViewGroup linearRoot) {
        this.titleView = new TextView(this.getContext());
        this.titleView.setText((CharSequence)"\u6e29\u99a8\u63d0\u793a");
        this.titleView.setGravity(17);
        this.titleView.setBackgroundResource(R.drawable.viewjar_dialog_title_light_gray_bg);
        this.titleView.setTextSize(20.0f);
        this.titleView.setTextColor(Color.parseColor((String)"#666666"));
        this.titleView.setShadowLayer(1.0f, 1.0f, 1.0f, Color.parseColor((String)"#999999"));
        linearRoot.addView((View)this.titleView);
    }

    private ViewGroup addMainView(ViewGroup linearRoot) {
        LinearLayout linearMain = new LinearLayout(this.getContext());
        linearMain.setOrientation(1);
        linearMain.setBackgroundResource(R.drawable.viewjar_message_bg);
        LinearLayout.LayoutParams lpMain = new LinearLayout.LayoutParams(-1, -2);
        linearMain.setLayoutParams((ViewGroup.LayoutParams)lpMain);
        linearRoot.addView((View)linearMain);
        return linearMain;
    }

    private void addMessageView(ViewGroup linearMain) {
        int msgMargin;
        this.txtMessage = new TextView(this.getContext());
        this.txtMessage.setTextSize(18.0f);
        this.txtMessage.setTextColor(Color.parseColor((String)"#666666"));
        this.txtMessage.setMaxWidth(DimensionUtils.getScreenWidth(this.getContext(), 50));
        this.txtMessage.setGravity(17);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.leftMargin = msgMargin = DimensionUtils.dip2Px(this.getContext(), 15);
        lp.rightMargin = msgMargin;
        this.txtMessage.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.txtMessage.setMinHeight(DimensionUtils.dip2Px(this.getContext(), 56));
        linearMain.addView((View)this.txtMessage);
    }

    private void addBottomBlock(ViewGroup linearMain) {
        int lrMargin;
        LinearLayout linearBtnContainer = new LinearLayout(this.getContext());
        linearBtnContainer.setOrientation(0);
        LinearLayout.LayoutParams lpBtnContainer = new LinearLayout.LayoutParams(-1, -2);
        lpBtnContainer.topMargin = DimensionUtils.dip2Px(this.getContext(), 15);
        linearBtnContainer.setLayoutParams((ViewGroup.LayoutParams)lpBtnContainer);
        linearMain.addView((View)linearBtnContainer);
        this.btnConfirm = new Button(this.getContext());
        this.btnConfirm.setText((CharSequence)"\u786e\u5b9a");
        this.btnConfirm.setTextSize(18.0f);
        this.btnConfirm.setTextColor(-1);
        this.btnConfirm.setBackgroundResource(R.drawable.viewjar_selector_sky_blue_btn);
        LinearLayout.LayoutParams lpConfirm = new LinearLayout.LayoutParams(0, -2);
        lpConfirm.weight = 1.0f;
        lpConfirm.leftMargin = lrMargin = DimensionUtils.dip2Px(this.getContext(), 5);
        lpConfirm.rightMargin = lrMargin;
        this.btnConfirm.setLayoutParams((ViewGroup.LayoutParams)lpConfirm);
        this.btnConfirm.setVisibility(8);
        linearBtnContainer.addView((View)this.btnConfirm);
        this.btnCancel = new Button(this.getContext());
        this.btnCancel.setText((CharSequence)"\u53d6\u6d88");
        this.btnCancel.setTextSize(18.0f);
        this.btnCancel.setTextColor(Color.parseColor((String)"#666666"));
        this.btnCancel.setBackgroundResource(R.drawable.viewjar_selector_light_gray_btn);
        LinearLayout.LayoutParams lpCancle = new LinearLayout.LayoutParams(0, -2);
        lpCancle.weight = 1.0f;
        lpCancle.leftMargin = lrMargin;
        lpCancle.rightMargin = lrMargin;
        this.btnCancel.setLayoutParams((ViewGroup.LayoutParams)lpCancle);
        this.btnCancel.setVisibility(8);
        linearBtnContainer.addView((View)this.btnCancel);
    }

    public MessageDialog setTitle(String title) {
        if (!TextUtils.isEmpty((CharSequence)title) && null != this.titleView) {
            this.titleView.setText((CharSequence)title);
        }
        return this;
    }

    public MessageDialog setMessage(String message) {
        this.txtMessage.setText((CharSequence)message);
        return this;
    }

    public MessageDialog setPositiveButton(CharSequence text, BaseDialog.OnDialogButtonClickListener listener) {
        this.btnConfirm.setVisibility(0);
        this.btnConfirm.setTag((Object)listener);
        this.btnConfirm.setText(text);
        this.btnCancel.setText((CharSequence)"\u53d6\u6d88");
        this.btnCancel.setTextColor(Color.parseColor((String)"#666666"));
        this.btnCancel.setBackgroundResource(R.drawable.viewjar_selector_light_gray_btn);
        this.btnConfirm.setOnClickListener((View.OnClickListener)this.mListener);
        return this;
    }

    public MessageDialog setNegativeButton(CharSequence text, BaseDialog.OnDialogButtonClickListener listener) {
        this.btnCancel.setVisibility(0);
        this.btnCancel.setTag((Object)listener);
        this.btnCancel.setText(text);
        this.btnCancel.setOnClickListener((View.OnClickListener)this.mListener);
        return this;
    }

    public MessageDialog setPositiveButton(int textId, BaseDialog.OnDialogButtonClickListener listener) {
        String text = this.context.getResources().getString(textId);
        this.setPositiveButton(text, listener);
        return this;
    }

    public MessageDialog setNegativeButton(int textId, BaseDialog.OnDialogButtonClickListener listener) {
        String text = this.context.getResources().getString(textId);
        this.setNegativeButton(text, listener);
        return this;
    }
}

