/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.view;

import android.app.Activity;
import android.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.xutils.ViewInjector;
import org.xutils.common.util.LogUtil;
import org.xutils.view.EventListenerManager;
import org.xutils.view.ViewFinder;
import org.xutils.view.ViewInfo;
import org.xutils.view.annotation.ContentView;
import org.xutils.view.annotation.Event;
import org.xutils.view.annotation.ViewInject;
import org.xutils.x;

public final class ViewInjectorImpl
implements ViewInjector {
    private static final HashSet<Class<?>> IGNORED = new HashSet();
    private static final Object lock;
    private static volatile ViewInjectorImpl instance;

    private ViewInjectorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new ViewInjectorImpl();
                }
            }
        }
        x.Ext.setViewInjector(instance);
    }

    @Override
    public void inject(View view) {
        ViewInjectorImpl.injectObject(view, view.getClass(), new ViewFinder(view));
    }

    @Override
    public void inject(Activity activity) {
        Class<?> handlerType = activity.getClass();
        try {
            int viewId;
            ContentView contentView = ViewInjectorImpl.findContentView(handlerType);
            if (contentView != null && (viewId = contentView.value()) > 0) {
                Method setContentViewMethod = handlerType.getMethod("setContentView", Integer.TYPE);
                setContentViewMethod.invoke((Object)activity, viewId);
            }
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        ViewInjectorImpl.injectObject(activity, handlerType, new ViewFinder(activity));
    }

    @Override
    public void inject(Object handler, View view) {
        ViewInjectorImpl.injectObject(handler, handler.getClass(), new ViewFinder(view));
    }

    @Override
    public View inject(Object fragment, LayoutInflater inflater, ViewGroup container) {
        View view = null;
        Class<?> handlerType = fragment.getClass();
        try {
            int viewId;
            ContentView contentView = ViewInjectorImpl.findContentView(handlerType);
            if (contentView != null && (viewId = contentView.value()) > 0) {
                view = inflater.inflate(viewId, container, false);
            }
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        ViewInjectorImpl.injectObject(fragment, handlerType, new ViewFinder(view));
        return view;
    }

    private static ContentView findContentView(Class<?> thisCls) {
        if (thisCls == null || IGNORED.contains(thisCls)) {
            return null;
        }
        ContentView contentView = thisCls.getAnnotation(ContentView.class);
        if (contentView == null) {
            return ViewInjectorImpl.findContentView(thisCls.getSuperclass());
        }
        return contentView;
    }

    private static void injectObject(Object handler, Class<?> handlerType, ViewFinder finder) {
        Method[] methods;
        if (handlerType == null || IGNORED.contains(handlerType)) {
            return;
        }
        ViewInjectorImpl.injectObject(handler, handlerType.getSuperclass(), finder);
        Field[] fields = handlerType.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                ViewInject viewInject;
                Class<?> fieldType = field.getType();
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || fieldType.isPrimitive() || fieldType.isArray() || (viewInject = field.getAnnotation(ViewInject.class)) == null) continue;
                try {
                    View view = finder.findViewById(viewInject.value(), viewInject.parentId());
                    if (view == null) {
                        throw new RuntimeException("Invalid @ViewInject for " + handlerType.getSimpleName() + "." + field.getName());
                    }
                    field.setAccessible(true);
                    field.set(handler, view);
                }
                catch (Throwable ex) {
                    LogUtil.e(ex.getMessage(), ex);
                }
            }
        }
        if ((methods = handlerType.getDeclaredMethods()) != null && methods.length > 0) {
            for (Method method : methods) {
                Event event;
                if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPrivate(method.getModifiers()) || (event = method.getAnnotation(Event.class)) == null) continue;
                try {
                    int[] values = event.value();
                    int[] parentIds = event.parentId();
                    int parentIdsLen = parentIds == null ? 0 : parentIds.length;
                    for (int i = 0; i < values.length; ++i) {
                        int value = values[i];
                        if (value <= 0) continue;
                        ViewInfo info = new ViewInfo();
                        info.value = value;
                        info.parentId = parentIdsLen > i ? parentIds[i] : 0;
                        method.setAccessible(true);
                        EventListenerManager.addEventMethod(finder, info, event, handler, method);
                    }
                }
                catch (Throwable ex) {
                    LogUtil.e(ex.getMessage(), ex);
                }
            }
        }
    }

    static {
        IGNORED.add(Object.class);
        IGNORED.add(Activity.class);
        IGNORED.add(Fragment.class);
        try {
            IGNORED.add(Class.forName("android.support.v4.app.Fragment"));
            IGNORED.add(Class.forName("android.support.v4.app.FragmentActivity"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lock = new Object();
    }
}

