/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.request;

import android.text.TextUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.xutils.common.util.LogUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.app.RequestTracker;
import org.xutils.http.request.AssetsRequest;
import org.xutils.http.request.HttpRequest;
import org.xutils.http.request.LocalFileRequest;
import org.xutils.http.request.UriRequest;

public final class UriRequestFactory {
    private static Class<? extends RequestTracker> defaultTrackerCls;
    private static final HashMap<String, Class<? extends UriRequest>> SCHEME_CLS_MAP;

    private UriRequestFactory() {
    }

    public static UriRequest getUriRequest(RequestParams params, Type loadType) throws Throwable {
        String scheme = null;
        String uri = params.getUri();
        int index = uri.indexOf(":");
        if (index > 0) {
            scheme = uri.substring(0, index);
        } else if (uri.startsWith("/")) {
            scheme = "file";
        }
        if (!TextUtils.isEmpty((CharSequence)scheme)) {
            Class<? extends UriRequest> cls = SCHEME_CLS_MAP.get(scheme);
            if (cls != null) {
                Constructor<? extends UriRequest> constructor = cls.getConstructor(RequestParams.class, Class.class);
                return constructor.newInstance(params, loadType);
            }
            if (scheme.startsWith("http")) {
                return new HttpRequest(params, loadType);
            }
            if (scheme.equals("assets")) {
                return new AssetsRequest(params, loadType);
            }
            if (scheme.equals("file")) {
                return new LocalFileRequest(params, loadType);
            }
            throw new IllegalArgumentException("The url not be support: " + uri);
        }
        throw new IllegalArgumentException("The url not be support: " + uri);
    }

    public static void registerDefaultTrackerClass(Class<? extends RequestTracker> trackerCls) {
        defaultTrackerCls = trackerCls;
    }

    public static RequestTracker getDefaultTracker() {
        try {
            return defaultTrackerCls == null ? null : defaultTrackerCls.newInstance();
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
            return null;
        }
    }

    public static void registerRequestClass(String scheme, Class<? extends UriRequest> uriRequestCls) {
        SCHEME_CLS_MAP.put(scheme, uriRequestCls);
    }

    static {
        SCHEME_CLS_MAP = new HashMap();
    }
}

