/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.request;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.xutils.common.util.IOUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.loader.FileLoader;
import org.xutils.http.request.UriRequest;

public class LocalFileRequest
extends UriRequest {
    private InputStream inputStream;

    LocalFileRequest(RequestParams params, Type loadType) throws Throwable {
        super(params, loadType);
    }

    @Override
    public void sendRequest() throws Throwable {
    }

    @Override
    public boolean isLoading() {
        return true;
    }

    @Override
    public String getCacheKey() {
        return null;
    }

    @Override
    public Object loadResult() throws Throwable {
        if (this.loader instanceof FileLoader) {
            return this.getFile();
        }
        return this.loader.load(this);
    }

    @Override
    public Object loadResultFromCache() throws Throwable {
        return null;
    }

    @Override
    public void clearCacheHeader() {
    }

    @Override
    public void save2Cache() {
    }

    private File getFile() {
        String filePath = null;
        filePath = this.queryUrl.startsWith("file:") ? this.queryUrl.substring("file:".length()) : this.queryUrl;
        return new File(filePath);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new FileInputStream(this.getFile());
        }
        return this.inputStream;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeQuietly(this.inputStream);
        this.inputStream = null;
    }

    @Override
    public long getContentLength() {
        return this.getFile().length();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.getFile().exists() ? 200 : 404;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return null;
    }

    @Override
    public long getExpiration() {
        return -1L;
    }

    @Override
    public long getLastModified() {
        return this.getFile().lastModified();
    }

    @Override
    public String getETag() {
        return null;
    }

    @Override
    public String getResponseHeader(String name) {
        return null;
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return null;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        return defaultValue;
    }
}

