/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.loader;

import android.text.TextUtils;
import java.io.InputStream;
import org.json.JSONObject;
import org.xutils.cache.DiskCacheEntity;
import org.xutils.common.util.IOUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.loader.Loader;
import org.xutils.http.request.UriRequest;

class JSONObjectLoader
extends Loader<JSONObject> {
    private String charset = "UTF-8";
    private String resultStr = null;

    JSONObjectLoader() {
    }

    @Override
    public Loader<JSONObject> newInstance() {
        return new JSONObjectLoader();
    }

    @Override
    public void setParams(RequestParams params) {
        String charset;
        if (params != null && !TextUtils.isEmpty((CharSequence)(charset = params.getCharset()))) {
            this.charset = charset;
        }
    }

    @Override
    public JSONObject load(InputStream in) throws Throwable {
        this.resultStr = IOUtil.readStr(in, this.charset);
        return new JSONObject(this.resultStr);
    }

    @Override
    public JSONObject load(UriRequest request) throws Throwable {
        request.sendRequest();
        return this.load(request.getInputStream());
    }

    @Override
    public JSONObject loadFromCache(DiskCacheEntity cacheEntity) throws Throwable {
        String text;
        if (cacheEntity != null && !TextUtils.isEmpty((CharSequence)(text = cacheEntity.getTextContent()))) {
            return new JSONObject(text);
        }
        return null;
    }

    @Override
    public void save2Cache(UriRequest request) {
        this.saveStringCache(request, this.resultStr);
    }
}

