/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.loader;

import android.text.TextUtils;
import java.io.InputStream;
import org.json.JSONArray;
import org.xutils.cache.DiskCacheEntity;
import org.xutils.common.util.IOUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.loader.Loader;
import org.xutils.http.request.UriRequest;

class JSONArrayLoader
extends Loader<JSONArray> {
    private String charset = "UTF-8";
    private String resultStr = null;

    JSONArrayLoader() {
    }

    @Override
    public Loader<JSONArray> newInstance() {
        return new JSONArrayLoader();
    }

    @Override
    public void setParams(RequestParams params) {
        String charset;
        if (params != null && !TextUtils.isEmpty((CharSequence)(charset = params.getCharset()))) {
            this.charset = charset;
        }
    }

    @Override
    public JSONArray load(InputStream in) throws Throwable {
        this.resultStr = IOUtil.readStr(in, this.charset);
        return new JSONArray(this.resultStr);
    }

    @Override
    public JSONArray load(UriRequest request) throws Throwable {
        request.sendRequest();
        return this.load(request.getInputStream());
    }

    @Override
    public JSONArray loadFromCache(DiskCacheEntity cacheEntity) throws Throwable {
        String text;
        if (cacheEntity != null && !TextUtils.isEmpty((CharSequence)(text = cacheEntity.getTextContent()))) {
            return new JSONArray(text);
        }
        return null;
    }

    @Override
    public void save2Cache(UriRequest request) {
        this.saveStringCache(request, this.resultStr);
    }
}

