/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.body;

import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xutils.common.Callback;
import org.xutils.common.util.IOUtil;
import org.xutils.http.ProgressHandler;
import org.xutils.http.body.ProgressBody;

public class InputStreamBody
implements ProgressBody {
    private InputStream content;
    private String contentType;
    private final long total;
    private long current = 0L;
    private ProgressHandler callBackHandler;

    public InputStreamBody(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamBody(InputStream inputStream, String contentType) {
        this.content = inputStream;
        this.contentType = contentType;
        this.total = InputStreamBody.getInputStreamLength(inputStream);
    }

    @Override
    public void setProgressHandler(ProgressHandler progressHandler) {
        this.callBackHandler = progressHandler;
    }

    @Override
    public long getContentLength() {
        return this.total;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return TextUtils.isEmpty((CharSequence)this.contentType) ? "application/octet-stream" : this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.callBackHandler != null && !this.callBackHandler.updateProgress(this.total, this.current, true)) {
            throw new Callback.CancelledException("upload stopped!");
        }
        byte[] buffer = new byte[1024];
        try {
            int len = 0;
            while ((len = this.content.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                this.current += (long)len;
                if (this.callBackHandler == null || this.callBackHandler.updateProgress(this.total, this.current, false)) continue;
                throw new Callback.CancelledException("upload stopped!");
            }
            out.flush();
            if (this.callBackHandler != null) {
                this.callBackHandler.updateProgress(this.total, this.total, true);
            }
        }
        finally {
            IOUtil.closeQuietly(this.content);
        }
    }

    public static long getInputStreamLength(InputStream inputStream) {
        try {
            if (inputStream instanceof FileInputStream || inputStream instanceof ByteArrayInputStream) {
                return inputStream.available();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }
}

