/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.cache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.xutils.cache.DiskCacheEntity;
import org.xutils.cache.LruDiskCache;
import org.xutils.common.util.IOUtil;
import org.xutils.common.util.ProcessLock;

public final class DiskCacheFile
extends File
implements Closeable {
    DiskCacheEntity cacheEntity;
    ProcessLock lock;

    DiskCacheFile(DiskCacheEntity cacheEntity, String path, ProcessLock lock) {
        super(path);
        this.cacheEntity = cacheEntity;
        this.lock = lock;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeQuietly(this.lock);
    }

    public DiskCacheFile commit() throws IOException {
        return this.getDiskCache().commitDiskCacheFile(this);
    }

    public LruDiskCache getDiskCache() {
        String dirName = this.getParentFile().getName();
        return LruDiskCache.getDiskCache(dirName);
    }

    public DiskCacheEntity getCacheEntity() {
        return this.cacheEntity;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

