/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.RectF;
import android.os.Handler;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.ProgressDialogX;
import com.artifex.mupdfdemo.SearchTaskResult;

public abstract class SearchTask {
    private static final int SEARCH_PROGRESS_DELAY = 200;
    private final Context mContext;
    private final MuPDFCore mCore;
    private final Handler mHandler;
    private final AlertDialog.Builder mAlertBuilder;
    private AsyncTask<Void, Integer, SearchTaskResult> mSearchTask;

    public SearchTask(Context context, MuPDFCore core) {
        this.mContext = context;
        this.mCore = core;
        this.mHandler = new Handler();
        this.mAlertBuilder = new AlertDialog.Builder(context);
    }

    protected abstract void onTextFound(SearchTaskResult var1);

    public void stop() {
        if (this.mSearchTask != null) {
            this.mSearchTask.cancel(true);
            this.mSearchTask = null;
        }
    }

    public void go(final String text, int direction, int displayPage, int searchPage) {
        if (this.mCore == null) {
            return;
        }
        this.stop();
        final int increment = direction;
        final int startIndex = searchPage == -1 ? displayPage : searchPage + increment;
        final ProgressDialogX progressDialog = new ProgressDialogX(this.mContext);
        progressDialog.setProgressStyle(1);
        progressDialog.setTitle(this.mContext.getString(2131099660));
        progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                SearchTask.this.stop();
            }
        });
        progressDialog.setMax(this.mCore.countPages());
        this.mSearchTask = new AsyncTask<Void, Integer, SearchTaskResult>(){

            protected SearchTaskResult doInBackground(Void ... params) {
                int index = startIndex;
                while (index >= 0 && index < SearchTask.this.mCore.countPages() && !this.isCancelled()) {
                    this.publishProgress(index);
                    RectF[] searchHits = SearchTask.this.mCore.searchPage(index, text);
                    if (searchHits != null && searchHits.length > 0) {
                        return new SearchTaskResult(text, index, searchHits);
                    }
                    index += increment;
                }
                return null;
            }

            @Override
            protected void onPostExecute(SearchTaskResult result) {
                progressDialog.cancel();
                if (result != null) {
                    SearchTask.this.onTextFound(result);
                } else {
                    SearchTask.this.mAlertBuilder.setTitle(SearchTaskResult.get() == null ? 2131099659 : 2131099662);
                    AlertDialog alert = SearchTask.this.mAlertBuilder.create();
                    alert.setButton(-1, (CharSequence)SearchTask.this.mContext.getString(2131099674), null);
                    alert.show();
                }
            }

            @Override
            protected void onCancelled() {
                progressDialog.cancel();
            }

            protected void onProgressUpdate(Integer ... values) {
                progressDialog.setProgress(values[0]);
            }

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                SearchTask.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!progressDialog.isCancelled()) {
                            progressDialog.show();
                            progressDialog.setProgress(startIndex);
                        }
                    }
                }, 200L);
            }
        };
        this.mSearchTask.execute((Void[])new Void[0]);
    }
}

