/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFPageView;

public class MuPDFPageAdapter
extends BaseAdapter {
    private final Context mContext;
    private final MuPDFCore mCore;
    private final SparseArray<PointF> mPageSizes = new SparseArray();

    public MuPDFPageAdapter(Context c, MuPDFCore core) {
        this.mContext = c;
        this.mCore = core;
    }

    public int getCount() {
        return this.mCore.countPages();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        final MuPDFPageView pageView = convertView == null ? new MuPDFPageView(this.mContext, this.mCore, new Point(parent.getWidth(), parent.getHeight())) : (MuPDFPageView)convertView;
        PointF pageSize = (PointF)this.mPageSizes.get(position);
        if (pageSize != null) {
            pageView.setPage(position, pageSize);
        } else {
            pageView.blank(position);
            AsyncTask<Void, Void, PointF> sizingTask = new AsyncTask<Void, Void, PointF>(){

                protected PointF doInBackground(Void ... arg0) {
                    return MuPDFPageAdapter.this.mCore.getPageSize(position);
                }

                @Override
                protected void onPostExecute(PointF result) {
                    super.onPostExecute(result);
                    MuPDFPageAdapter.this.mPageSizes.put(position, (Object)result);
                    if (pageView.getPage() == position) {
                        pageView.setPage(position, result);
                    }
                }
            };
            sizingTask.execute(new Void[]{null});
        }
        return pageView;
    }
}

