package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;

public class LabelDrawer {
	
    private static final int DEFAULT_LABEL_COLOR = 0xFF666666;

    private View mTargetView;
	
	/**标签文本*/
	private String mLabelText;

    private float mLabelTextSize;
	
	private int mLabelTextColor = DEFAULT_LABEL_COLOR;
	
	/**通过{@link View#setPadding(int, int, int, int)}设置的视图左内边距*/
	private int mOriginalPaddingLeft = 0;
	private int mOriginalPaddingTop = 0;
	private int mOriginalPaddingRight = 0;
	private int mOriginalPaddingBottom = 0;
	
	/**通过{@link android.widget.TextView#setText(CharSequence)}设置的文本在计算标签宽度后的左内边距*/
	private int mAdjustPadding = 0;
	
	/**标签水平对齐方式*/
	private boolean isHorizontalAlignRight  = false;
	
	/**标签是否垂直居中对齐*/
	private boolean isLabelAlignVerticalCenter = true;
	
	/**标签占整个控件宽度的权重，以百分比计，如值为30表示占30%，
	 * 默认值为-1，表示自适应标签文本宽度*/
	private int mLabelWeight = 100;
	
	/**标签与内容的间距*/
	private int mLabelMargin = 0;

//    private int mLabelPaddingLeft = 0;
	
	/**是否已经测量标签宽度*/
	boolean hasMeasureLabel;
	
    private int mLabelOrientation;

    private TextDrawer mTextDrawer;

    private boolean mBreakAllow = true;

    private int mMeasureHeight =0;
	
	Context mContext;
	
	public LabelDrawer(){
		init();
	}
	
	public LabelDrawer(Context context){
		mContext = context;
		init();
	}
	
	public LabelDrawer(String label){
		mLabelText = label;
		init();
	}
	
	private void init(){
	}

	public LabelDrawer setLabel(String label){
		mLabelText = label;
        return this;
	}
	
	public String getLabel(){
		return mLabelText;
	}
	
	public LabelDrawer setLabelSize(float size){
		mLabelTextSize = size;
        return this;
	}
	
	public LabelDrawer setLableTextColor(int color){
		mLabelTextColor = color;
        return this;
	}
	
	public int getLableTextColor(){
		return mLabelTextColor;
	}
	
	public LabelDrawer setLabelWeight(int labelWeight) {
		this.mLabelWeight = labelWeight > 50 ? 50 : labelWeight;
        return this;
	}

	@Deprecated
	public LabelDrawer setLabelPaddingLeft(int padding){
        return this;
	}
	
	public LabelDrawer setLabelMarginRight(int margin){
		mLabelMargin = margin;
        return this;
	}
	
	public LabelDrawer setHorizontalAlignRight(boolean isHorizontalAlignRight) {
		this.isHorizontalAlignRight = isHorizontalAlignRight;
        return this;
	}

	public LabelDrawer setLabelAlignVerticalCenter(boolean isLabelAlignVerticalCenter) {
		this.isLabelAlignVerticalCenter = isLabelAlignVerticalCenter;
        return this;
	}

    public LabelDrawer breakAllow(boolean allow){
        mBreakAllow = allow;
        return this;
    }
	
	public int getAdjustedPadding(){
		return mAdjustPadding;
	}
	
	public int getOriginalPaddingLeft(){
		return mOriginalPaddingLeft;
	}

	public int getOriginalPaddingTop(){
		return mOriginalPaddingTop;
	}

	public float getLabelTextSize(){
		return mLabelTextSize;
	}

	public int getLabelHeight(){
        return mTextDrawer.getMeasureHeight();
    }

	public int getLabelOrientation(){
        return mLabelOrientation;
    }

    public int getLabelMargin(){
        return mLabelMargin;
    }

	public int measureLabel(View view, int measureWidth, int measureHeight){
        if(!hasMeasureLabel){
            mTargetView = view;
            mOriginalPaddingLeft = view.getPaddingLeft();
            mOriginalPaddingTop = view.getPaddingTop();
            mOriginalPaddingRight = view.getPaddingRight();
            mOriginalPaddingBottom = view.getPaddingBottom();
            mTextDrawer = new TextDrawer(view.getContext())
                    .text(mLabelText)
                    .textSize(mLabelTextSize)
                    .textColor(mLabelTextColor)
                    .align(isHorizontalAlignRight ? Gravity.RIGHT : Gravity.LEFT)
                    .availableWidth(caculateAvailableWidth(measureWidth));
            if(mBreakAllow){
                mLabelOrientation = LinearLayout.HORIZONTAL;
            }else{
                if(mTextDrawer.isBreaked()){
                    mLabelWeight = 100;
                    mTextDrawer.availableWidth(caculateAvailableWidth(measureWidth));
                    mLabelOrientation = LinearLayout.VERTICAL;
                }else{
                    mLabelOrientation = LinearLayout.HORIZONTAL;
                }
            }
            mTextDrawer.measure();
            resetPadding(view);
            hasMeasureLabel = true;
            if(LinearLayout.HORIZONTAL == mLabelOrientation){
                mMeasureHeight = mTextDrawer.getMeasureHeight() + mOriginalPaddingTop + mOriginalPaddingBottom;
            }else{
                mMeasureHeight = mTextDrawer.getMeasureHeight() + measureHeight;
            }
        }
        return Math.max(measureHeight, mMeasureHeight);
	}
	
    private int caculateAvailableWidth(int measureWidth){
        return measureWidth * mLabelWeight / 100
                - mOriginalPaddingLeft - mOriginalPaddingRight - mLabelMargin;
    }

    /**
     * 根据标签的宽度计算需要设置的内边距，以留出绘制标签的空间
     */
    private void resetPadding(View view){
        if(LinearLayout.HORIZONTAL == mLabelOrientation){
            int p = view.getMeasuredWidth() * mLabelWeight / 100;
            view.setPadding(p,
                    mOriginalPaddingTop,
                    mOriginalPaddingRight,
                    mOriginalPaddingBottom);
            mAdjustPadding = view.getPaddingLeft();
        }else{
            view.setPadding(mOriginalPaddingLeft,
                    mOriginalPaddingTop + mTextDrawer.getMeasureHeight() + mLabelMargin,
                    mOriginalPaddingRight,
                    mOriginalPaddingBottom);
            mAdjustPadding = view.getPaddingTop();
        }

    }

    public void drawLabel(Canvas canvas){
        canvas.save();
        Bitmap textBitmap = mTextDrawer.draw();
        if(textBitmap != null) {
            if (LinearLayout.HORIZONTAL == mLabelOrientation) {
                if (isLabelAlignVerticalCenter) {
                    canvas.translate(mOriginalPaddingLeft, mTargetView.getMeasuredHeight() / 2 - mTextDrawer.getMeasureHeight() / 2);
                    canvas.drawBitmap(textBitmap, 0, 0, null);
                    canvas.restore();
                } else {
                    canvas.drawBitmap(textBitmap, mOriginalPaddingLeft, mOriginalPaddingTop, null);
                }
            } else {
                canvas.drawBitmap(textBitmap, mOriginalPaddingLeft, mOriginalPaddingTop, null);
            }
        }
    }

}
