package com.szboanda.android.platform.dialog;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.LinearLayout.LayoutParams;
import android.widget.TextView;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.DimensionUtils;

/**
 * 2013-4-17
 * @author 杨亚洲 modify by Siyi Lu 12:00 2014-09-02
 */
public class ViewDialog extends BaseDialog{
	
	Button btnConfirm, btnCancel, btnReserve;
	LinearLayout linearBtnsContainer;
	LinearLayout linearRoot, linearContent;
	
	/**
	 * 构造方法
	 * @param context
	 */
	public ViewDialog(Context context) {
		this(context, -1);
	}
	
	/**
	 * 构造方法
	 * @param context
	 * @param widthPercent 宽度点屏幕的百分比，如设置成80，即占屏幕总宽度的80%
	 */
	public ViewDialog(Context context, int widthPercent) {
		super(context);
		//初始化视图
		initView(widthPercent);
	}

	public ViewDialog setTitle(String title) {
		if (!TextUtils.isEmpty(title) && null != titleView) {
			titleView.setText(title);
		}
		return this;
	}
	
	
	/**
	 * 添加用户自定义视图（中间那一块）
	 * @param view
	 * @return
	 */
	public ViewDialog setView(View view) {
		LayoutParams lp = new LayoutParams
				(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		linearContent.addView(view,lp);
		return this;
	}
	
	private void initView(int widthPercent) {
		linearRoot = new LinearLayout(getContext());
		LayoutParams lpRoot = new LayoutParams
				(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		linearRoot.setOrientation(LinearLayout.VERTICAL);
		linearRoot.setGravity(Gravity.CENTER_HORIZONTAL);
		linearRoot.setLayoutParams(lpRoot);
		linearRoot.setBackgroundResource(R.drawable.viewjar_dialog_light_gray_frame);
		//添加标题视图
		addTitleView();
		//添加显示内容容器
		addContentViewContainer();
		//添加询问按钮
		addBottomBlock();
		//在设置窗口尺寸之前定义好窗口宽度
		int width;
		if(widthPercent != -1){
			width = DimensionUtils.getScreenWidth(getContext(), widthPercent);
		}else{
			width = DimensionUtils.getScreenWidth(getContext()) - 50;
		}
		LayoutParams lp = new LayoutParams(width, LayoutParams.WRAP_CONTENT);
		super.setContentView(linearRoot, lp);
	}
	
	/**添加标题*/
	private void addTitleView(){
		titleView = new TextView(getContext());
		titleView.setText("请输入查询信息");
		titleView.setGravity(Gravity.CENTER_VERTICAL);
		titleView.setBackgroundResource(R.drawable.viewjar_dialog_title_light_gray_bg);
		
		titleView.setTextSize(20);
		titleView.setTextColor(Color.parseColor("#666666"));
		titleView.setShadowLayer(1, 1, 1, Color.parseColor("#999999"));
		linearRoot.addView(titleView);
	}
	
	private void addContentViewContainer(){
		linearContent = new LinearLayout(getContext());
		linearContent.setOrientation(LinearLayout.VERTICAL);
		LayoutParams lpContent = new LayoutParams
				(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		linearContent.setBackgroundColor(Color.parseColor("#EBEBEB"));
		linearContent.setGravity(Gravity.CENTER_VERTICAL);
		linearContent.setLayoutParams(lpContent);
		linearRoot.addView(linearContent);
	}
	
	/**添加底部模块*/
	private void addBottomBlock(){
		linearBtnsContainer = new LinearLayout(getContext());
		linearBtnsContainer.setOrientation(LinearLayout.HORIZONTAL);
		LayoutParams lpBtnContainer = new LayoutParams
				(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		linearBtnsContainer.setLayoutParams(lpBtnContainer);
		linearBtnsContainer.setBackgroundResource(R.drawable.viewjar_dialog_bottom_light_gray_bg);
		int lrPadding = DimensionUtils.dip2Px(getContext(), 10);
		int tbPadding = DimensionUtils.dip2Px(getContext(), 8);
		linearBtnsContainer.setPadding(lrPadding, tbPadding, lrPadding, tbPadding);
		linearBtnsContainer.setVisibility(View.GONE);
		linearRoot.addView(linearBtnsContainer);
		
		btnConfirm = new Button(getContext());
		btnConfirm.setText("确定");
		btnConfirm.setTextSize(18);
		btnConfirm.setTextColor(Color.WHITE);
		btnConfirm.setBackgroundResource(R.drawable.viewjar_selector_sky_blue_btn);
		LayoutParams lpConfirm = new LayoutParams
				(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		lpConfirm.weight = 1;
		int margin = DimensionUtils.dip2Px(getContext(), 5);
		lpConfirm.leftMargin = margin;
		lpConfirm.rightMargin = margin;
		btnConfirm.setLayoutParams(lpConfirm);
		btnConfirm.setVisibility(View.GONE);
		linearBtnsContainer.addView(btnConfirm);
		
		btnReserve = new Button(getContext());
		btnReserve.setText("备用");
		btnReserve.setTextSize(18);
		btnReserve.setTextColor(Color.parseColor("#666666"));
		btnReserve.setBackgroundResource(R.drawable.viewjar_selector_light_gray_btn);
		LayoutParams lpReserve = new LayoutParams
				(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		lpReserve.weight = 1;
		lpReserve.leftMargin = margin;
		lpReserve.rightMargin = margin;
		btnReserve.setLayoutParams(lpReserve);
		btnReserve.setVisibility(View.GONE);
		linearBtnsContainer.addView(btnReserve);
		
		btnCancel = new Button(getContext());
		btnCancel.setText("取消");
		btnCancel.setTextSize(18);
		btnCancel.setTextColor(Color.parseColor("#666666"));
		btnCancel.setBackgroundResource(R.drawable.viewjar_selector_light_gray_btn);
		LayoutParams lpCancle = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
		lpCancle.weight = 1;
		lpCancle.leftMargin = margin;
		lpCancle.rightMargin = margin;
		btnCancel.setLayoutParams(lpCancle);
		btnCancel.setVisibility(View.GONE);
		linearBtnsContainer.addView(btnCancel);
	}
	
	public void setPadding(int padding){
		linearContent.setPadding(padding, padding, padding, padding);
	}
	
	public void setPaddingBottom(int p){
		linearContent.setPadding(linearContent.getPaddingLeft(), 
				linearContent.getPaddingTop(), linearContent.getPaddingRight(), p);
	}
	
	public void setViewBg(int res) {
		linearContent.setBackgroundResource(res);
	}
	
	public LinearLayout getViewParent(){
		return linearContent;
	}
	
	/**
	 * 设置标题栏背景
	 * @param res
	 */
	public void setTitleBackground(int res) {
		try {
			if (titleView != null) {
				titleView.setBackgroundResource(res);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void setPositiveBtnText(CharSequence text){
		if(btnConfirm != null && !TextUtils.isEmpty(text)){
			btnConfirm.setText(text);
		}
	}
	
	public void setNegativeBtnText(CharSequence text){
		if(btnCancel != null && !TextUtils.isEmpty(text)){
			btnCancel.setText(text);
		}
	}

	public ViewDialog setPositiveButton(CharSequence text, OnDialogButtonClickListener listener) {
		linearBtnsContainer.setVisibility(View.VISIBLE);
		btnConfirm.setVisibility(View.VISIBLE);
		btnConfirm.setTag(listener);
		btnConfirm.setOnClickListener(mListener);
		btnConfirm.setText(text);
		return this;
	}

	public ViewDialog setNegativeButton(CharSequence text, OnDialogButtonClickListener listener) {
		linearBtnsContainer.setVisibility(View.VISIBLE);
		btnCancel.setVisibility(View.VISIBLE);
		btnCancel.setTag(listener);
		btnCancel.setOnClickListener(mListener);
		btnCancel.setText(text);
		return this;
	}


	public ViewDialog setNeutralButton(CharSequence text, OnDialogButtonClickListener listener) {
		linearBtnsContainer.setVisibility(View.VISIBLE);
		btnReserve.setText(text);
		btnReserve.setVisibility(View.VISIBLE);
		btnReserve.setTag(listener);
		btnReserve.setOnClickListener(mListener);
		return this;
	}


	@Override
	public void setContentView(int layoutResID) {
		View view = inflater.inflate(layoutResID, null);
		this.setContentView(view);
	}
	
	public ViewDialog setTitleInId(int textResID) {
		String text = context.getResources().getString(textResID);
		setTitle(text);
		return this;
	}
	
	public ViewDialog setView(int layoutResID) {
		setContentView(layoutResID);
		return this;
	}
	
	public ViewDialog setPositiveButton(int textId, OnDialogButtonClickListener listener) {
		String text = context.getResources().getString(textId);
		setPositiveButton(text, listener);
		return this;
	}
	
	public ViewDialog setNegativeButton(int textId, OnDialogButtonClickListener listener) {
		String text = context.getResources().getString(textId);
		setNegativeButton(text, listener);
		return this;
	}
	
	public ViewDialog setNeutralButton(int textId, OnDialogButtonClickListener listener) {
		String text = context.getResources().getString(textId);
		setNeutralButton(text, listener);
		return this;
	}
}
