package com.szboanda.android.platform.dialog;

import org.json.JSONObject;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.view.BindableRadioButton;
import com.szboanda.android.platform.view.CustomViewBinder;

import android.app.Dialog;
import android.app.DialogFragment;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.LinearLayout.LayoutParams;
import android.widget.ListView;
import android.widget.RadioGroup;

/**
 * <p>Description: 通用选择项对话框。</p>
 * <p>选择逻辑使用列表的点击事件处理，已屏蔽R.layout.list_item_select_factor中的CheckBox的点击事件</p>
 * @author    Siyi Lu    Create Date: 2014-12-12
 */
public class UniversalSelectItemDialog extends DialogFragment{
	
	/**因子展示列表控件*/
	private ListView mListView;
	/**关键字输入框*/
	private EditText editQueryKeyWord;
	/**列表的适配器*/
	private SelectItemAdapter<?> mListAdapter = null;
	/**是否单选*/
	private boolean isSingleCheck = false;
	/**视图解析器*/
	private CustomViewBinder mBinder;
	/**多选时的分割符*/
	private String splitSign = ";";
	/**因子类别缓存,便于对话框重新打开时加载*/
	private JSONObject categoryCache = null;
	
	private String dialogTitle;
	
	private String positiveBtnText = "确定";
	
	private String negativeBtnText = "取消";
	
	private String mKeywordHint = null;
	
	public void setTitle(String title){
		dialogTitle = title;
	}
	
	@Override
	public Dialog onCreateDialog(Bundle savedInstanceState) {
		ViewDialog dialog = new ViewDialog(getActivity());
		LayoutInflater inflater = LayoutInflater.from(getActivity());
		View inflatetView = inflater.inflate(R.layout.platform_premium_select_dialog, null);
		initViews(inflatetView);
		if(!mListAdapter.isSingleCheck()){
			dialog.setPositiveButton(positiveBtnText, positiveListener);
			dialog.setNegativeButton(negativeBtnText, negativeListener);
		}
		//因为是片断里的原因，需要指定解析的根视图
		mBinder = new CustomViewBinder(inflatetView);
		//避免每次打开窗口重新刷新数据，添加适配重用逻辑
		mListView.setAdapter(mListAdapter);
		if(categoryCache != null){
			mBinder.recursiveBindData(categoryCache, true);
		}
		dialog.setTitle(dialogTitle);
		dialog.setView(inflatetView);
		return dialog;
	}
	
	@Override
	public void onDestroyView() {
		//在对话框消失时，总是会调用该方法，此时应缓存界面内容
		categoryCache = new JSONObject();
		mBinder.recursiveFetchJson(categoryCache);
		super.onDestroyView();
	}
	
	/**
	 * 初始化视图、控件
	 * @param parent
	 */
	void initViews(View parent){
		
		RadioGroup radioGroup = (RadioGroup)parent.findViewById(R.id.category_select_group);
		initSelectRadios(radioGroup);
		//选择项分组只有一组时，分组选择按钮不显示
		if(mListAdapter.getGroupTitles().length == 1){
			radioGroup.setVisibility(View.GONE);
		}
//		radioGroup.setOnCheckedChangeListener(categoryChangeListener);
		
		mListView = (ListView)parent.findViewById(R.id.factor_list_view);
		mListView.setOnItemClickListener(itemClickListener);
		mListView.setAdapter(mListAdapter);
		//同步按钮设置监听器
		editQueryKeyWord = (EditText)parent.findViewById(R.id.key_word_input);
		editQueryKeyWord.addTextChangedListener(keyWordChangeWatcher);
		if(!TextUtils.isEmpty(mKeywordHint)){
			editQueryKeyWord.setHint(mKeywordHint);
		}
		if(mListAdapter.getCount() < 10){
			editQueryKeyWord.setVisibility(View.GONE);
		}else{
			editQueryKeyWord.setVisibility(View.VISIBLE);
		}
	}
	
	void initSelectRadios(RadioGroup parent){
		int index = 0;
		for(String title:mListAdapter.getGroupTitles()){
			BindableRadioButton radioBtn = new BindableRadioButton(getActivity());
			radioBtn.setText(title);
			radioBtn.setId(index+1);
			radioBtn.setField("TYPE_" + index);
			radioBtn.setFieldValue("1");
			LayoutParams lp = new LayoutParams(LayoutParams.WRAP_CONTENT,LayoutParams.WRAP_CONTENT);
			if(index == 0){
				radioBtn.setChecked(true);
			}else{
				lp.rightMargin = DimensionUtils.dip2Px(getActivity(), 5);
			}
			radioBtn.setLayoutParams(lp);
			radioBtn.setOnCheckedChangeListener(typeChangeListener);
			radioBtn.setOnClickListener(typeClickListener);
			parent.addView(radioBtn, index);
			index++;
		}
	}
	
	public boolean isSingleCheck() {
		return isSingleCheck;
	}

	public void setSingleCheck(boolean isSingleCheck) {
		this.isSingleCheck = isSingleCheck;
	}

	public String getSplitSign() {
		return splitSign;
	}

	public void setSplitSign(String splitSign) {
		this.splitSign = splitSign;
	}
	
	public void setAdapter(SelectItemAdapter<?> adapter){
		mListAdapter = adapter;
	}
	
	public void setPositiveText(String positiveText){
		this.positiveBtnText = positiveText;
	}
	
	public void setNegativeText(String negativeText){
		this.negativeBtnText = negativeText;
	}
	
	public void setKeywordHint(String hint){
		this.mKeywordHint = hint;
	}
	
	public SelectItemAdapter<?> getAdapter(){
		return mListAdapter;
	}
	
	boolean hasCheckChangeOccur = false;
	OnCheckedChangeListener typeChangeListener = new OnCheckedChangeListener() {
		@Override
		public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
			hasCheckChangeOccur = true;
		}
	};
	
	OnClickListener typeClickListener = new View.OnClickListener() {
		@Override
		public void onClick(View v) {
			if(hasCheckChangeOccur){
				//默认使用组选择按钮的ID做索引切换分组的数据
				mListAdapter.onGroupSelectChange(v.getId()-1);
				hasCheckChangeOccur = false;
			}
		}
	};
	
	/**
	 * 列表点击监听器
	 */
	OnItemClickListener itemClickListener = new OnItemClickListener() {
		@Override
		public void onItemClick(AdapterView<?> arg0, View arg1, int position, long id) {
			//单选的情况下直接返回数据
			if(mListAdapter.isSingleCheck()){
				UniversalSelectItemDialog.this.dismiss();
				mListAdapter.onSingleItemCheck(position);
			}else{		//多选则选中
				mListAdapter.onMultiItemCheck(position);
			}
		}
	};
	
	BaseDialog.OnDialogButtonClickListener positiveListener = new BaseDialog.OnDialogButtonClickListener() {
		@Override
		public void onClick(Dialog dialog, View v) {
			mListAdapter.onPositiveBtnClick();
		}
	};
	
	BaseDialog.OnDialogButtonClickListener negativeListener = new BaseDialog.OnDialogButtonClickListener() {
		@Override
		public void onClick(Dialog dialog, View v) {
			mListAdapter.onPositiveBtnClick();
		}
	};
	
	Runnable refreshFilteTask = new Runnable() {
		@Override
		public void run() {
			String keyWord = editQueryKeyWord.getText().toString();
			mListAdapter.filteWithKeyword(keyWord);
		}
	};
	
	Handler mFilterHandler = new Handler();
	TextWatcher keyWordChangeWatcher = new TextWatcher() {
		@Override
		public void onTextChanged(CharSequence s, int start, int before, int count) {	
			mFilterHandler.postDelayed(refreshFilteTask, 100);
		}
		@Override
		public void beforeTextChanged(CharSequence s, int start, int count,int after) {}
		@Override
		public void afterTextChanged(Editable s) {
			
		}
	};
	
	public void show(android.app.FragmentManager manager, String tag) {
		super.show(manager, tag);
	};
	
}


