/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Scroller;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class ReaderView
extends AdapterView<Adapter>
implements GestureDetector.OnGestureListener,
ScaleGestureDetector.OnScaleGestureListener,
Runnable {
    private static final int MOVING_DIAGONALLY = 0;
    private static final int MOVING_LEFT = 1;
    private static final int MOVING_RIGHT = 2;
    private static final int MOVING_UP = 3;
    private static final int MOVING_DOWN = 4;
    private static final int FLING_MARGIN = 100;
    private static final int GAP = 20;
    private static final float MIN_SCALE = 1.0f;
    private static final float MAX_SCALE = 5.0f;
    private static final float REFLOW_SCALE_FACTOR = 0.5f;
    private Adapter mAdapter;
    private int mCurrent;
    private boolean mResetLayout;
    private final SparseArray<View> mChildViews = new SparseArray(3);
    private final LinkedList<View> mViewCache = new LinkedList();
    private boolean mUserInteracting;
    private boolean mScaling;
    private float mScale = 1.0f;
    private int mXScroll;
    private int mYScroll;
    private boolean mReflow = false;
    private final GestureDetector mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)this);
    private final ScaleGestureDetector mScaleGestureDetector;
    private final Scroller mScroller;
    private int mScrollerLastX;
    private int mScrollerLastY;
    private boolean mScrollDisabled;

    public ReaderView(Context context) {
        super(context);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mScroller = new Scroller(context);
    }

    public ReaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mScroller = new Scroller(context);
    }

    public ReaderView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mScroller = new Scroller(context);
    }

    public int getDisplayedViewIndex() {
        return this.mCurrent;
    }

    public void setDisplayedViewIndex(int i) {
        if (i >= 0 && i < this.mAdapter.getCount()) {
            this.onMoveOffChild(this.mCurrent);
            this.mCurrent = i;
            this.onMoveToChild(i);
            this.mResetLayout = true;
            this.requestLayout();
        }
    }

    public void moveToNext() {
        View v = (View)this.mChildViews.get(this.mCurrent + 1);
        if (v != null) {
            this.slideViewOntoScreen(v);
        }
    }

    public void moveToPrevious() {
        View v = (View)this.mChildViews.get(this.mCurrent - 1);
        if (v != null) {
            this.slideViewOntoScreen(v);
        }
    }

    private int smartAdvanceAmount(int screenHeight, int max) {
        int advance = (int)((double)screenHeight * 0.9 + 0.5);
        int leftOver = max % advance;
        int steps = max / advance;
        if (leftOver != 0) {
            if ((double)((float)leftOver / (float)steps) <= (double)screenHeight * 0.05) {
                advance += (int)((double)((float)leftOver / (float)steps) + 0.5);
            } else {
                int overshoot = advance - leftOver;
                if ((double)((float)overshoot / (float)steps) <= (double)screenHeight * 0.1) {
                    advance -= (int)((double)((float)overshoot / (float)steps) + 0.5);
                }
            }
        }
        if (advance > max) {
            advance = max;
        }
        return advance;
    }

    public void smartMoveForwards() {
        int xOffset;
        int yOffset;
        View v = (View)this.mChildViews.get(this.mCurrent);
        if (v == null) {
            return;
        }
        int screenWidth = this.getWidth();
        int screenHeight = this.getHeight();
        int remainingX = this.mScroller.getFinalX() - this.mScroller.getCurrX();
        int remainingY = this.mScroller.getFinalY() - this.mScroller.getCurrY();
        int top = -(v.getTop() + this.mYScroll + remainingY);
        int right = screenWidth - (v.getLeft() + this.mXScroll + remainingX);
        int bottom = screenHeight + top;
        int docWidth = v.getMeasuredWidth();
        int docHeight = v.getMeasuredHeight();
        if (bottom >= docHeight) {
            if (right + screenWidth > docWidth) {
                View nv = (View)this.mChildViews.get(this.mCurrent + 1);
                if (nv == null) {
                    return;
                }
                int nextTop = -(nv.getTop() + this.mYScroll + remainingY);
                int nextLeft = -(nv.getLeft() + this.mXScroll + remainingX);
                int nextDocWidth = nv.getMeasuredWidth();
                int nextDocHeight = nv.getMeasuredHeight();
                int n = yOffset = nextDocHeight < screenHeight ? nextDocHeight - screenHeight >> 1 : 0;
                if (nextDocWidth < screenWidth) {
                    xOffset = nextDocWidth - screenWidth >> 1;
                } else {
                    xOffset = right % screenWidth;
                    if (xOffset + screenWidth > nextDocWidth) {
                        xOffset = nextDocWidth - screenWidth;
                    }
                }
                xOffset -= nextLeft;
                yOffset -= nextTop;
            } else {
                xOffset = screenWidth;
                yOffset = screenHeight - bottom;
            }
        } else {
            xOffset = 0;
            yOffset = this.smartAdvanceAmount(screenHeight, docHeight - bottom);
        }
        this.mScrollerLastY = 0;
        this.mScrollerLastX = 0;
        this.mScroller.startScroll(0, 0, remainingX - xOffset, remainingY - yOffset, 400);
        this.post(this);
    }

    public void smartMoveBackwards() {
        int xOffset;
        int yOffset;
        View v = (View)this.mChildViews.get(this.mCurrent);
        if (v == null) {
            return;
        }
        int screenWidth = this.getWidth();
        int screenHeight = this.getHeight();
        int remainingX = this.mScroller.getFinalX() - this.mScroller.getCurrX();
        int remainingY = this.mScroller.getFinalY() - this.mScroller.getCurrY();
        int left = -(v.getLeft() + this.mXScroll + remainingX);
        int top = -(v.getTop() + this.mYScroll + remainingY);
        int docHeight = v.getMeasuredHeight();
        if (top <= 0) {
            if (left < screenWidth) {
                View pv = (View)this.mChildViews.get(this.mCurrent - 1);
                if (pv == null) {
                    return;
                }
                int prevDocWidth = pv.getMeasuredWidth();
                int prevDocHeight = pv.getMeasuredHeight();
                yOffset = prevDocHeight < screenHeight ? prevDocHeight - screenHeight >> 1 : 0;
                int prevLeft = -(pv.getLeft() + this.mXScroll);
                int prevTop = -(pv.getTop() + this.mYScroll);
                if (prevDocWidth < screenWidth) {
                    xOffset = prevDocWidth - screenWidth >> 1;
                } else {
                    int n = xOffset = left > 0 ? left % screenWidth : 0;
                    if (xOffset + screenWidth > prevDocWidth) {
                        xOffset = prevDocWidth - screenWidth;
                    }
                    while (xOffset + screenWidth * 2 < prevDocWidth) {
                        xOffset += screenWidth;
                    }
                }
                xOffset -= prevLeft;
                yOffset -= prevTop - prevDocHeight + screenHeight;
            } else {
                xOffset = -screenWidth;
                yOffset = docHeight - screenHeight + top;
            }
        } else {
            xOffset = 0;
            yOffset = -this.smartAdvanceAmount(screenHeight, top);
        }
        this.mScrollerLastY = 0;
        this.mScrollerLastX = 0;
        this.mScroller.startScroll(0, 0, remainingX - xOffset, remainingY - yOffset, 400);
        this.post(this);
    }

    public void resetupChildren() {
        int i = 0;
        while (i < this.mChildViews.size()) {
            this.onChildSetup(this.mChildViews.keyAt(i), (View)this.mChildViews.valueAt(i));
            ++i;
        }
    }

    public void applyToChildren(ViewMapper mapper) {
        int i = 0;
        while (i < this.mChildViews.size()) {
            mapper.applyToView((View)this.mChildViews.valueAt(i));
            ++i;
        }
    }

    public void refresh(boolean reflow) {
        this.mReflow = reflow;
        this.mScale = 1.0f;
        this.mYScroll = 0;
        this.mXScroll = 0;
        int numChildren = this.mChildViews.size();
        int i = 0;
        while (i < numChildren) {
            View v = (View)this.mChildViews.valueAt(i);
            this.onNotInUse(v);
            this.removeViewInLayout(v);
            ++i;
        }
        this.mChildViews.clear();
        this.mViewCache.clear();
        this.requestLayout();
    }

    protected void onChildSetup(int i, View v) {
    }

    protected void onMoveToChild(int i) {
    }

    protected void onMoveOffChild(int i) {
    }

    protected void onSettle(View v) {
    }

    protected void onUnsettle(View v) {
    }

    protected void onNotInUse(View v) {
    }

    protected void onScaleChild(View v, Float scale) {
    }

    public View getView(int i) {
        return (View)this.mChildViews.get(i);
    }

    public View getDisplayedView() {
        return (View)this.mChildViews.get(this.mCurrent);
    }

    @Override
    public void run() {
        View v;
        if (!this.mScroller.isFinished()) {
            this.mScroller.computeScrollOffset();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            this.mXScroll += x - this.mScrollerLastX;
            this.mYScroll += y - this.mScrollerLastY;
            this.mScrollerLastX = x;
            this.mScrollerLastY = y;
            this.requestLayout();
            this.post(this);
        } else if (!this.mUserInteracting && (v = (View)this.mChildViews.get(this.mCurrent)) != null) {
            this.postSettle(v);
        }
    }

    public boolean onDown(MotionEvent arg0) {
        this.mScroller.forceFinished(true);
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mScrollDisabled) {
            return true;
        }
        View v = (View)this.mChildViews.get(this.mCurrent);
        if (v != null) {
            Rect bounds = this.getScrollBounds(v);
            switch (ReaderView.directionOfTravel(velocityX, velocityY)) {
                case 1: {
                    View vl;
                    if (bounds.left < 0 || (vl = (View)this.mChildViews.get(this.mCurrent + 1)) == null) break;
                    this.slideViewOntoScreen(vl);
                    return true;
                }
                case 2: {
                    View vr;
                    if (bounds.right > 0 || (vr = (View)this.mChildViews.get(this.mCurrent - 1)) == null) break;
                    this.slideViewOntoScreen(vr);
                    return true;
                }
            }
            this.mScrollerLastY = 0;
            this.mScrollerLastX = 0;
            Rect expandedBounds = new Rect(bounds);
            expandedBounds.inset(-100, -100);
            if (ReaderView.withinBoundsInDirectionOfTravel(bounds, velocityX, velocityY) && expandedBounds.contains(0, 0)) {
                this.mScroller.fling(0, 0, (int)velocityX, (int)velocityY, bounds.left, bounds.right, bounds.top, bounds.bottom);
                this.post(this);
            }
        }
        return true;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.mScrollDisabled) {
            this.mXScroll = (int)((float)this.mXScroll - distanceX);
            this.mYScroll = (int)((float)this.mYScroll - distanceY);
            this.requestLayout();
        }
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float previousScale = this.mScale;
        float scale_factor = this.mReflow ? 0.5f : 1.0f;
        float min_scale = 1.0f * scale_factor;
        float max_scale = 5.0f * scale_factor;
        this.mScale = Math.min(Math.max(this.mScale * detector.getScaleFactor(), min_scale), max_scale);
        if (this.mReflow) {
            this.applyToChildren(new ViewMapper(){

                @Override
                void applyToView(View view) {
                    ReaderView.this.onScaleChild(view, Float.valueOf(ReaderView.this.mScale));
                }
            });
        } else {
            float factor = this.mScale / previousScale;
            View v = (View)this.mChildViews.get(this.mCurrent);
            if (v != null) {
                int viewFocusX = (int)detector.getFocusX() - (v.getLeft() + this.mXScroll);
                int viewFocusY = (int)detector.getFocusY() - (v.getTop() + this.mYScroll);
                this.mXScroll = (int)((float)this.mXScroll + ((float)viewFocusX - (float)viewFocusX * factor));
                this.mYScroll = (int)((float)this.mYScroll + ((float)viewFocusY - (float)viewFocusY * factor));
                this.requestLayout();
            }
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.mScaling = true;
        this.mYScroll = 0;
        this.mXScroll = 0;
        this.mScrollDisabled = true;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.mScaling = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mScaleGestureDetector.onTouchEvent(event);
        if (!this.mScaling) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if ((event.getAction() & 0xFF) == 0) {
            this.mUserInteracting = true;
        }
        if ((event.getAction() & 0xFF) == 1) {
            this.mScrollDisabled = false;
            this.mUserInteracting = false;
            View v = (View)this.mChildViews.get(this.mCurrent);
            if (v != null) {
                if (this.mScroller.isFinished()) {
                    this.slideViewOntoScreen(v);
                }
                if (this.mScroller.isFinished()) {
                    this.postSettle(v);
                }
            }
        }
        this.requestLayout();
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int n = this.getChildCount();
        int i = 0;
        while (i < n) {
            this.measureView(this.getChildAt(i));
            ++i;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int gap;
        Point corr;
        int cvTop;
        int cvLeft;
        int numChildren;
        Point cvOffset;
        super.onLayout(changed, left, top, right, bottom);
        View cv = (View)this.mChildViews.get(this.mCurrent);
        if (!this.mResetLayout) {
            if (cv != null) {
                cvOffset = this.subScreenSizeOffset(cv);
                if (cv.getLeft() + cv.getMeasuredWidth() + cvOffset.x + 10 + this.mXScroll < this.getWidth() / 2 && this.mCurrent + 1 < this.mAdapter.getCount()) {
                    this.postUnsettle(cv);
                    this.post(this);
                    this.onMoveOffChild(this.mCurrent);
                    ++this.mCurrent;
                    this.onMoveToChild(this.mCurrent);
                }
                if (cv.getLeft() - cvOffset.x - 10 + this.mXScroll >= this.getWidth() / 2 && this.mCurrent > 0) {
                    this.postUnsettle(cv);
                    this.post(this);
                    this.onMoveOffChild(this.mCurrent);
                    --this.mCurrent;
                    this.onMoveToChild(this.mCurrent);
                }
            }
            numChildren = this.mChildViews.size();
            int[] childIndices = new int[numChildren];
            int i = 0;
            while (i < numChildren) {
                childIndices[i] = this.mChildViews.keyAt(i);
                ++i;
            }
            i = 0;
            while (i < numChildren) {
                int ai = childIndices[i];
                if (ai < this.mCurrent - 1 || ai > this.mCurrent + 1) {
                    View v = (View)this.mChildViews.get(ai);
                    this.onNotInUse(v);
                    this.mViewCache.add(v);
                    this.removeViewInLayout(v);
                    this.mChildViews.remove(ai);
                }
                ++i;
            }
        } else {
            this.mResetLayout = false;
            this.mYScroll = 0;
            this.mXScroll = 0;
            numChildren = this.mChildViews.size();
            int i = 0;
            while (i < numChildren) {
                View v = (View)this.mChildViews.valueAt(i);
                this.onNotInUse(v);
                this.mViewCache.add(v);
                this.removeViewInLayout(v);
                ++i;
            }
            this.mChildViews.clear();
            this.post(this);
        }
        boolean notPresent = this.mChildViews.get(this.mCurrent) == null;
        cv = this.getOrCreateChild(this.mCurrent);
        cvOffset = this.subScreenSizeOffset(cv);
        if (notPresent) {
            cvLeft = cvOffset.x;
            cvTop = cvOffset.y;
        } else {
            cvLeft = cv.getLeft() + this.mXScroll;
            cvTop = cv.getTop() + this.mYScroll;
        }
        this.mYScroll = 0;
        this.mXScroll = 0;
        int cvRight = cvLeft + cv.getMeasuredWidth();
        int cvBottom = cvTop + cv.getMeasuredHeight();
        if (!this.mUserInteracting && this.mScroller.isFinished()) {
            corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
            cvRight += corr.x;
            cvLeft += corr.x;
            cvTop += corr.y;
            cvBottom += corr.y;
        } else if (cv.getMeasuredHeight() <= this.getHeight()) {
            corr = this.getCorrection(this.getScrollBounds(cvLeft, cvTop, cvRight, cvBottom));
            cvTop += corr.y;
            cvBottom += corr.y;
        }
        cv.layout(cvLeft, cvTop, cvRight, cvBottom);
        if (this.mCurrent > 0) {
            View lv = this.getOrCreateChild(this.mCurrent - 1);
            Point leftOffset = this.subScreenSizeOffset(lv);
            gap = leftOffset.x + 20 + cvOffset.x;
            lv.layout(cvLeft - lv.getMeasuredWidth() - gap, (cvBottom + cvTop - lv.getMeasuredHeight()) / 2, cvLeft - gap, (cvBottom + cvTop + lv.getMeasuredHeight()) / 2);
        }
        if (this.mCurrent + 1 < this.mAdapter.getCount()) {
            View rv = this.getOrCreateChild(this.mCurrent + 1);
            Point rightOffset = this.subScreenSizeOffset(rv);
            gap = cvOffset.x + 20 + rightOffset.x;
            rv.layout(cvRight + gap, (cvBottom + cvTop - rv.getMeasuredHeight()) / 2, cvRight + rv.getMeasuredWidth() + gap, (cvBottom + cvTop + rv.getMeasuredHeight()) / 2);
        }
        this.invalidate();
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    public View getSelectedView() {
        throw new UnsupportedOperationException(this.getContext().getString(2131099694));
    }

    public void setAdapter(Adapter adapter) {
        this.mAdapter = adapter;
        this.mChildViews.clear();
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public void setSelection(int arg0) {
        throw new UnsupportedOperationException(this.getContext().getString(2131099694));
    }

    private View getCached() {
        if (this.mViewCache.size() == 0) {
            return null;
        }
        return this.mViewCache.removeFirst();
    }

    private View getOrCreateChild(int i) {
        View v = (View)this.mChildViews.get(i);
        if (v == null) {
            v = this.mAdapter.getView(i, this.getCached(), (ViewGroup)this);
            this.addAndMeasureChild(i, v);
            this.onChildSetup(i, v);
            this.onScaleChild(v, Float.valueOf(this.mScale));
        }
        return v;
    }

    private void addAndMeasureChild(int i, View v) {
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-2, -2);
        }
        this.addViewInLayout(v, 0, params, true);
        this.mChildViews.append(i, (Object)v);
        this.measureView(v);
    }

    private void measureView(View v) {
        v.measure(0, 0);
        if (!this.mReflow) {
            float scale = Math.min((float)this.getWidth() / (float)v.getMeasuredWidth(), (float)this.getHeight() / (float)v.getMeasuredHeight());
            v.measure(0x40000000 | (int)((float)v.getMeasuredWidth() * scale * this.mScale), 0x40000000 | (int)((float)v.getMeasuredHeight() * scale * this.mScale));
        } else {
            v.measure(0x40000000 | v.getMeasuredWidth(), 0x40000000 | v.getMeasuredHeight());
        }
    }

    private Rect getScrollBounds(int left, int top, int right, int bottom) {
        int xmin = this.getWidth() - right;
        int xmax = -left;
        int ymin = this.getHeight() - bottom;
        int ymax = -top;
        if (xmin > xmax) {
            xmin = xmax = (xmin + xmax) / 2;
        }
        if (ymin > ymax) {
            ymin = ymax = (ymin + ymax) / 2;
        }
        return new Rect(xmin, ymin, xmax, ymax);
    }

    private Rect getScrollBounds(View v) {
        return this.getScrollBounds(v.getLeft() + this.mXScroll, v.getTop() + this.mYScroll, v.getLeft() + v.getMeasuredWidth() + this.mXScroll, v.getTop() + v.getMeasuredHeight() + this.mYScroll);
    }

    private Point getCorrection(Rect bounds) {
        return new Point(Math.min(Math.max(0, bounds.left), bounds.right), Math.min(Math.max(0, bounds.top), bounds.bottom));
    }

    private void postSettle(final View v) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReaderView.this.onSettle(v);
            }
        });
    }

    private void postUnsettle(final View v) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReaderView.this.onUnsettle(v);
            }
        });
    }

    private void slideViewOntoScreen(View v) {
        Point corr = this.getCorrection(this.getScrollBounds(v));
        if (corr.x != 0 || corr.y != 0) {
            this.mScrollerLastY = 0;
            this.mScrollerLastX = 0;
            this.mScroller.startScroll(0, 0, corr.x, corr.y, 400);
            this.post(this);
        }
    }

    private Point subScreenSizeOffset(View v) {
        return new Point(Math.max((this.getWidth() - v.getMeasuredWidth()) / 2, 0), Math.max((this.getHeight() - v.getMeasuredHeight()) / 2, 0));
    }

    private static int directionOfTravel(float vx, float vy) {
        if (Math.abs(vx) > 2.0f * Math.abs(vy)) {
            return vx > 0.0f ? 2 : 1;
        }
        if (Math.abs(vy) > 2.0f * Math.abs(vx)) {
            return vy > 0.0f ? 4 : 3;
        }
        return 0;
    }

    private static boolean withinBoundsInDirectionOfTravel(Rect bounds, float vx, float vy) {
        switch (ReaderView.directionOfTravel(vx, vy)) {
            case 0: {
                return bounds.contains(0, 0);
            }
            case 1: {
                return bounds.left <= 0;
            }
            case 2: {
                return bounds.right >= 0;
            }
            case 3: {
                return bounds.top <= 0;
            }
            case 4: {
                return bounds.bottom >= 0;
            }
        }
        throw new NoSuchElementException();
    }

    static abstract class ViewMapper {
        ViewMapper() {
        }

        abstract void applyToView(View var1);
    }
}

