/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.BitmapHolder;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.MuPDFAlert;
import com.artifex.mupdfdemo.MuPDFAlertInternal;
import com.artifex.mupdfdemo.OutlineItem;
import com.artifex.mupdfdemo.PassClickResult;
import com.artifex.mupdfdemo.PassClickResultChoice;
import com.artifex.mupdfdemo.PassClickResultText;
import com.artifex.mupdfdemo.TextChar;
import com.artifex.mupdfdemo.TextWord;
import com.artifex.mupdfdemo.WidgetType;
import java.util.ArrayList;

public class MuPDFCore {
    private int numPages = -1;
    private float pageWidth;
    private float pageHeight;
    private long globals;
    private byte[] fileBuffer;
    private String file_format;

    static {
        System.loadLibrary("mupdf");
    }

    private native long openFile(String var1);

    private native long openBuffer();

    private native String fileFormatInternal();

    private native int countPagesInternal();

    private native void gotoPageInternal(int var1);

    private native float getPageWidth();

    private native float getPageHeight();

    private native void drawPage(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void updatePageInternal(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private native RectF[] searchPage(String var1);

    private native TextChar[][][][] text();

    private native byte[] textAsHtml();

    private native void addMarkupAnnotationInternal(PointF[] var1, int var2);

    private native void addInkAnnotationInternal(PointF[][] var1);

    private native void deleteAnnotationInternal(int var1);

    private native int passClickEventInternal(int var1, float var2, float var3);

    private native void setFocusedWidgetChoiceSelectedInternal(String[] var1);

    private native String[] getFocusedWidgetChoiceSelected();

    private native String[] getFocusedWidgetChoiceOptions();

    private native int setFocusedWidgetTextInternal(String var1);

    private native String getFocusedWidgetTextInternal();

    private native int getFocusedWidgetTypeInternal();

    private native LinkInfo[] getPageLinksInternal(int var1);

    private native RectF[] getWidgetAreasInternal(int var1);

    private native Annotation[] getAnnotationsInternal(int var1);

    private native OutlineItem[] getOutlineInternal();

    private native boolean hasOutlineInternal();

    private native boolean needsPasswordInternal();

    private native boolean authenticatePasswordInternal(String var1);

    private native MuPDFAlertInternal waitForAlertInternal();

    private native void replyToAlertInternal(MuPDFAlertInternal var1);

    private native void startAlertsInternal();

    private native void stopAlertsInternal();

    private native void destroying();

    private native boolean hasChangesInternal();

    private native void saveInternal();

    public static native boolean javascriptSupported();

    public MuPDFCore(Context context, String filename) throws Exception {
        this.globals = this.openFile(filename);
        if (this.globals == 0L) {
            throw new Exception(String.format(context.getString(2131099689), filename));
        }
        this.file_format = this.fileFormatInternal();
    }

    public MuPDFCore(Context context, byte[] buffer) throws Exception {
        this.fileBuffer = buffer;
        this.globals = this.openBuffer();
        if (this.globals == 0L) {
            throw new Exception(context.getString(2131099690));
        }
        this.file_format = this.fileFormatInternal();
    }

    public int countPages() {
        if (this.numPages < 0) {
            this.numPages = this.countPagesSynchronized();
        }
        return this.numPages;
    }

    public String fileFormat() {
        return this.file_format;
    }

    private synchronized int countPagesSynchronized() {
        return this.countPagesInternal();
    }

    private void gotoPage(int page) {
        if (page > this.numPages - 1) {
            page = this.numPages - 1;
        } else if (page < 0) {
            page = 0;
        }
        this.gotoPageInternal(page);
        this.pageWidth = this.getPageWidth();
        this.pageHeight = this.getPageHeight();
    }

    public synchronized PointF getPageSize(int page) {
        this.gotoPage(page);
        return new PointF(this.pageWidth, this.pageHeight);
    }

    public MuPDFAlert waitForAlert() {
        MuPDFAlertInternal alert = this.waitForAlertInternal();
        return alert != null ? alert.toAlert() : null;
    }

    public void replyToAlert(MuPDFAlert alert) {
        this.replyToAlertInternal(new MuPDFAlertInternal(alert));
    }

    public void stopAlerts() {
        this.stopAlertsInternal();
    }

    public void startAlerts() {
        this.startAlertsInternal();
    }

    public synchronized void onDestroy() {
        this.destroying();
        this.globals = 0L;
    }

    public synchronized Bitmap drawPage(int page, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH) {
        this.gotoPage(page);
        Bitmap bm = Bitmap.createBitmap((int)patchW, (int)patchH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.drawPage(bm, pageW, pageH, patchX, patchY, patchW, patchH);
        return bm;
    }

    public synchronized Bitmap updatePage(BitmapHolder h, int page, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH) {
        Bitmap bm = null;
        Bitmap old_bm = h.getBm();
        if (old_bm == null) {
            return null;
        }
        bm = old_bm.copy(Bitmap.Config.ARGB_8888, false);
        old_bm = null;
        this.updatePageInternal(bm, page, pageW, pageH, patchX, patchY, patchW, patchH);
        return bm;
    }

    public synchronized PassClickResult passClickEvent(int page, float x, float y) {
        boolean changed = this.passClickEventInternal(page, x, y) != 0;
        switch (WidgetType.values()[this.getFocusedWidgetTypeInternal()]) {
            case TEXT: {
                return new PassClickResultText(changed, this.getFocusedWidgetTextInternal());
            }
            case LISTBOX: 
            case COMBOBOX: {
                return new PassClickResultChoice(changed, this.getFocusedWidgetChoiceOptions(), this.getFocusedWidgetChoiceSelected());
            }
        }
        return new PassClickResult(changed);
    }

    public synchronized boolean setFocusedWidgetText(int page, String text) {
        this.gotoPage(page);
        boolean success = this.setFocusedWidgetTextInternal(text) != 0;
        return success;
    }

    public synchronized void setFocusedWidgetChoiceSelected(String[] selected) {
        this.setFocusedWidgetChoiceSelectedInternal(selected);
    }

    public synchronized LinkInfo[] getPageLinks(int page) {
        return this.getPageLinksInternal(page);
    }

    public synchronized RectF[] getWidgetAreas(int page) {
        return this.getWidgetAreasInternal(page);
    }

    public synchronized Annotation[] getAnnoations(int page) {
        return this.getAnnotationsInternal(page);
    }

    public synchronized RectF[] searchPage(int page, String text) {
        this.gotoPage(page);
        return this.searchPage(text);
    }

    public synchronized byte[] html(int page) {
        this.gotoPage(page);
        return this.textAsHtml();
    }

    public synchronized TextWord[][] textLines(int page) {
        this.gotoPage(page);
        TextChar[][][][] chars = this.text();
        ArrayList<TextWord[]> lns = new ArrayList<TextWord[]>();
        TextChar[][][][] textCharArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            TextChar[][][] bl;
            TextChar[][][] textCharArray2 = bl = textCharArray[n2];
            int n3 = bl.length;
            int n4 = 0;
            while (n4 < n3) {
                TextChar[][] ln = textCharArray2[n4];
                ArrayList<TextWord> wds = new ArrayList<TextWord>();
                TextWord wd = new TextWord();
                TextChar[][] textCharArray3 = ln;
                int n5 = ln.length;
                int n6 = 0;
                while (n6 < n5) {
                    TextChar[] sp;
                    TextChar[] textCharArray4 = sp = textCharArray3[n6];
                    int n7 = sp.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        TextChar tc = textCharArray4[n8];
                        if (tc.c != ' ') {
                            wd.Add(tc);
                        } else if (wd.w.length() > 0) {
                            wds.add(wd);
                            wd = new TextWord();
                        }
                        ++n8;
                    }
                    ++n6;
                }
                if (wd.w.length() > 0) {
                    wds.add(wd);
                }
                if (wds.size() > 0) {
                    lns.add(wds.toArray(new TextWord[wds.size()]));
                }
                ++n4;
            }
            ++n2;
        }
        return (TextWord[][])lns.toArray((T[])new TextWord[lns.size()][]);
    }

    public synchronized void addMarkupAnnotation(int page, PointF[] quadPoints, Annotation.Type type) {
        this.gotoPage(page);
        this.addMarkupAnnotationInternal(quadPoints, type.ordinal());
    }

    public synchronized void addInkAnnotation(int page, PointF[][] arcs) {
        this.gotoPage(page);
        this.addInkAnnotationInternal(arcs);
    }

    public synchronized void deleteAnnotation(int page, int annot_index) {
        this.gotoPage(page);
        this.deleteAnnotationInternal(annot_index);
    }

    public synchronized boolean hasOutline() {
        return this.hasOutlineInternal();
    }

    public synchronized OutlineItem[] getOutline() {
        return this.getOutlineInternal();
    }

    public synchronized boolean needsPassword() {
        return this.needsPasswordInternal();
    }

    public synchronized boolean authenticatePassword(String password) {
        return this.authenticatePasswordInternal(password);
    }

    public synchronized boolean hasChanges() {
        return this.hasChangesInternal();
    }

    public synchronized void save() {
        this.saveInternal();
    }
}

