/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.Adapter;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.Hit;
import com.artifex.mupdfdemo.MuPDFAlert;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFPageAdapter;
import com.artifex.mupdfdemo.MuPDFReaderView;
import com.artifex.mupdfdemo.MuPDFReflowAdapter;
import com.artifex.mupdfdemo.MuPDFView;
import com.artifex.mupdfdemo.OutlineActivity;
import com.artifex.mupdfdemo.OutlineActivityData;
import com.artifex.mupdfdemo.OutlineItem;
import com.artifex.mupdfdemo.PrintDialogActivity;
import com.artifex.mupdfdemo.SafeAnimatorInflater;
import com.artifex.mupdfdemo.SearchTask;
import com.artifex.mupdfdemo.SearchTaskResult;
import com.artifex.mupdfdemo.ThreadPerTaskExecutor;
import java.io.InputStream;

public class MuPDFActivity
extends Activity {
    private final int OUTLINE_REQUEST = 0;
    private final int PRINT_REQUEST = 1;
    private MuPDFCore core;
    private String mFileName;
    private MuPDFReaderView mDocView;
    private View mButtonsView;
    private boolean mButtonsVisible;
    private EditText mPasswordView;
    private TextView mFilenameView;
    private SeekBar mPageSlider;
    private int mPageSliderRes;
    private TextView mPageNumberView;
    private TextView mInfoView;
    private ImageButton mSearchButton;
    private ImageButton mReflowButton;
    private ImageButton mOutlineButton;
    private ImageButton mMoreButton;
    private TextView mAnnotTypeText;
    private ImageButton mAnnotButton;
    private ViewAnimator mTopBarSwitcher;
    private ImageButton mLinkButton;
    private TopBarMode mTopBarMode = TopBarMode.Main;
    private AcceptMode mAcceptMode;
    private ImageButton mSearchBack;
    private ImageButton mSearchFwd;
    private EditText mSearchText;
    private SearchTask mSearchTask;
    private AlertDialog.Builder mAlertBuilder;
    private boolean mLinkHighlight = false;
    private final Handler mHandler = new Handler();
    private boolean mAlertsActive = false;
    private boolean mReflow = false;
    private AsyncTask<Void, Void, MuPDFAlert> mAlertTask;
    private AlertDialog mAlertDialog;

    public void createAlertWaiter() {
        this.mAlertsActive = true;
        if (this.mAlertTask != null) {
            this.mAlertTask.cancel(true);
            this.mAlertTask = null;
        }
        if (this.mAlertDialog != null) {
            this.mAlertDialog.cancel();
            this.mAlertDialog = null;
        }
        this.mAlertTask = new AsyncTask<Void, Void, MuPDFAlert>(){

            protected MuPDFAlert doInBackground(Void ... arg0) {
                if (!MuPDFActivity.this.mAlertsActive) {
                    return null;
                }
                return MuPDFActivity.this.core.waitForAlert();
            }

            @Override
            protected void onPostExecute(final MuPDFAlert result) {
                if (result == null) {
                    return;
                }
                final MuPDFAlert.ButtonPressed[] pressed = new MuPDFAlert.ButtonPressed[3];
                int i = 0;
                while (i < 3) {
                    pressed[i] = MuPDFAlert.ButtonPressed.None;
                    ++i;
                }
                DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        MuPDFActivity.this.mAlertDialog = null;
                        if (MuPDFActivity.this.mAlertsActive) {
                            int index = 0;
                            switch (which) {
                                case -1: {
                                    index = 0;
                                    break;
                                }
                                case -2: {
                                    index = 1;
                                    break;
                                }
                                case -3: {
                                    index = 2;
                                }
                            }
                            result.buttonPressed = pressed[index];
                            MuPDFActivity.this.core.replyToAlert(result);
                            MuPDFActivity.this.createAlertWaiter();
                        }
                    }
                };
                MuPDFActivity.this.mAlertDialog = MuPDFActivity.this.mAlertBuilder.create();
                MuPDFActivity.this.mAlertDialog.setTitle((CharSequence)result.title);
                MuPDFActivity.this.mAlertDialog.setMessage((CharSequence)result.message);
                switch (result.iconType) {
                    case Error: {
                        break;
                    }
                    case Warning: {
                        break;
                    }
                    case Question: {
                        break;
                    }
                }
                switch (result.buttonGroupType) {
                    case OkCancel: {
                        MuPDFActivity.this.mAlertDialog.setButton(-2, (CharSequence)MuPDFActivity.this.getString(2131099652), listener);
                        pressed[1] = MuPDFAlert.ButtonPressed.Cancel;
                    }
                    case Ok: {
                        MuPDFActivity.this.mAlertDialog.setButton(-1, (CharSequence)MuPDFActivity.this.getString(2131099692), listener);
                        pressed[0] = MuPDFAlert.ButtonPressed.Ok;
                        break;
                    }
                    case YesNoCancel: {
                        MuPDFActivity.this.mAlertDialog.setButton(-3, (CharSequence)MuPDFActivity.this.getString(2131099652), listener);
                        pressed[2] = MuPDFAlert.ButtonPressed.Cancel;
                    }
                    case YesNo: {
                        MuPDFActivity.this.mAlertDialog.setButton(-1, (CharSequence)MuPDFActivity.this.getString(2131099676), listener);
                        pressed[0] = MuPDFAlert.ButtonPressed.Yes;
                        MuPDFActivity.this.mAlertDialog.setButton(-2, (CharSequence)MuPDFActivity.this.getString(2131099677), listener);
                        pressed[1] = MuPDFAlert.ButtonPressed.No;
                    }
                }
                MuPDFActivity.this.mAlertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        MuPDFActivity.this.mAlertDialog = null;
                        if (MuPDFActivity.this.mAlertsActive) {
                            result.buttonPressed = MuPDFAlert.ButtonPressed.None;
                            MuPDFActivity.this.core.replyToAlert(result);
                            MuPDFActivity.this.createAlertWaiter();
                        }
                    }
                });
                MuPDFActivity.this.mAlertDialog.show();
            }
        };
        this.mAlertTask.executeOnExecutor(new ThreadPerTaskExecutor(), (Void[])new Void[0]);
    }

    public void destroyAlertWaiter() {
        this.mAlertsActive = false;
        if (this.mAlertDialog != null) {
            this.mAlertDialog.cancel();
            this.mAlertDialog = null;
        }
        if (this.mAlertTask != null) {
            this.mAlertTask.cancel(true);
            this.mAlertTask = null;
        }
    }

    private MuPDFCore openFile(String path) {
        int lastSlashPos = path.lastIndexOf(47);
        this.mFileName = new String(lastSlashPos == -1 ? path : path.substring(lastSlashPos + 1));
        System.out.println("Trying to open " + path);
        try {
            this.core = new MuPDFCore((Context)this, path);
            OutlineActivityData.set(null);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
        return this.core;
    }

    private MuPDFCore openBuffer(byte[] buffer) {
        System.out.println("Trying to open byte buffer");
        try {
            this.core = new MuPDFCore((Context)this, buffer);
            OutlineActivityData.set(null);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
        return this.core;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAlertBuilder = new AlertDialog.Builder((Context)this);
        if (this.core == null) {
            this.core = (MuPDFCore)this.getLastNonConfigurationInstance();
            if (savedInstanceState != null && savedInstanceState.containsKey("FileName")) {
                this.mFileName = savedInstanceState.getString("FileName");
            }
        }
        if (this.core == null) {
            Intent intent = this.getIntent();
            byte[] buffer = null;
            if ("android.intent.action.VIEW".equals(intent.getAction())) {
                Cursor cursor;
                Uri uri = intent.getData();
                if (uri.toString().startsWith("content://") && (cursor = this.getContentResolver().query(uri, new String[]{"_data"}, null, null, null)).moveToFirst()) {
                    String str = cursor.getString(0);
                    String reason = null;
                    if (str == null) {
                        try {
                            InputStream is = this.getContentResolver().openInputStream(uri);
                            int len = is.available();
                            buffer = new byte[len];
                            is.read(buffer, 0, len);
                            is.close();
                        }
                        catch (OutOfMemoryError e) {
                            System.out.println("Out of memory during buffer reading");
                            reason = e.toString();
                        }
                        catch (Exception e) {
                            reason = e.toString();
                        }
                        if (reason != null) {
                            buffer = null;
                            Resources res = this.getResources();
                            AlertDialog alert = this.mAlertBuilder.create();
                            this.setTitle(String.format(res.getString(2131099688), reason));
                            alert.setButton(-1, (CharSequence)this.getString(2131099674), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    MuPDFActivity.this.finish();
                                }
                            });
                            alert.show();
                            return;
                        }
                    } else {
                        uri = Uri.parse((String)str);
                    }
                }
                this.core = buffer != null ? this.openBuffer(buffer) : this.openFile(Uri.decode((String)uri.getEncodedPath()));
                SearchTaskResult.set(null);
            }
            if (this.core != null && this.core.needsPassword()) {
                this.requestPassword(savedInstanceState);
                return;
            }
            if (this.core != null && this.core.countPages() == 0) {
                this.core = null;
            }
        }
        if (this.core == null) {
            AlertDialog alert = this.mAlertBuilder.create();
            alert.setTitle(2131099687);
            alert.setButton(-1, (CharSequence)this.getString(2131099674), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MuPDFActivity.this.finish();
                }
            });
            alert.show();
            return;
        }
        this.createUI(savedInstanceState);
    }

    public void requestPassword(final Bundle savedInstanceState) {
        this.mPasswordView = new EditText((Context)this);
        this.mPasswordView.setInputType(128);
        this.mPasswordView.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
        AlertDialog alert = this.mAlertBuilder.create();
        alert.setTitle(2131099658);
        alert.setView((View)this.mPasswordView);
        alert.setButton(-1, (CharSequence)this.getString(2131099692), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (MuPDFActivity.this.core.authenticatePassword(MuPDFActivity.this.mPasswordView.getText().toString())) {
                    MuPDFActivity.this.createUI(savedInstanceState);
                } else {
                    MuPDFActivity.this.requestPassword(savedInstanceState);
                }
            }
        });
        alert.setButton(-2, (CharSequence)this.getString(2131099652), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MuPDFActivity.this.finish();
            }
        });
        alert.show();
    }

    public void createUI(Bundle savedInstanceState) {
        if (this.core == null) {
            return;
        }
        this.mDocView = new MuPDFReaderView(this){

            @Override
            protected void onMoveToChild(int i) {
                if (MuPDFActivity.this.core == null) {
                    return;
                }
                MuPDFActivity.this.mPageNumberView.setText((CharSequence)String.format("%d / %d", i + 1, MuPDFActivity.this.core.countPages()));
                MuPDFActivity.this.mPageSlider.setMax((MuPDFActivity.this.core.countPages() - 1) * MuPDFActivity.this.mPageSliderRes);
                MuPDFActivity.this.mPageSlider.setProgress(i * MuPDFActivity.this.mPageSliderRes);
                super.onMoveToChild(i);
            }

            @Override
            protected void onTapMainDocArea() {
                if (!MuPDFActivity.this.mButtonsVisible) {
                    MuPDFActivity.this.showButtons();
                } else if (MuPDFActivity.this.mTopBarMode == TopBarMode.Main) {
                    MuPDFActivity.this.hideButtons();
                }
            }

            @Override
            protected void onDocMotion() {
                MuPDFActivity.this.hideButtons();
            }

            @Override
            protected void onHit(Hit item) {
                switch (MuPDFActivity.this.mTopBarMode) {
                    case Annot: {
                        if (item != Hit.Annotation) break;
                        MuPDFActivity.this.showButtons();
                        MuPDFActivity.this.mTopBarMode = TopBarMode.Delete;
                        MuPDFActivity.this.mTopBarSwitcher.setDisplayedChild(MuPDFActivity.this.mTopBarMode.ordinal());
                        break;
                    }
                    case Delete: {
                        MuPDFActivity.this.mTopBarMode = TopBarMode.Annot;
                        MuPDFActivity.this.mTopBarSwitcher.setDisplayedChild(MuPDFActivity.this.mTopBarMode.ordinal());
                    }
                    default: {
                        MuPDFView pageView = (MuPDFView)MuPDFActivity.this.mDocView.getDisplayedView();
                        if (pageView == null) break;
                        pageView.deselectAnnotation();
                    }
                }
            }
        };
        this.mDocView.setAdapter((Adapter)new MuPDFPageAdapter((Context)this, this.core));
        this.mSearchTask = new SearchTask((Context)this, this.core){

            @Override
            protected void onTextFound(SearchTaskResult result) {
                SearchTaskResult.set(result);
                MuPDFActivity.this.mDocView.setDisplayedViewIndex(result.pageNumber);
                MuPDFActivity.this.mDocView.resetupChildren();
            }
        };
        this.makeButtonsView();
        int smax = Math.max(this.core.countPages() - 1, 1);
        this.mPageSliderRes = (10 + smax - 1) / smax * 2;
        this.mFilenameView.setText((CharSequence)this.mFileName);
        this.mPageSlider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                MuPDFActivity.this.mDocView.setDisplayedViewIndex((seekBar.getProgress() + MuPDFActivity.this.mPageSliderRes / 2) / MuPDFActivity.this.mPageSliderRes);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                MuPDFActivity.this.updatePageNumView((progress + MuPDFActivity.this.mPageSliderRes / 2) / MuPDFActivity.this.mPageSliderRes);
            }
        });
        this.mSearchButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MuPDFActivity.this.searchModeOn();
            }
        });
        this.mReflowButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MuPDFActivity.this.toggleReflow();
            }
        });
        if (this.core.fileFormat().startsWith("PDF")) {
            this.mAnnotButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MuPDFActivity.this.mTopBarMode = TopBarMode.Annot;
                    MuPDFActivity.this.mTopBarSwitcher.setDisplayedChild(MuPDFActivity.this.mTopBarMode.ordinal());
                }
            });
        } else {
            this.mAnnotButton.setVisibility(8);
        }
        this.mSearchBack.setEnabled(false);
        this.mSearchFwd.setEnabled(false);
        this.mSearchBack.setColorFilter(Color.argb((int)255, (int)128, (int)128, (int)128));
        this.mSearchFwd.setColorFilter(Color.argb((int)255, (int)128, (int)128, (int)128));
        this.mSearchText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                boolean haveText = s.toString().length() > 0;
                MuPDFActivity.this.setButtonEnabled(MuPDFActivity.this.mSearchBack, haveText);
                MuPDFActivity.this.setButtonEnabled(MuPDFActivity.this.mSearchFwd, haveText);
                if (SearchTaskResult.get() != null && !MuPDFActivity.this.mSearchText.getText().toString().equals(SearchTaskResult.get().txt)) {
                    SearchTaskResult.set(null);
                    MuPDFActivity.this.mDocView.resetupChildren();
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.mSearchText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    MuPDFActivity.this.search(1);
                }
                return false;
            }
        });
        this.mSearchText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 66) {
                    MuPDFActivity.this.search(1);
                }
                return false;
            }
        });
        this.mSearchBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MuPDFActivity.this.search(-1);
            }
        });
        this.mSearchFwd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MuPDFActivity.this.search(1);
            }
        });
        this.mLinkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MuPDFActivity.this.setLinkHighlight(!MuPDFActivity.this.mLinkHighlight);
            }
        });
        if (this.core.hasOutline()) {
            this.mOutlineButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    OutlineItem[] outline = MuPDFActivity.this.core.getOutline();
                    if (outline != null) {
                        OutlineActivityData.get().items = outline;
                        Intent intent = new Intent((Context)MuPDFActivity.this, OutlineActivity.class);
                        MuPDFActivity.this.startActivityForResult(intent, 0);
                    }
                }
            });
        } else {
            this.mOutlineButton.setVisibility(8);
        }
        SharedPreferences prefs = this.getPreferences(0);
        this.mDocView.setDisplayedViewIndex(prefs.getInt("page" + this.mFileName, 0));
        if (savedInstanceState == null || !savedInstanceState.getBoolean("ButtonsHidden", false)) {
            this.showButtons();
        }
        if (savedInstanceState != null && savedInstanceState.getBoolean("SearchMode", false)) {
            this.searchModeOn();
        }
        if (savedInstanceState != null && savedInstanceState.getBoolean("ReflowMode", false)) {
            this.reflowModeSet(true);
        }
        RelativeLayout layout = new RelativeLayout((Context)this);
        layout.addView((View)this.mDocView);
        layout.addView(this.mButtonsView);
        this.setContentView((View)layout);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 0: {
                if (resultCode < 0) break;
                this.mDocView.setDisplayedViewIndex(resultCode);
                break;
            }
            case 1: {
                if (resultCode != 0) break;
                this.showInfo(this.getString(2131099680));
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public Object onRetainNonConfigurationInstance() {
        MuPDFCore mycore = this.core;
        this.core = null;
        return mycore;
    }

    private void reflowModeSet(boolean reflow) {
        this.mReflow = reflow;
        this.mDocView.setAdapter((Adapter)(this.mReflow ? new MuPDFReflowAdapter((Context)this, this.core) : new MuPDFPageAdapter((Context)this, this.core)));
        this.mReflowButton.setColorFilter(this.mReflow ? Color.argb((int)255, (int)172, (int)114, (int)37) : Color.argb((int)255, (int)255, (int)255, (int)255));
        this.setButtonEnabled(this.mAnnotButton, !reflow);
        this.setButtonEnabled(this.mSearchButton, !reflow);
        if (reflow) {
            this.setLinkHighlight(false);
        }
        this.setButtonEnabled(this.mLinkButton, !reflow);
        this.setButtonEnabled(this.mMoreButton, !reflow);
        this.mDocView.refresh(this.mReflow);
    }

    private void toggleReflow() {
        this.reflowModeSet(!this.mReflow);
        this.showInfo(this.mReflow ? this.getString(2131099678) : this.getString(2131099679));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mFileName != null && this.mDocView != null) {
            outState.putString("FileName", this.mFileName);
            SharedPreferences prefs = this.getPreferences(0);
            SharedPreferences.Editor edit = prefs.edit();
            edit.putInt("page" + this.mFileName, this.mDocView.getDisplayedViewIndex());
            edit.commit();
        }
        if (!this.mButtonsVisible) {
            outState.putBoolean("ButtonsHidden", true);
        }
        if (this.mTopBarMode == TopBarMode.Search) {
            outState.putBoolean("SearchMode", true);
        }
        if (this.mReflow) {
            outState.putBoolean("ReflowMode", true);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mSearchTask != null) {
            this.mSearchTask.stop();
        }
        if (this.mFileName != null && this.mDocView != null) {
            SharedPreferences prefs = this.getPreferences(0);
            SharedPreferences.Editor edit = prefs.edit();
            edit.putInt("page" + this.mFileName, this.mDocView.getDisplayedViewIndex());
            edit.commit();
        }
    }

    public void onDestroy() {
        if (this.core != null) {
            this.core.onDestroy();
        }
        if (this.mAlertTask != null) {
            this.mAlertTask.cancel(true);
            this.mAlertTask = null;
        }
        this.core = null;
        super.onDestroy();
    }

    private void setButtonEnabled(ImageButton button, boolean enabled) {
        button.setEnabled(enabled);
        button.setColorFilter(enabled ? Color.argb((int)255, (int)255, (int)255, (int)255) : Color.argb((int)255, (int)128, (int)128, (int)128));
    }

    private void setLinkHighlight(boolean highlight) {
        this.mLinkHighlight = highlight;
        this.mLinkButton.setColorFilter(highlight ? Color.argb((int)255, (int)172, (int)114, (int)37) : Color.argb((int)255, (int)255, (int)255, (int)255));
        this.mDocView.setLinksEnabled(highlight);
    }

    private void showButtons() {
        if (this.core == null) {
            return;
        }
        if (!this.mButtonsVisible) {
            this.mButtonsVisible = true;
            int index = this.mDocView.getDisplayedViewIndex();
            this.updatePageNumView(index);
            this.mPageSlider.setMax((this.core.countPages() - 1) * this.mPageSliderRes);
            this.mPageSlider.setProgress(index * this.mPageSliderRes);
            if (this.mTopBarMode == TopBarMode.Search) {
                this.mSearchText.requestFocus();
                this.showKeyboard();
            }
            TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, (float)(-this.mTopBarSwitcher.getHeight()), 0.0f);
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    MuPDFActivity.this.mTopBarSwitcher.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                }
            });
            this.mTopBarSwitcher.startAnimation((Animation)anim);
            anim = new TranslateAnimation(0.0f, 0.0f, (float)this.mPageSlider.getHeight(), 0.0f);
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    MuPDFActivity.this.mPageSlider.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MuPDFActivity.this.mPageNumberView.setVisibility(0);
                }
            });
            this.mPageSlider.startAnimation((Animation)anim);
        }
    }

    private void hideButtons() {
        if (this.mButtonsVisible) {
            this.mButtonsVisible = false;
            this.hideKeyboard();
            TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-this.mTopBarSwitcher.getHeight()));
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MuPDFActivity.this.mTopBarSwitcher.setVisibility(4);
                }
            });
            this.mTopBarSwitcher.startAnimation((Animation)anim);
            anim = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.mPageSlider.getHeight());
            anim.setDuration(200L);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    MuPDFActivity.this.mPageNumberView.setVisibility(4);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MuPDFActivity.this.mPageSlider.setVisibility(4);
                }
            });
            this.mPageSlider.startAnimation((Animation)anim);
        }
    }

    private void searchModeOn() {
        if (this.mTopBarMode != TopBarMode.Search) {
            this.mTopBarMode = TopBarMode.Search;
            this.mSearchText.requestFocus();
            this.showKeyboard();
            this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        }
    }

    private void searchModeOff() {
        if (this.mTopBarMode == TopBarMode.Search) {
            this.mTopBarMode = TopBarMode.Main;
            this.hideKeyboard();
            this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
            SearchTaskResult.set(null);
            this.mDocView.resetupChildren();
        }
    }

    private void updatePageNumView(int index) {
        if (this.core == null) {
            return;
        }
        this.mPageNumberView.setText((CharSequence)String.format("%d / %d", index + 1, this.core.countPages()));
    }

    private void printDoc() {
        Uri docUri;
        if (!this.core.fileFormat().startsWith("PDF")) {
            this.showInfo(this.getString(2131099699));
            return;
        }
        Intent myIntent = this.getIntent();
        Uri uri = docUri = myIntent != null ? myIntent.getData() : null;
        if (docUri == null) {
            this.showInfo(this.getString(2131099680));
        }
        if (docUri.getScheme() == null) {
            docUri = Uri.parse((String)("file://" + docUri.toString()));
        }
        Intent printIntent = new Intent((Context)this, PrintDialogActivity.class);
        printIntent.setDataAndType(docUri, "aplication/pdf");
        printIntent.putExtra("title", this.mFileName);
        this.startActivityForResult(printIntent, 1);
    }

    private void showInfo(String message) {
        this.mInfoView.setText((CharSequence)message);
        int currentApiVersion = Build.VERSION.SDK_INT;
        if (currentApiVersion >= 11) {
            SafeAnimatorInflater safe = new SafeAnimatorInflater(this, 2130968576, (View)this.mInfoView);
        } else {
            this.mInfoView.setVisibility(0);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MuPDFActivity.this.mInfoView.setVisibility(4);
                }
            }, 500L);
        }
    }

    private void makeButtonsView() {
        this.mButtonsView = this.getLayoutInflater().inflate(2130903040, null);
        this.mFilenameView = (TextView)this.mButtonsView.findViewById(2131230722);
        this.mPageSlider = (SeekBar)this.mButtonsView.findViewById(2131230753);
        this.mPageNumberView = (TextView)this.mButtonsView.findViewById(2131230754);
        this.mInfoView = (TextView)this.mButtonsView.findViewById(2131230755);
        this.mSearchButton = (ImageButton)this.mButtonsView.findViewById(2131230726);
        this.mReflowButton = (ImageButton)this.mButtonsView.findViewById(2131230724);
        this.mOutlineButton = (ImageButton)this.mButtonsView.findViewById(2131230725);
        this.mAnnotButton = (ImageButton)this.mButtonsView.findViewById(2131230747);
        this.mAnnotTypeText = (TextView)this.mButtonsView.findViewById(2131230750);
        this.mTopBarSwitcher = (ViewAnimator)this.mButtonsView.findViewById(2131230720);
        this.mSearchBack = (ImageButton)this.mButtonsView.findViewById(2131230731);
        this.mSearchFwd = (ImageButton)this.mButtonsView.findViewById(2131230732);
        this.mSearchText = (EditText)this.mButtonsView.findViewById(2131230730);
        this.mLinkButton = (ImageButton)this.mButtonsView.findViewById(2131230723);
        this.mMoreButton = (ImageButton)this.mButtonsView.findViewById(2131230727);
        this.mTopBarSwitcher.setVisibility(4);
        this.mPageNumberView.setVisibility(4);
        this.mInfoView.setVisibility(4);
        this.mPageSlider.setVisibility(4);
    }

    public void OnMoreButtonClick(View v) {
        this.mTopBarMode = TopBarMode.More;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnCancelMoreButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Main;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnPrintButtonClick(View v) {
        this.printDoc();
    }

    public void OnCopyTextButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.CopyText;
        this.mDocView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText((CharSequence)this.getString(2131099698));
        this.showInfo(this.getString(2131099681));
    }

    public void OnEditAnnotButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Annot;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnCancelAnnotButtonClick(View v) {
        this.mTopBarMode = TopBarMode.More;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnHighlightButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.Highlight;
        this.mDocView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText(2131099668);
        this.showInfo(this.getString(2131099681));
    }

    public void OnUnderlineButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.Underline;
        this.mDocView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText(2131099669);
        this.showInfo(this.getString(2131099681));
    }

    public void OnStrikeOutButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.StrikeOut;
        this.mDocView.setMode(MuPDFReaderView.Mode.Selecting);
        this.mAnnotTypeText.setText(2131099666);
        this.showInfo(this.getString(2131099681));
    }

    public void OnInkButtonClick(View v) {
        this.mTopBarMode = TopBarMode.Accept;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mAcceptMode = AcceptMode.Ink;
        this.mDocView.setMode(MuPDFReaderView.Mode.Drawing);
        this.mAnnotTypeText.setText(2131099671);
        this.showInfo(this.getString(2131099684));
    }

    public void OnCancelAcceptButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.mDocView.getDisplayedView();
        if (pageView != null) {
            pageView.deselectText();
            pageView.cancelDraw();
        }
        this.mDocView.setMode(MuPDFReaderView.Mode.Viewing);
        switch (this.mAcceptMode) {
            case CopyText: {
                this.mTopBarMode = TopBarMode.More;
                break;
            }
            default: {
                this.mTopBarMode = TopBarMode.Annot;
            }
        }
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnAcceptButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.mDocView.getDisplayedView();
        boolean success = false;
        switch (this.mAcceptMode) {
            case CopyText: {
                if (pageView != null) {
                    success = pageView.copySelection();
                }
                this.mTopBarMode = TopBarMode.More;
                this.showInfo(success ? this.getString(2131099682) : this.getString(2131099683));
                break;
            }
            case Highlight: {
                if (pageView != null) {
                    success = pageView.markupSelection(Annotation.Type.HIGHLIGHT);
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(2131099683));
                break;
            }
            case Underline: {
                if (pageView != null) {
                    success = pageView.markupSelection(Annotation.Type.UNDERLINE);
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(2131099683));
                break;
            }
            case StrikeOut: {
                if (pageView != null) {
                    success = pageView.markupSelection(Annotation.Type.STRIKEOUT);
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(2131099683));
                break;
            }
            case Ink: {
                if (pageView != null) {
                    success = pageView.saveDraw();
                }
                this.mTopBarMode = TopBarMode.Annot;
                if (success) break;
                this.showInfo(this.getString(2131099685));
            }
        }
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
        this.mDocView.setMode(MuPDFReaderView.Mode.Viewing);
    }

    public void OnCancelSearchButtonClick(View v) {
        this.searchModeOff();
    }

    public void OnDeleteButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.mDocView.getDisplayedView();
        if (pageView != null) {
            pageView.deleteSelectedAnnotation();
        }
        this.mTopBarMode = TopBarMode.Annot;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    public void OnCancelDeleteButtonClick(View v) {
        MuPDFView pageView = (MuPDFView)this.mDocView.getDisplayedView();
        if (pageView != null) {
            pageView.deselectAnnotation();
        }
        this.mTopBarMode = TopBarMode.Annot;
        this.mTopBarSwitcher.setDisplayedChild(this.mTopBarMode.ordinal());
    }

    private void showKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInput((View)this.mSearchText, 0);
        }
    }

    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.mSearchText.getWindowToken(), 0);
        }
    }

    private void search(int direction) {
        this.hideKeyboard();
        int displayPage = this.mDocView.getDisplayedViewIndex();
        SearchTaskResult r = SearchTaskResult.get();
        int searchPage = r != null ? r.pageNumber : -1;
        this.mSearchTask.go(this.mSearchText.getText().toString(), direction, displayPage, searchPage);
    }

    public boolean onSearchRequested() {
        if (this.mButtonsVisible && this.mTopBarMode == TopBarMode.Search) {
            this.hideButtons();
        } else {
            this.showButtons();
            this.searchModeOn();
        }
        return super.onSearchRequested();
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.mButtonsVisible && this.mTopBarMode != TopBarMode.Search) {
            this.hideButtons();
        } else {
            this.showButtons();
            this.searchModeOff();
        }
        return super.onPrepareOptionsMenu(menu);
    }

    protected void onStart() {
        if (this.core != null) {
            this.core.startAlerts();
            this.createAlertWaiter();
        }
        super.onStart();
    }

    protected void onStop() {
        if (this.core != null) {
            this.destroyAlertWaiter();
            this.core.stopAlerts();
        }
        super.onStop();
    }

    public void onBackPressed() {
        if (this.core.hasChanges()) {
            DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (which == -1) {
                        MuPDFActivity.this.core.save();
                    }
                    MuPDFActivity.this.finish();
                }
            };
            AlertDialog alert = this.mAlertBuilder.create();
            alert.setTitle((CharSequence)"MuPDF");
            alert.setMessage((CharSequence)this.getString(2131099686));
            alert.setButton(-1, (CharSequence)this.getString(2131099676), listener);
            alert.setButton(-2, (CharSequence)this.getString(2131099677), listener);
            alert.show();
        } else {
            super.onBackPressed();
        }
    }

    static enum AcceptMode {
        Highlight,
        Underline,
        StrikeOut,
        Ink,
        CopyText;

    }

    static enum TopBarMode {
        Main,
        Search,
        Annot,
        Delete,
        More,
        Accept;

    }
}

