/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.cookie;

import android.text.TextUtils;
import java.net.HttpCookie;
import java.net.URI;
import org.xutils.db.annotation.Column;
import org.xutils.db.annotation.Table;

@Table(name="cookie", onCreated="CREATE UNIQUE INDEX index_cookie_unique ON cookie(\"name\",\"domain\",\"path\")")
final class CookieEntity {
    private static final long MAX_EXPIRY = System.currentTimeMillis() + 3110400000000L;
    @Column(name="id", isId=true)
    private long id;
    @Column(name="uri")
    private String uri;
    @Column(name="name")
    private String name;
    @Column(name="value")
    private String value;
    @Column(name="comment")
    private String comment;
    @Column(name="commentURL")
    private String commentURL;
    @Column(name="discard")
    private boolean discard;
    @Column(name="domain")
    private String domain;
    @Column(name="expiry")
    private long expiry = MAX_EXPIRY;
    @Column(name="path")
    private String path;
    @Column(name="portList")
    private String portList;
    @Column(name="secure")
    private boolean secure;
    @Column(name="version")
    private int version = 1;

    public CookieEntity() {
    }

    public CookieEntity(URI uri, HttpCookie cookie) {
        this.uri = uri == null ? null : uri.toString();
        this.name = cookie.getName();
        this.value = cookie.getValue();
        this.comment = cookie.getComment();
        this.commentURL = cookie.getCommentURL();
        this.discard = cookie.getDiscard();
        this.domain = cookie.getDomain();
        long maxAge = cookie.getMaxAge();
        if (maxAge != -1L && maxAge > 0L) {
            this.expiry = maxAge * 1000L + System.currentTimeMillis();
            if (this.expiry < 0L) {
                this.expiry = MAX_EXPIRY;
            }
        } else {
            this.expiry = -1L;
        }
        this.path = cookie.getPath();
        if (!TextUtils.isEmpty((CharSequence)this.path) && this.path.length() > 1 && this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        this.portList = cookie.getPortlist();
        this.secure = cookie.getSecure();
        this.version = cookie.getVersion();
    }

    public HttpCookie toHttpCookie() {
        HttpCookie cookie = new HttpCookie(this.name, this.value);
        cookie.setComment(this.comment);
        cookie.setCommentURL(this.commentURL);
        cookie.setDiscard(this.discard);
        cookie.setDomain(this.domain);
        if (this.expiry == -1L) {
            cookie.setMaxAge(-1L);
        } else {
            cookie.setMaxAge((this.expiry - System.currentTimeMillis()) / 1000L);
        }
        cookie.setPath(this.path);
        cookie.setPortlist(this.portList);
        cookie.setSecure(this.secure);
        cookie.setVersion(this.version);
        return cookie;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isExpired() {
        return this.expiry != -1L && this.expiry < System.currentTimeMillis();
    }
}

