/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db;

import android.database.Cursor;
import java.util.ArrayList;
import java.util.List;
import org.xutils.common.util.IOUtil;
import org.xutils.db.CursorFilter;
import org.xutils.db.CursorUtils;
import org.xutils.db.DbModelSelector;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

public final class Selector<T> {
    private final TableEntity<T> table;
    private WhereBuilder whereBuilder;
    private List<OrderBy> orderByList;
    private int limit = 0;
    private int offset = 0;

    private Selector(TableEntity<T> table) {
        this.table = table;
    }

    static <T> Selector<T> from(TableEntity<T> table) {
        return new Selector<T>(table);
    }

    public Selector<T> where(WhereBuilder whereBuilder) {
        this.whereBuilder = whereBuilder;
        return this;
    }

    public Selector<T> where(String columnName, String op, Object value) {
        this.whereBuilder = WhereBuilder.b(columnName, op, value);
        return this;
    }

    public Selector<T> and(String columnName, String op, Object value) {
        this.whereBuilder.and(columnName, op, value);
        return this;
    }

    public Selector<T> and(WhereBuilder where) {
        this.whereBuilder.and(where);
        return this;
    }

    public Selector<T> or(String columnName, String op, Object value) {
        this.whereBuilder.or(columnName, op, value);
        return this;
    }

    public Selector or(WhereBuilder where) {
        this.whereBuilder.or(where);
        return this;
    }

    public Selector<T> expr(String expr) {
        if (this.whereBuilder == null) {
            this.whereBuilder = WhereBuilder.b();
        }
        this.whereBuilder.expr(expr);
        return this;
    }

    public DbModelSelector groupBy(String columnName) {
        return new DbModelSelector(this, columnName);
    }

    public DbModelSelector select(String ... columnExpressions) {
        return new DbModelSelector(this, columnExpressions);
    }

    public Selector<T> orderBy(String columnName) {
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>(5);
        }
        this.orderByList.add(new OrderBy(columnName));
        return this;
    }

    public Selector<T> orderBy(String columnName, boolean desc) {
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>(5);
        }
        this.orderByList.add(new OrderBy(columnName, desc));
        return this;
    }

    public Selector<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Selector<T> offset(int offset) {
        this.offset = offset;
        return this;
    }

    public TableEntity<T> getTable() {
        return this.table;
    }

    public WhereBuilder getWhereBuilder() {
        return this.whereBuilder;
    }

    public List<OrderBy> getOrderByList() {
        return this.orderByList;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public T findFirst() throws DbException {
        if (!this.table.tableIsExist()) {
            return null;
        }
        this.limit(1);
        Cursor cursor = this.table.getDb().execQuery(this.toString());
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    T t = CursorUtils.getEntity(this.table, cursor);
                    return t;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtil.closeQuietly(cursor);
            }
        }
        return null;
    }

    public List<T> findAll() throws DbException {
        return this.findAll(null);
    }

    public List<T> findAll(CursorFilter filter) throws DbException {
        if (!this.table.tableIsExist()) {
            return null;
        }
        ArrayList<T> result = null;
        Cursor cursor = this.table.getDb().execQuery(this.toString());
        if (cursor != null) {
            try {
                result = new ArrayList<T>();
                while (cursor.moveToNext()) {
                    T entity = CursorUtils.getEntity(this.table, cursor);
                    if (filter != null && filter.filter(entity)) {
                        result.add(entity);
                        continue;
                    }
                    result.add(entity);
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtil.closeQuietly(cursor);
            }
        }
        return result;
    }

    public long count() throws DbException {
        if (!this.table.tableIsExist()) {
            return 0L;
        }
        DbModelSelector dmSelector = this.select("count(\"" + this.table.getId().getName() + "\") as count");
        DbModel firstModel = dmSelector.findFirst();
        if (firstModel != null) {
            return firstModel.getLong("count");
        }
        return 0L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        result.append("*");
        result.append(" FROM ").append("\"").append(this.table.getName()).append("\"");
        if (this.whereBuilder != null && this.whereBuilder.getWhereItemSize() > 0) {
            result.append(" WHERE ").append(this.whereBuilder.toString());
        }
        if (this.orderByList != null && this.orderByList.size() > 0) {
            result.append(" ORDER BY ");
            for (OrderBy orderBy : this.orderByList) {
                result.append(orderBy.toString()).append(',');
            }
            result.deleteCharAt(result.length() - 1);
        }
        if (this.limit > 0) {
            result.append(" LIMIT ").append(this.limit);
            result.append(" OFFSET ").append(this.offset);
        }
        return result.toString();
    }

    public static class OrderBy {
        private String columnName;
        private boolean desc;

        public OrderBy(String columnName) {
            this.columnName = columnName;
        }

        public OrderBy(String columnName, boolean desc) {
            this.columnName = columnName;
            this.desc = desc;
        }

        public String toString() {
            return "\"" + this.columnName + "\"" + (this.desc ? " DESC" : " ASC");
        }
    }
}

