/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.widget.NumberPickerReflect;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DateTimePicker
extends FrameLayout {
    public static final int SELECT_TYPE_DATE_TIME = 0;
    public static final int SELECT_TYPE_DATE = 1;
    public static final int SELECT_TYPE_TIME = 2;
    public final String[] DATE_FORMAT = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd", "HH:mm"};
    public final String[] FAMILY_NAME = new String[]{"normal", "sans", "serif", "monospace"};
    private int dividerColor = -9254682;
    private int dividerDistance = 0;
    private int maxHeight = 0;
    private int textSize = 0;
    private int typeface = 0;
    private int textStyle = 0;
    private int textColor = -16777216;
    private int friction = 8;
    private NumberPickerReflect mNumberPicker1;
    private NumberPickerReflect mNumberPicker2;
    private NumberPickerReflect mNumberPicker3;
    private Calendar mDate;
    private int mSelectType = 0;
    private OnDateTimeChangedListener mOnDateTimeChangedListener;
    private NumberPicker.OnValueChangeListener mOnDateChangedListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            DateTimePicker.this.mDate.add(6, newVal - oldVal);
            DateTimePicker.this.updateDateControl();
            DateTimePicker.this.onDateTimeChanged();
        }
    };
    private NumberPicker.OnValueChangeListener mOnYearChangedListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            DateTimePicker.this.mDate.add(1, newVal - oldVal);
            DateTimePicker.this.updateYearControl();
            DateTimePicker.this.updateDayControl();
            DateTimePicker.this.onDateTimeChanged();
        }
    };
    private NumberPicker.OnValueChangeListener mOnMonthChangedListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, DateTimePicker.this.mDate.get(1));
            cal.set(2, picker.getValue());
            int maxDay = cal.getActualMaximum(5);
            int day = DateTimePicker.this.mDate.get(5);
            if (day > maxDay) {
                DateTimePicker.this.mDate.set(5, maxDay);
            }
            DateTimePicker.this.mDate.set(2, picker.getValue());
            DateTimePicker.this.updateDayControl();
            DateTimePicker.this.onDateTimeChanged();
        }
    };
    private NumberPicker.OnValueChangeListener mOnDayChangedListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            DateTimePicker.this.mDate.set(5, picker.getValue());
            DateTimePicker.this.onDateTimeChanged();
        }
    };
    private NumberPicker.OnValueChangeListener mOnHourChangedListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            DateTimePicker.this.mDate.set(11, picker.getValue());
            DateTimePicker.this.onDateTimeChanged();
        }
    };
    private NumberPicker.OnValueChangeListener mOnMinuteChangedListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            DateTimePicker.this.mDate.set(12, picker.getValue());
            DateTimePicker.this.onDateTimeChanged();
        }
    };

    public DateTimePicker(Context context) {
        this(context, new PickerOptions());
    }

    public DateTimePicker(Context context, int selectType) {
        this(context, new PickerOptions(selectType));
    }

    public DateTimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        int selectType = 0;
        long date = System.currentTimeMillis();
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.DateTimePicker);
            selectType = array.getInt(R.styleable.DateTimePicker_select_type, selectType);
            String specificDate = array.getString(R.styleable.DateTimePicker_specific_date);
            this.dividerColor = array.getColor(R.styleable.DateTimePicker_dtp_dividerColor, this.dividerColor);
            this.textColor = array.getColor(R.styleable.DateTimePicker_dtp_textColor, this.textColor);
            this.maxHeight = DimensionUtils.dip2Px(context, 180);
            this.maxHeight = array.getDimensionPixelSize(R.styleable.DateTimePicker_dtp_maxHeight, this.maxHeight);
            this.dividerDistance = DimensionUtils.dip2Px(context, 48);
            this.dividerDistance = array.getDimensionPixelSize(R.styleable.DateTimePicker_dtp_dividerDistance, this.dividerDistance);
            this.textSize = array.getDimensionPixelSize(R.styleable.DateTimePicker_dtp_textSize, this.textSize);
            this.typeface = array.getInt(R.styleable.DateTimePicker_dtp_typeface, this.typeface);
            this.textStyle = array.getInt(R.styleable.DateTimePicker_dtp_typeface, this.textStyle);
            array.recycle();
            try {
                date = new SimpleDateFormat(this.DATE_FORMAT[selectType]).parse(specificDate).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initViews(context, selectType);
        this.setDate(date);
    }

    public DateTimePicker(Context context, PickerOptions opts) {
        super(context);
        long date = this.evaluateOptions(opts);
        this.initViews(context, this.mSelectType);
        this.setDate(date);
    }

    public void setOptions(PickerOptions opts) {
        float firstNumberPickerWeight;
        if (opts == null) {
            return;
        }
        long date = this.evaluateOptions(opts);
        ((LinearLayout.LayoutParams)this.mNumberPicker1.getLayoutParams()).weight = firstNumberPickerWeight = this.mSelectType == 0 ? 2.0f : 1.0f;
        this.setCustom(this.mNumberPicker1);
        this.setCustom(this.mNumberPicker2);
        this.setCustom(this.mNumberPicker3);
        this.setDate(date);
    }

    public void setDate(long date) {
        this.mDate = Calendar.getInstance();
        this.mDate.setTimeInMillis(date);
        if (this.mSelectType == 0) {
            this.updateDateControl();
            this.updateHourControl();
            this.updateMinuteControl();
            this.mNumberPicker1.setOnValueChangedListener(this.mOnDateChangedListener);
            this.mNumberPicker2.setOnValueChangedListener(this.mOnHourChangedListener);
            this.mNumberPicker3.setOnValueChangedListener(this.mOnMinuteChangedListener);
        } else if (this.mSelectType == 1) {
            this.updateYearControl();
            this.updateMonthControl();
            this.updateDayControl();
            this.mNumberPicker1.setOnValueChangedListener(this.mOnYearChangedListener);
            this.mNumberPicker2.setOnValueChangedListener(this.mOnMonthChangedListener);
            this.mNumberPicker3.setOnValueChangedListener(this.mOnDayChangedListener);
        } else if (this.mSelectType == 2) {
            this.mNumberPicker1.setVisibility(8);
            this.updateHourControl();
            this.updateMinuteControl();
            this.mNumberPicker2.setOnValueChangedListener(this.mOnHourChangedListener);
            this.mNumberPicker3.setOnValueChangedListener(this.mOnMinuteChangedListener);
        }
    }

    public void setOnDateTimeChangedListener(OnDateTimeChangedListener callback) {
        this.mOnDateTimeChangedListener = callback;
    }

    public Calendar getDate() {
        return this.mDate;
    }

    private long evaluateOptions(PickerOptions opts) {
        long date = System.currentTimeMillis();
        if (opts != null) {
            this.dividerColor = opts.dividerColor;
            this.dividerDistance = opts.dividerDistance;
            this.maxHeight = opts.maxHeight;
            this.textColor = opts.textColor;
            this.textSize = opts.textSize;
            this.typeface = opts.typeface;
            this.textStyle = opts.textStyle;
            if (opts.friction > 0) {
                this.friction = opts.friction;
            }
            if (opts.selectType >= 0 && opts.selectType <= 2) {
                this.mSelectType = opts.selectType;
            }
            date = opts.date;
        }
        return date;
    }

    private final void initViews(Context context, int selectType) {
        if (selectType >= 0 && selectType <= 2) {
            this.mSelectType = selectType;
        }
        float firstNumberPickerWeight = this.mSelectType == 0 ? 2.0f : 1.0f;
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setOrientation(0);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.mNumberPicker1 = new NumberPickerReflect(context);
        this.setCustom(this.mNumberPicker1);
        layout2.addView((View)this.mNumberPicker1, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, firstNumberPickerWeight));
        this.mNumberPicker2 = new NumberPickerReflect(context);
        this.setCustom(this.mNumberPicker2);
        layout2.addView((View)this.mNumberPicker2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.mNumberPicker3 = new NumberPickerReflect(context);
        this.setCustom(this.mNumberPicker3);
        layout2.addView((View)this.mNumberPicker3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.addView((View)layout2);
    }

    private void setCustom(NumberPickerReflect numberPicker) {
        numberPicker.setDividerColor(this.dividerColor);
        numberPicker.setTextColor(this.textColor);
        if (this.maxHeight > 0) {
            numberPicker.setMaxHeight(this.maxHeight);
        }
        if (this.dividerDistance > 0) {
            numberPicker.setDividerDistance(this.dividerDistance);
        }
        if (this.textSize > 0) {
            numberPicker.setTextSize(this.textSize);
        }
        numberPicker.setTypeface(Typeface.create((String)this.FAMILY_NAME[this.typeface], (int)this.textStyle));
        ViewConfiguration cfg = ViewConfiguration.get((Context)this.getContext());
        numberPicker.setMaximumFlingVelocity(cfg.getScaledMaximumFlingVelocity() / this.friction);
    }

    private void updateDateControl() {
        this.mNumberPicker1.setDisplayedValues(null);
        this.mNumberPicker1.setMinValue(0);
        this.mNumberPicker1.setMaxValue(6);
        String[] displayValues = new String[7];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mDate.getTimeInMillis());
        cal.add(6, -3);
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = (String)DateFormat.format((CharSequence)"M\u6708dd\u65e5 EEEE", (Calendar)cal);
            cal.add(6, 1);
        }
        this.mNumberPicker1.setDisplayedValues(displayValues);
        this.mNumberPicker1.setValue(3);
        this.mNumberPicker1.invalidate();
    }

    private void updateYearControl() {
        this.mNumberPicker1.setDisplayedValues(null);
        this.mNumberPicker1.setMinValue(0);
        this.mNumberPicker1.setMaxValue(9);
        String[] displayValues = new String[10];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mDate.getTimeInMillis());
        cal.add(1, -5);
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = (String)DateFormat.format((CharSequence)"yyyy\u5e74", (Calendar)cal);
            cal.add(1, 1);
        }
        this.mNumberPicker1.setDisplayedValues(displayValues);
        this.mNumberPicker1.setValue(5);
        this.mNumberPicker1.invalidate();
    }

    private void updateMonthControl() {
        this.mNumberPicker2.setDisplayedValues(null);
        this.mNumberPicker2.setMaxValue(11);
        this.mNumberPicker2.setMinValue(0);
        String[] displayValues = new String[12];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mDate.getTimeInMillis());
        cal.set(2, 0);
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = (String)DateFormat.format((CharSequence)"M\u6708", (Calendar)cal);
            cal.add(2, 1);
        }
        this.mNumberPicker2.setDisplayedValues(displayValues);
        this.mNumberPicker2.setValue(this.mDate.get(2));
        this.mNumberPicker2.invalidate();
    }

    private void updateDayControl() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mDate.getTimeInMillis());
        cal.set(5, 1);
        int maxDay = cal.getActualMaximum(5);
        this.mNumberPicker3.setDisplayedValues(null);
        this.mNumberPicker3.setMaxValue(maxDay);
        this.mNumberPicker3.setMinValue(1);
        String[] displayValues = new String[maxDay];
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = (String)DateFormat.format((CharSequence)"d\u65e5", (Calendar)cal);
            cal.add(5, 1);
        }
        this.mNumberPicker3.setDisplayedValues(displayValues);
        this.mNumberPicker3.setValue(this.mDate.get(5));
        this.mNumberPicker3.invalidate();
    }

    private void updateHourControl() {
        this.mNumberPicker2.setDisplayedValues(null);
        this.mNumberPicker2.setMaxValue(23);
        this.mNumberPicker2.setMinValue(0);
        String[] displayValues = new String[24];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mDate.getTimeInMillis());
        cal.set(11, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("HH\u65f6");
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = sdf.format(cal.getTime());
            cal.add(11, 1);
        }
        this.mNumberPicker2.setDisplayedValues(displayValues);
        this.mNumberPicker2.setValue(this.mDate.get(11));
        this.mNumberPicker2.invalidate();
    }

    private void updateMinuteControl() {
        this.mNumberPicker3.setDisplayedValues(null);
        this.mNumberPicker3.setMaxValue(59);
        this.mNumberPicker3.setMinValue(0);
        String[] displayValues = new String[60];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mDate.getTimeInMillis());
        cal.set(12, 0);
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = (String)DateFormat.format((CharSequence)"mm\u5206", (Calendar)cal);
            cal.add(12, 1);
        }
        this.mNumberPicker3.setDisplayedValues(displayValues);
        this.mNumberPicker3.setValue(this.mDate.get(12));
        this.mNumberPicker3.invalidate();
    }

    private void onDateTimeChanged() {
        if (this.mOnDateTimeChangedListener != null) {
            this.mOnDateTimeChangedListener.onDateTimeChanged(this, this.mDate.get(1), this.mDate.get(2), this.mDate.get(5), this.mDate.get(11), this.mDate.get(12));
        }
    }

    public static interface OnDateTimeChangedListener {
        public void onDateTimeChanged(DateTimePicker var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static class PickerOptions {
        public int selectType;
        public long date = System.currentTimeMillis();
        @ColorInt
        public int dividerColor = -9254682;
        public int dividerDistance;
        public int maxHeight;
        public int textSize;
        public int typeface;
        public int textStyle;
        @ColorInt
        public int textColor = -16777216;
        public int friction = 8;

        public PickerOptions() {
        }

        public PickerOptions(int selectType) {
            this.selectType = selectType;
        }
    }
}

