/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.szboanda.android.platform.util.DimensionUtils;

public class SingleCharStampDrawer {
    private float circleStrokeWidth = 2.0f;
    private float textStrokeWidth = 1.0f;
    private boolean isBgFill = false;
    private Paint mPaint;
    private float padding = -1.0f;
    private boolean drawCircle = true;
    private int mStampColor = -65536;
    private Context mContext;
    private String mText;
    float mTextWidth = -1.0f;
    float mWidth = -1.0f;
    float mHeight = -1.0f;

    public SingleCharStampDrawer(Context context) {
        this.mContext = context;
        this.initDrawPaint();
    }

    private void initDrawPaint() {
        this.mPaint = new Paint();
        float textSize = TypedValue.applyDimension((int)2, (float)18.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        this.mPaint.setTextSize(textSize);
        this.mPaint.setColor(this.mStampColor);
        this.mPaint.setAntiAlias(true);
    }

    public SingleCharStampDrawer setText(String text) {
        this.mText = text;
        return this;
    }

    public SingleCharStampDrawer setTextSize(float textSize) {
        this.mPaint.setTextSize(textSize);
        return this;
    }

    public SingleCharStampDrawer setStampColor(int stampColor) {
        this.mStampColor = stampColor;
        return this;
    }

    public SingleCharStampDrawer setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public SingleCharStampDrawer setBackgroudFill(boolean fill) {
        this.isBgFill = fill;
        return this;
    }

    private void measureDimesion() {
        this.mTextWidth = this.mPaint.measureText(this.mText);
        if (this.padding == -1.0f) {
            this.padding = this.mTextWidth * 2.0f / 3.0f;
        }
        this.mWidth = this.mTextWidth + this.padding * 2.0f;
        this.mHeight = this.drawCircle ? this.mWidth : this.mWidth + (float)DimensionUtils.dip2Px(this.mContext, 5);
    }

    public Bitmap drawStamp() {
        this.measureDimesion();
        float x2 = this.mWidth / 2.0f;
        float y = this.mHeight / 2.0f;
        this.mPaint.setColor(this.mStampColor);
        this.mPaint.setStyle(this.isBgFill ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.circleStrokeWidth);
        float radius = this.mWidth / 3.0f;
        Bitmap b = Bitmap.createBitmap((int)((int)this.mWidth), (int)((int)this.mHeight), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(b);
        canvas.drawCircle(x2, y, radius, this.mPaint);
        canvas.save();
        canvas.restore();
        this.mPaint.setStrokeWidth(this.textStrokeWidth);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setTypeface(Typeface.DEFAULT);
        if (this.isBgFill) {
            this.mPaint.setColor(-1);
        }
        Paint.FontMetrics metrics = this.mPaint.getFontMetrics();
        float th = Math.abs(metrics.ascent) + metrics.descent;
        float txs = x2 - this.mTextWidth / 2.0f;
        float tys = (this.mWidth - th) / 2.0f + Math.abs(metrics.ascent);
        canvas.drawText(this.mText, txs, tys, this.mPaint);
        canvas.save();
        return b;
    }
}

