/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.view.BindableViewHandler;
import com.szboanda.android.platform.view.IBindableView;
import com.szboanda.android.platform.view.LabelDrawer;

public class PropertyView
extends EditText
implements IBindableView {
    public static final String KEY_LABEL = "LABEL";
    public static final String KEY_VALUE = "VALUE";
    private static final int DEFAULT_LABEL_COLOR = -10066330;
    private boolean drawTextBg = false;
    private float mTextBgRadius;
    private int mTextBgColor;
    private boolean isEditable = true;
    private KeyListener mKeyListener;
    protected BindableViewHandler mBindHandler;
    private LabelDrawer mLabelDrawer;
    private boolean isLabelAlignRight = false;
    RectF mTextBgBound = null;
    Paint mTextBgPaint = null;

    public PropertyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public PropertyView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.initWithAttributeSet(attrs);
    }

    public PropertyView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.mKeyListener = this.getKeyListener();
        this.mTextBgRadius = DimensionUtils.dip2Px(this.getContext(), 3);
        this.mTextBgColor = -2236963;
        this.mTextBgBound = new RectF();
        this.mTextBgPaint = new Paint();
        this.mTextBgPaint.setAntiAlias(true);
        this.mTextBgPaint.setStyle(Paint.Style.FILL);
        this.mTextBgPaint.setColor(this.mTextBgColor);
        int defaultPadding = DimensionUtils.dip2Px(this.getContext(), 5);
        this.setPadding(defaultPadding, this.getPaddingTop(), defaultPadding, this.getPaddingTop());
        this.mBindHandler = new BindableViewHandler(this);
        this.mLabelDrawer = new LabelDrawer();
        this.mLabelDrawer.setLabelSize(this.getPaint().getTextSize());
    }

    private void initWithAttributeSet(AttributeSet attrs) {
        String namespace;
        String layoutBackground;
        this.mBindHandler.initWithTypedArray(this.getResources(), attrs);
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.PropertyView);
        this.isEditable = ta.getBoolean(R.styleable.PropertyView_editable, true);
        String label = ta.getString(R.styleable.PropertyView_labelText);
        int labelTextColor = ta.getColor(R.styleable.PropertyView_labelTextColor, -10066330);
        int labelWeight = ta.getInt(R.styleable.PropertyView_labelWeight, -1);
        int labelPaddingLeft = (int)ta.getDimension(R.styleable.PropertyView_labelPaddingLeft, 0.0f);
        int labelMarginRight = (int)ta.getDimension(R.styleable.PropertyView_labelMarginRight, 0.0f);
        this.mTextBgRadius = ta.getDimension(R.styleable.PropertyView_radius, this.mTextBgRadius);
        this.mTextBgColor = ta.getColor(R.styleable.PropertyView_textBgColor, this.mTextBgColor);
        labelMarginRight = (int)ta.getDimension(R.styleable.PropertyView_marginBetweenLabelText, (float)labelMarginRight);
        this.drawTextBg = ta.getBoolean(R.styleable.PropertyView_drawTextBg, false);
        this.isLabelAlignRight = ta.getBoolean(R.styleable.PropertyView_labelAlignRight, false);
        this.mTextBgPaint.setColor(this.mTextBgColor);
        ta.recycle();
        if (!this.isEditable) {
            this.setKeyListener(null);
        }
        if (!TextUtils.isEmpty((CharSequence)label)) {
            label = label + "\uff1a";
        }
        if (TextUtils.isEmpty((CharSequence)(layoutBackground = attrs.getAttributeValue(namespace = "http://schemas.android.com/apk/res/android", "background")))) {
            int plr = this.getPaddingLeft();
            int ptb = this.getPaddingTop();
            this.setBackgroundColor(0);
            this.setPadding(plr, ptb, plr, ptb);
        }
        this.mLabelDrawer = new LabelDrawer(label);
        this.mLabelDrawer.setLabelSize(this.getPaint().getTextSize());
        this.mLabelDrawer.setLableTextColor(labelTextColor);
        this.mLabelDrawer.setLabelWeight(labelWeight);
        this.mLabelDrawer.setLabelPaddingLeft(labelPaddingLeft);
        this.mLabelDrawer.setLabelMarginRight(labelMarginRight);
        this.mLabelDrawer.setHorizontalAlignRight(this.isLabelAlignRight);
    }

    public void setLabel(String label) {
        this.mLabelDrawer.setLabel(label + "\uff1a");
    }

    public void setLableTextColor(int color2) {
        this.mLabelDrawer.setLableTextColor(color2);
    }

    public void setLabelWeight(int labelWeight) {
        this.mLabelDrawer.setLabelWeight(labelWeight > 50 ? 50 : labelWeight);
    }

    public void setLabelPaddingLeft(int padding) {
        this.mLabelDrawer.setLabelPaddingLeft(padding);
    }

    public void setLabelMarginRight(int margin) {
        this.mLabelDrawer.setLabelMarginRight(margin);
    }

    public void setTextBgColor(int color2) {
        this.mTextBgColor = color2;
        this.mTextBgPaint.setColor(color2);
    }

    public void setTextBgRadius(int radius) {
        this.mTextBgRadius = radius;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (editable) {
            this.setKeyListener(this.mKeyListener);
        } else {
            this.setKeyListener(null);
        }
    }

    public void setDrawTextBg(boolean drawTextBg) {
        this.drawTextBg = drawTextBg;
    }

    public void setHorizontalAlignRight(boolean isHorizontalAlignRight) {
        this.mLabelDrawer.setHorizontalAlignRight(isHorizontalAlignRight);
    }

    public void setLabelAlignVerticalCenter(boolean isLabelAlignVerticalCenter) {
        this.mLabelDrawer.setLabelAlignVerticalCenter(isLabelAlignVerticalCenter);
    }

    public LabelDrawer getLabelDrawer() {
        return this.mLabelDrawer;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.mLabelDrawer.measureLabel((View)this, this.getMeasuredWidth(), this.getMeasuredHeight());
        this.setMeasuredDimension(this.getMeasuredWidth(), height);
    }

    protected void onDraw(Canvas canvas) {
        if (this.drawTextBg) {
            this.drawTextBackground(canvas);
        }
        super.onDraw(canvas);
        this.mLabelDrawer.drawLabel(canvas);
    }

    private void drawTextBackground(Canvas canvas) {
        canvas.save();
        canvas.restore();
        this.mTextBgBound.set((float)(this.mLabelDrawer.getAdjustedPadding() - this.mLabelDrawer.getOriginalPaddingLeft()), 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        canvas.drawRoundRect(this.mTextBgBound, this.mTextBgRadius, this.mTextBgRadius, this.mTextBgPaint);
    }

    @Override
    public void setField(String field) {
        this.mBindHandler.setField(field);
    }

    @Override
    public void setEmptyMsg(String notEmptyTipMsg) {
        this.mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
    }

    @Override
    public void setBindValue(String value) {
        this.setText(value);
    }

    @Override
    public String getBindValue() {
        return this.getText().toString();
    }

    @Override
    public BindableViewHandler getBindHandler() {
        return this.mBindHandler;
    }
}

