/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.szboanda.android.platform.view.BindableViewHandler;
import com.szboanda.android.platform.view.IBindableView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class CustomViewBinder {
    public static final String NAMESPACE = "http://schemas.android.com/apk/res/";
    public static final String NAMESPACE_AUTO = "http://schemas.android.com/apk/res-auto";
    private View rootView;
    private Map<String, String> notEmptyMsgs = new LinkedHashMap<String, String>();
    private List<View> valueIsEmptyViews = new ArrayList<View>();

    public CustomViewBinder() {
    }

    public CustomViewBinder(View rootView) {
        this.rootView = rootView;
    }

    public void recursiveFetchJson(JSONObject result) {
        this.clearNotEmptyMsg();
        this.recursiveFetchJson(this.rootView, result);
    }

    public void recursiveFetchJson(View v, JSONObject result) {
        this.recursiveFetchJson(v, result, null);
    }

    public void recursiveFetchJson(View v, JSONObject result, IKeyConvertor convertor) {
        if (v instanceof ViewGroup) {
            ViewGroup curGroup = (ViewGroup)v;
            for (int i = 0; i < curGroup.getChildCount(); ++i) {
                View forView = curGroup.getChildAt(i);
                if (forView instanceof IBindableView) {
                    String key;
                    IBindableView customView = (IBindableView)forView;
                    BindableViewHandler bindHandler = customView.getBindHandler();
                    bindHandler.setKeyConvert(convertor);
                    String notEmptyMsg = bindHandler.appendValue(result);
                    if (TextUtils.isEmpty((CharSequence)notEmptyMsg) || TextUtils.isEmpty((CharSequence)(key = bindHandler.getField()))) continue;
                    this.notEmptyMsgs.put(key, notEmptyMsg);
                    this.valueIsEmptyViews.add(forView);
                    continue;
                }
                if (!(forView instanceof ViewGroup)) continue;
                this.recursiveFetchJson(forView, result, convertor);
            }
        }
    }

    public void recursiveBindData(JSONObject json, boolean isEnable) {
        this.recursiveBindData(this.rootView, json, isEnable);
    }

    public void recursiveBindData(View vg, JSONObject json, boolean isEnable) {
        this.recursiveBindData(vg, json, isEnable, null);
    }

    public void recursiveBindData(View vg, JSONObject json, boolean isEnable, IKeyConvertor convertor) {
        if (vg instanceof ViewGroup) {
            ViewGroup curGroup = (ViewGroup)vg;
            for (int i = 0; i < curGroup.getChildCount(); ++i) {
                View cv = curGroup.getChildAt(i);
                if (cv instanceof IBindableView) {
                    IBindableView customView = (IBindableView)cv;
                    BindableViewHandler bindHandler = customView.getBindHandler();
                    bindHandler.setKeyConvert(convertor);
                    bindHandler.bindValue(json, isEnable);
                    continue;
                }
                if (!(cv instanceof ViewGroup)) continue;
                this.recursiveBindData(cv, json, isEnable, convertor);
            }
        }
    }

    public void clearNotEmptyMsg() {
        this.notEmptyMsgs.clear();
        this.valueIsEmptyViews.clear();
    }

    public String getNotEmptyMsg() {
        String result = "";
        if (this.notEmptyMsgs.size() > 0) {
            Set<String> keys = this.notEmptyMsgs.keySet();
            for (String k : keys) {
                String v = this.notEmptyMsgs.get(k);
                result = result + "\n" + v;
            }
        }
        if (result.startsWith("\n")) {
            result = result.substring(1);
        }
        return result;
    }

    public List<View> getValueIsEmptyViews() {
        return this.valueIsEmptyViews;
    }

    public static interface IKeyConvertable {
        public String acceptConvert(IKeyConvertor var1);
    }

    public static interface IKeyConvertor {
        public String convertKey(IKeyConvertable var1);
    }
}

