/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Method;

public class ViewUtils {
    public static <E> E findViewAutoConvert(View rv, int id2) {
        View v = rv.findViewById(id2);
        return (E)(v == null ? null : v);
    }

    public static int[] measureView(View v) {
        int[] size = new int[2];
        if (v != null) {
            int width = 0;
            int height = 0;
            int wmode = 0;
            int hmode = 0;
            ViewGroup.LayoutParams params = v.getLayoutParams();
            if (params != null) {
                if (params.width == -2) {
                    wmode = Integer.MIN_VALUE;
                    width = 0x3FFFFFFF;
                } else if (params.width > 0) {
                    wmode = 0x40000000;
                    width = params.width;
                }
                if (params.height == -2) {
                    hmode = Integer.MIN_VALUE;
                    height = 0x3FFFFFFF;
                } else if (params.height > 0) {
                    hmode = 0x40000000;
                    height = params.height;
                }
            }
            width = View.MeasureSpec.makeMeasureSpec((int)width, (int)wmode);
            height = View.MeasureSpec.makeMeasureSpec((int)height, (int)hmode);
            v.measure(width, height);
            size[0] = v.getMeasuredWidth();
            size[1] = v.getMeasuredHeight();
        }
        return size;
    }

    public static Bitmap getViewBitmap(View view) {
        if (view == null) {
            return null;
        }
        view.setDrawingCacheEnabled(true);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap cacheBitmap = view.getDrawingCache();
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)cacheBitmap);
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static Bitmap createSnapshot(View view) {
        Bitmap bitmap = null;
        if (view != null) {
            Class<?> cls = view.getClass();
            while (!cls.getName().equals("android.view.View")) {
                cls = cls.getSuperclass();
            }
            try {
                Method method = cls.getDeclaredMethod("createSnapshot", Bitmap.Config.class, Integer.TYPE, Boolean.TYPE);
                method.setAccessible(true);
                bitmap = (Bitmap)method.invoke((Object)view, Bitmap.Config.ARGB_8888, -1, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bitmap;
    }

    public static void crossFadeIn(@NonNull View inView, long duration) {
        if (inView != null) {
            inView.setAlpha(0.0f);
            inView.setVisibility(0);
            inView.animate().alpha(1.0f).setDuration(duration).setListener(null);
        }
    }

    public static void crossFadeOut(final @NonNull View outView, long duration) {
        if (outView != null) {
            outView.animate().alpha(0.0f).setDuration(duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    outView.setVisibility(8);
                }
            });
        }
    }

    public static void crossFade(@NonNull View inView, final @NonNull View outView, long duration) {
        if (inView != null) {
            inView.setAlpha(0.0f);
            inView.setVisibility(0);
            inView.animate().alpha(1.0f).setDuration(duration).setListener(null);
        }
        if (outView != null) {
            outView.animate().alpha(0.0f).setDuration(duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    outView.setVisibility(8);
                }
            });
        }
    }
}

