/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.app.Activity;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorLoader;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.widget.Toast;
import java.io.File;

public class SystemFunctionHelper {
    public static void startupCamera(Activity activity, int requestCode) {
        SystemFunctionHelper.startupCameraWithPath(activity, requestCode, null);
    }

    public static void startupCameraWithPath(Activity activity, int requestCode, String extraPath) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (extraPath != null) {
            String name = new File(extraPath).getName();
            String dirPath = extraPath.replace(name, "");
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File saveFile = new File(extraPath);
            Uri saveFileUri = Uri.fromFile((File)saveFile);
            intent.putExtra("output", (Parcelable)saveFileUri);
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startupRecordSound(Activity activity, int requestCode) {
        try {
            Intent intent = new Intent("android.provider.MediaStore.RECORD_SOUND");
            activity.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)"\u6253\u5f00\u7cfb\u7edf\u5f55\u97f3\u5931\u8d25", (int)0).show();
        }
    }

    public static void startupSoundRecorder(Activity activity, int requestCode) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setPackage("com.android.soundrecorder");
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startupVideo(Activity activity, int requestCode) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startupVideo(Activity activity, int requestCode, int videoQuality) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        intent.putExtra("android.intent.extra.videoQuality", videoQuality);
        activity.startActivityForResult(intent, requestCode);
    }

    public static String getFileFromUri(Activity activity, Intent data) {
        if (data != null) {
            Uri uri = data.getData();
            String[] proj = new String[]{"_data"};
            CursorLoader cursorLoader = new CursorLoader((Context)activity, uri, proj, null, null, null);
            Cursor imageCursor = cursorLoader.loadInBackground();
            int columnIndex = imageCursor.getColumnIndexOrThrow("_data");
            imageCursor.moveToFirst();
            String path = imageCursor.getString(columnIndex);
            return path;
        }
        return "";
    }

    public static void startupImageStoreForPath(Activity activity, int requestCode) {
        Intent intent = new Intent("android.intent.action.PICK", null);
        intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
        activity.startActivityForResult(intent, requestCode);
    }

    public static void cropImg(Activity activity, Uri cropImg, String extraPath, int requestCode) {
        SystemFunctionHelper.cropImg(activity, cropImg, extraPath, -1, -1, requestCode);
    }

    public static void cropImg(Activity activity, Uri cropImg, String extraPath, int width, int height, int requestCode) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(cropImg, "image/*");
        intent.putExtra("crop", "true");
        if (width > 0 && height > 0) {
            intent.putExtra("aspectX", width);
            intent.putExtra("aspectY", height);
            intent.putExtra("outputX", width);
            intent.putExtra("outputY", height);
        }
        intent.putExtra("noFaceDetection", true);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)new File(extraPath)));
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startDialNumber(Context context, String number) {
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)("tel:" + number)));
        context.startActivity(intent);
    }

    public static void startSendMessage(Context context, String number, String message) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)("smsto:" + number)));
        if (!TextUtils.isEmpty((CharSequence)message)) {
            intent.putExtra("sms_body", message);
        }
        context.startActivity(intent);
    }

    public static void startSendMail(Context context, String address) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)("mailto:" + address)));
        context.startActivity(intent);
    }

    public static void startShare(Context context, Uri data) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.setType("*/*");
        sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)data);
        context.startActivity(sendIntent);
    }

    public static void addContact(Context context, String name, String bmmc, String phone, String bgdh) {
        ContentValues values = new ContentValues();
        Uri rawContactUri = context.getContentResolver().insert(ContactsContract.RawContacts.CONTENT_URI, values);
        if (rawContactUri == null) {
            Toast.makeText((Context)context, (CharSequence)"\u8bf7\u68c0\u67e5SIM\u5361", (int)1).show();
            return;
        }
        long rawContactId = ContentUris.parseId((Uri)rawContactUri);
        values.clear();
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("mimetype", "vnd.android.cursor.item/name");
        values.put("data2", name);
        context.getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
        values.clear();
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("mimetype", "vnd.android.cursor.item/phone_v2");
        values.put("data1", phone);
        values.put("data2", Integer.valueOf(2));
        context.getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
        values.clear();
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("mimetype", "vnd.android.cursor.item/phone_v2");
        values.put("data1", bgdh);
        values.put("data2", Integer.valueOf(3));
        context.getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
        values.clear();
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("mimetype", "vnd.android.cursor.item/organization");
        values.put("data5", bmmc);
        values.put("data2", Integer.valueOf(1));
        context.getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
    }

    public static void backToHomeDesktop(Context context) {
        Intent home = new Intent("android.intent.action.MAIN");
        home.addCategory("android.intent.category.HOME");
        home.setFlags(0x4000000);
        context.startActivity(home);
    }
}

