/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Vibrator;
import com.baidu.location.BDLocation;
import com.szboanda.android.platform.util.LocationHelper;
import java.util.List;

public class SensorLocationHelper {
    private SensorManager sensorManager;
    private Vibrator vibrator;
    private LocationHelper locationHelper;
    private SensorEventListener sensorelistener = new SensorEventListener(){

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        public void onSensorChanged(SensorEvent event) {
            int sensorType = event.sensor.getType();
            int shakeSenseValue = 16;
            float[] values = event.values;
            if (sensorType == 1 && (Math.abs(values[0]) > (float)shakeSenseValue || Math.abs(values[1]) > (float)shakeSenseValue || Math.abs(values[2]) > (float)shakeSenseValue)) {
                SensorLocationHelper.this.vibrator.vibrate(500L);
                SensorLocationHelper.this.locationHelper.startLocation(SensorLocationHelper.this.pLocationListener);
            }
        }
    };
    private LocationHelper.PinLocationListener pLocationListener = new LocationHelper.PinLocationListener(){

        @Override
        public void onSucess(BDLocation location) {
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public SensorLocationHelper(Context context, LocationHelper locationHelper) {
        this.locationHelper = locationHelper;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
        List sensors = this.sensorManager.getSensorList(1);
        if (sensors != null && sensors.size() == 0) {
            return;
        }
    }

    public void setPinLocationListener(LocationHelper.PinLocationListener pLocationListener) {
        this.pLocationListener = pLocationListener;
    }

    public void registerListener() {
        this.sensorManager.registerListener(this.sensorelistener, this.sensorManager.getDefaultSensor(1), 3);
    }

    public void unRegisterListener() {
        this.sensorManager.unregisterListener(this.sensorelistener);
    }
}

