/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.widget.Toast;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class NetworkUtils {
    public static boolean isNetworkOpened(Context context) {
        return NetworkUtils.isNetworkOpened(context, -1);
    }

    public static boolean isWifiTurnOn(Context context) {
        return NetworkUtils.isNetworkOpened(context, 1);
    }

    public static boolean isNetworkOpened(Context context, int explicitType) {
        int type;
        ConnectivityManager conManager;
        NetworkInfo network;
        boolean isconnect = false;
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(0);
        types.add(1);
        if (explicitType != -1) {
            types.clear();
            types.add(explicitType);
        }
        if ((network = (conManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && network.isConnected() && types.contains(type = network.getType())) {
            isconnect = true;
        }
        return isconnect;
    }

    public static String getNetworkState(Context context) {
        String netState = "";
        ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo network = conManager.getActiveNetworkInfo();
        netState = network != null ? network.getState().toString() : NetworkInfo.State.DISCONNECTED.toString();
        return netState;
    }

    public static void setMobileDataEnabled(Context context, boolean state) {
        NetworkUtils.setMobileDataEnabled(context, state, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setMobileDataEnabled(Context context, boolean state, Runnable callback) {
        try {
            ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            Class<?> cmClass = mConnectivityManager.getClass();
            Class[] argClasses = new Class[]{Boolean.TYPE};
            Method method = cmClass.getMethod("setMobileDataEnabled", argClasses);
            method.invoke((Object)mConnectivityManager, state);
            if (callback == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)context, (CharSequence)"\u5f00\u542f\u79fb\u52a8\u7f51\u7edc\u51fa\u9519\uff01", (int)0).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validHostConnected(String serviceUrl) {
        boolean isConnected = false;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(serviceUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            if (conn.getResponseCode() == 200) {
                isConnected = true;
            }
            System.out.println("\u9a8c\u8bc1\u7f51\u7edc\u8fde\u63a5!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            conn.disconnect();
            conn = null;
            Object url = null;
        }
        return isConnected;
    }

    public static boolean turnOnWifi(Context context) {
        return NetworkUtils.toggleWifi(context, true);
    }

    public static boolean turnOffWifi(Context context) {
        return NetworkUtils.toggleWifi(context, false);
    }

    private static boolean toggleWifi(Context context, boolean enable) {
        if (context != null) {
            WifiManager wm = (WifiManager)context.getSystemService("wifi");
            return wm.setWifiEnabled(enable);
        }
        return false;
    }
}

